/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.linsol.qr;

import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.decomposition.TriangularSolver_DDRM;
import org.ejml.dense.row.decomposition.qr.QRDecompositionHouseholderColumn_DDRM;
import org.ejml.dense.row.decomposition.qr.QrHelperFunctions_DDRM;
import org.ejml.dense.row.linsol.LinearSolverAbstract_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;

public class LinearSolverQrHouseCol_DDRM
extends LinearSolverAbstract_DDRM {
    protected final QRDecompositionHouseholderColumn_DDRM decomposer;
    protected final DMatrixRMaj a = new DMatrixRMaj(1, 1);
    protected final DMatrixRMaj temp = new DMatrixRMaj(1, 1);
    protected int maxRows = -1;
    protected int maxCols = -1;
    protected double[][] QR;
    protected final DMatrixRMaj R = new DMatrixRMaj(1, 1);
    protected double[] gammas;

    public LinearSolverQrHouseCol_DDRM() {
        this(new QRDecompositionHouseholderColumn_DDRM());
    }

    protected LinearSolverQrHouseCol_DDRM(QRDecompositionHouseholderColumn_DDRM decomposer) {
        this.decomposer = decomposer;
    }

    public void setMaxSize(int maxRows, int maxCols) {
        this.maxRows = maxRows;
        this.maxCols = maxCols;
    }

    @Override
    public boolean setA(DMatrixRMaj A2) {
        if (A2.numRows < A2.numCols) {
            throw new IllegalArgumentException("Can't solve for wide systems.  More variables than equations.");
        }
        if (A2.numRows > this.maxRows || A2.numCols > this.maxCols) {
            this.setMaxSize(A2.numRows, A2.numCols);
        }
        this.R.reshape(A2.numCols, A2.numCols);
        this.a.reshape(A2.numRows, 1);
        this.temp.reshape(A2.numRows, 1);
        this._setA(A2);
        if (!this.decomposer.decompose(A2)) {
            return false;
        }
        this.gammas = this.decomposer.getGammas();
        this.QR = this.decomposer.getQR();
        this.decomposer.getR(this.R, true);
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps_DDRM.qualityTriangular(this.R);
    }

    @Override
    public void solve(DMatrixRMaj B, DMatrixRMaj X2) {
        if (B.numRows != this.numRows) {
            throw new IllegalArgumentException("Unexpected dimensions for X: X rows = " + X2.numRows + " expected = " + this.numRows);
        }
        X2.reshape(this.numCols, B.numCols);
        int BnumCols = B.numCols;
        for (int colB = 0; colB < BnumCols; ++colB) {
            int i;
            for (i = 0; i < this.numRows; ++i) {
                this.a.data[i] = B.data[i * BnumCols + colB];
            }
            for (int n = 0; n < this.numCols; ++n) {
                double[] u = this.QR[n];
                QrHelperFunctions_DDRM.rank1UpdateMultR_u0(this.a, u, 1.0, this.gammas[n], 0, n, this.numRows, this.temp.data);
            }
            TriangularSolver_DDRM.solveU(this.R.data, this.a.data, this.numCols);
            for (i = 0; i < this.numCols; ++i) {
                X2.data[i * X2.numCols + colB] = this.a.data[i];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public QRDecomposition<DMatrixRMaj> getDecomposition() {
        return this.decomposer;
    }
}

