/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decompose;

import org.ejml.data.CMatrixRMaj;
import org.ejml.dense.row.CommonOps_CDRM;
import org.jetbrains.annotations.Nullable;

public class UtilDecompositons_CDRM {
    public static CMatrixRMaj checkIdentity(@Nullable CMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return CommonOps_CDRM.identity(numRows, numCols);
        }
        if (numRows != A2.numRows || numCols != A2.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        CommonOps_CDRM.setIdentity(A2);
        return A2;
    }

    public static CMatrixRMaj checkZeros(@Nullable CMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return new CMatrixRMaj(numRows, numCols);
        }
        if (numRows != A2.numRows || numCols != A2.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        A2.zero();
        return A2;
    }

    public static CMatrixRMaj checkZerosLT(@Nullable CMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return new CMatrixRMaj(numRows, numCols);
        }
        if (numRows != A2.numRows || numCols != A2.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        for (int i = 0; i < A2.numRows; ++i) {
            int index = i * A2.numCols * 2;
            int end = index + Math.min(i, A2.numCols) * 2;
            while (index < end) {
                A2.data[index++] = 0.0f;
            }
        }
        return A2;
    }

    public static CMatrixRMaj checkZerosUT(@Nullable CMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return new CMatrixRMaj(numRows, numCols);
        }
        if (numRows != A2.numRows || numCols != A2.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        int maxRows = Math.min(A2.numRows, A2.numCols);
        for (int i = 0; i < maxRows; ++i) {
            int index = (i * A2.numCols + i + 1) * 2;
            int end = (i * A2.numCols + A2.numCols) * 2;
            while (index < end) {
                A2.data[index++] = 0.0f;
            }
        }
        return A2;
    }
}

