/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArrayList;

public class FastArray<T>
extends FastAccess<T> {
    private final FastArrayList<T> list = new FastArrayList(this);

    public FastArray(Class<T> type, int initialMaxSize) {
        super(type);
        this.size = 0;
        this.data = (Object[])Array.newInstance(type, initialMaxSize);
    }

    public FastArray(Class<T> type) {
        this(type, 10);
    }

    public void set(int index, T value) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Out of bounds. index=" + index + " max size " + this.size);
        }
        this.data[index] = value;
    }

    public void add(T value) {
        if (this.size >= this.data.length) {
            this.reserve((this.data.length + 1) * 2);
        }
        this.data[this.size++] = value;
    }

    @Override
    public T remove(int index) {
        Object removed = this.data[index];
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        this.data[this.size - 1] = null;
        --this.size;
        return (T)removed;
    }

    @Override
    public T removeSwap(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Out of bounds. index=" + index + " max size " + this.size);
        }
        Object ret = this.data[index];
        --this.size;
        this.data[index] = this.data[this.size];
        this.data[this.size] = null;
        return (T)ret;
    }

    public boolean remove(T target) {
        int index = this.indexOf(target);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public T removeTail() {
        if (this.size <= 0) {
            throw new IllegalArgumentException("The array is empty");
        }
        --this.size;
        Object ret = this.data[this.size];
        this.data[this.size] = null;
        return (T)ret;
    }

    public void reset() {
        this.size = 0;
    }

    public void clear() {
        Arrays.fill(this.data, 0, this.size, null);
        this.size = 0;
    }

    public void reserve(int length) {
        this.reserve(length, true);
    }

    public void reserve(int length, boolean copy) {
        if (this.data.length >= length) {
            return;
        }
        Object[] data = (Object[])Array.newInstance(this.type, length);
        if (copy) {
            System.arraycopy(this.data, 0, data, 0, this.size);
        }
        this.data = data;
    }

    public void resize(int length) {
        this.reserve(length);
        this.size = length;
    }

    public void resize(int length, T value) {
        this.reserve(length, false);
        Arrays.fill(this.data, 0, length, value);
        this.size = length;
    }

    public void addAll(FastAccess<T> list) {
        for (int i = 0; i < list.size; ++i) {
            this.add(list.data[i]);
        }
    }

    public void add(T[] array, int first, int length) {
        for (int i = 0; i < length; ++i) {
            this.add(array[first + i]);
        }
    }

    public void addAll(List<T> list) {
        int originalSize = this.size;
        this.resize(this.size + list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.data[originalSize + i] = list.get(i);
        }
    }

    @Override
    public List<T> toList() {
        return this.list;
    }
}

