/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import org.ddogleg.struct.DogArrayPrimitive;

public class DogArray_I8
implements DogArrayPrimitive<DogArray_I8> {
    public byte[] data;
    public int size;

    public DogArray_I8(int maxSize) {
        this.data = new byte[maxSize];
        this.size = 0;
    }

    public DogArray_I8() {
        this(10);
    }

    public static DogArray_I8 zeros(int length) {
        DogArray_I8 out = new DogArray_I8(length);
        out.size = length;
        return out;
    }

    public static DogArray_I8 array(int ... values) {
        DogArray_I8 out = DogArray_I8.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = (byte)values[i];
        }
        return out;
    }

    public int count(int value) {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            ++total;
        }
        return total;
    }

    public boolean isEquals(byte ... values) {
        if (this.size != values.length) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == values[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    public void addAll(DogArray_I8 queue) {
        if (this.size + queue.size > this.data.length) {
            byte[] temp = new byte[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(byte[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array");
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            byte[] temp = new byte[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(int value) {
        this.push(value);
    }

    public void push(int val2) {
        if (this.size == this.data.length) {
            byte[] temp = new byte[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = (byte)val2;
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public int getTail(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[this.size - index - 1];
    }

    public int getFraction(double fraction) {
        return this.get((int)((double)(this.size - 1) * fraction));
    }

    public int unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        this.data[index] = (byte)value;
    }

    @Override
    public void setTo(DogArray_I8 original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    public void setTo(byte[] array, int offset, int length) {
        this.resize(length);
        System.arraycopy(array, offset, this.data, 0, length);
    }

    public DogArray_I8 setTo(byte ... src) {
        this.setTo(src, 0, src.length);
        return this;
    }

    public byte[] toArray() {
        byte[] out = new byte[this.size];
        System.arraycopy(this.data, 0, out, 0, this.size);
        return out;
    }

    public void insert(int index, int value) {
        if (this.size == this.data.length) {
            byte[] temp = new byte[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = (byte)value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = (byte)value;
        }
    }

    public byte removeSwap(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Out of bounds. index=" + index + " max size " + this.size);
        }
        byte ret = this.data[index];
        --this.size;
        this.data[index] = this.data[this.size];
        return ret;
    }

    public byte removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public void remove(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("first <= last");
        }
        if (last >= this.size) {
            throw new IllegalArgumentException("last must be less than the max size");
        }
        int delta = last - first + 1;
        for (int i = last + 1; i < this.size; ++i) {
            this.data[i - delta] = this.data[i];
        }
        this.size -= delta;
    }

    public void fill(byte value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void fill(int idx0, int idx1, byte value) {
        Arrays.fill(this.data, idx0, idx1, value);
    }

    public boolean contains(byte value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new byte[size];
        }
        this.size = size;
    }

    public void resize(int size, byte value) {
        this.resize(size);
        this.fill(value);
    }

    @Override
    public void extend(int size) {
        this.reserve(size);
        this.size = size;
    }

    @Override
    public void reserve(int amount) {
        if (this.data.length >= amount) {
            return;
        }
        byte[] tmp = new byte[amount];
        System.arraycopy(this.data, 0, tmp, 0, this.size);
        this.data = tmp;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int pop() {
        return this.data[--this.size];
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.size, (byte)0);
    }

    @Override
    public DogArray_I8 copy() {
        DogArray_I8 ret = new DogArray_I8(this.size);
        ret.setTo(this);
        return ret;
    }

    @Override
    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D2 = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D2) {
            byte tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public void printHex() {
        System.out.print("[ ");
        for (int i = 0; i < this.size; ++i) {
            System.out.printf("0x%02X ", this.data[i]);
        }
        System.out.print("]");
    }

    public static DogArray_I8 parseHex(String message) {
        message = message.replaceAll("\\[", "");
        message = message.replaceAll("\\]", "");
        message = message.replaceAll(" ", "");
        String[] words = message.split(",");
        DogArray_I8 out = new DogArray_I8(words.length);
        out.size = words.length;
        for (int i = 0; i < words.length; ++i) {
            out.data[i] = Integer.decode(words[i]).byteValue();
        }
        return out;
    }

    public int indexOf(byte value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public void forIdx(FunctionEachIdx func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(i, this.data[i]);
        }
    }

    public void forEach(FunctionEach func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(this.data[i]);
        }
    }

    public void applyIdx(FunctionApplyIdx func) {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = func.process(i, this.data[i]);
        }
    }

    @FunctionalInterface
    public static interface FunctionEachIdx {
        public void process(int var1, byte var2);
    }

    @FunctionalInterface
    public static interface FunctionEach {
        public void process(byte var1);
    }

    @FunctionalInterface
    public static interface FunctionApplyIdx {
        public byte process(int var1, byte var2);
    }
}

