/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.solver.RootFinderType;
import org.ddogleg.solver.impl.FindRealRootsSturm;
import org.ddogleg.solver.impl.RootFinderCompanion;
import org.ddogleg.solver.impl.SturmSequence;
import org.ddogleg.solver.impl.WrapRealRootsSturm;
import org.jetbrains.annotations.Nullable;

public class PolynomialOps {
    public static double quadraticVertex(double a, double b) {
        return -b / (2.0 * a);
    }

    public static Polynomial derivative(Polynomial poly, @Nullable Polynomial deriv) {
        if (deriv == null) {
            deriv = new Polynomial(poly.size - 1);
        } else {
            deriv.size = poly.size - 1;
        }
        for (int i = 1; i < poly.size; ++i) {
            deriv.c[i - 1] = poly.c[i] * (double)i;
        }
        return deriv;
    }

    public static double refineRoot(Polynomial poly, double root, int maxIterations) {
        Polynomial deriv = new Polynomial(poly.size());
        PolynomialOps.derivative(poly, deriv);
        for (int i = 0; i < maxIterations; ++i) {
            double v = poly.evaluate(root);
            double d = deriv.evaluate(root);
            if (d == 0.0) {
                return root;
            }
            root -= v / d;
        }
        return root;
    }

    public static void divide(Polynomial numerator, Polynomial denominator, Polynomial quotient, Polynomial remainder) {
        int nd;
        if (denominator.size <= 0) {
            throw new IllegalArgumentException("Trying to device by a polynomial of size 0");
        }
        int nn = numerator.size - 1;
        for (nd = denominator.size - 1; nd >= 0 && denominator.c[nd] == 0.0; --nd) {
        }
        if (nd < 0) {
            throw new IllegalArgumentException("Divide by zero error");
        }
        quotient.size = nn - nd + 1;
        remainder.setTo(numerator);
        for (int k = nn - nd; k >= 0; --k) {
            if (nd < 0 || k < 0) {
                System.out.println("EGADS");
            }
            double c = quotient.c[k] = remainder.c[nd + k] / denominator.c[nd];
            for (int j = k + nd; j >= k; --j) {
                int n = j;
                remainder.c[n] = remainder.c[n] - c * denominator.c[j - k];
            }
        }
        remainder.size = nd;
    }

    public static Polynomial multiply(Polynomial a, Polynomial b, @Nullable Polynomial result) {
        int N = Math.max(0, a.size() + b.size() - 1);
        if (result == null) {
            result = new Polynomial(N);
        } else {
            if (result.size < N) {
                throw new IllegalArgumentException("Unexpected length of 'result'");
            }
            result.zero();
        }
        for (int i = 0; i < a.size; ++i) {
            double coef = a.c[i];
            int index = i;
            for (int j = 0; j < b.size; ++j) {
                int n = index++;
                result.c[n] = result.c[n] + coef * b.c[j];
            }
        }
        return result;
    }

    public static Polynomial add(Polynomial a, Polynomial b, @Nullable Polynomial results) {
        int i;
        int N = Math.max(a.size, b.size);
        if (results == null) {
            results = new Polynomial(N);
        } else {
            if (results.size < N) {
                throw new IllegalArgumentException("storage for results must be at least as large as the the largest polynomial");
            }
            for (int i2 = N; i2 < results.size; ++i2) {
                results.c[i2] = 0.0;
            }
        }
        int M = Math.min(a.size, b.size);
        for (i = 0; i < M; ++i) {
            results.c[i] = a.c[i] + b.c[i];
        }
        if (a.size > b.size) {
            for (i = b.size; i < N; ++i) {
                results.c[i] = a.c[i];
            }
        } else {
            for (i = a.size; i < N; ++i) {
                results.c[i] = b.c[i];
            }
        }
        return results;
    }

    public static int countRealRoots(Polynomial poly) {
        SturmSequence sturm = new SturmSequence(poly.size);
        sturm.initialize(poly);
        return sturm.countRealRoots(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static PolynomialRoots createRootFinder(int maxCoefficients, RootFinderType which) {
        switch (which) {
            case STURM: {
                FindRealRootsSturm sturm = new FindRealRootsSturm(maxCoefficients, -1.0, 1.0E-10, 200, 200);
                return new WrapRealRootsSturm(sturm);
            }
            case EVD: {
                return new RootFinderCompanion();
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + (Object)((Object)which));
    }

    public static double cubicRealRoot(double c0, double c1, double c2, double c3) {
        double p = c2 / c3;
        double q = c1 / c3;
        double r = c0 / c3;
        double a = (3.0 * q - p * p) / 3.0;
        double b = (2.0 * p * p * p - 9.0 * p * q + 27.0 * r) / 27.0;
        double left = -b / 2.0;
        double right = Math.sqrt(b * b / 4.0 + a * a * a / 27.0);
        double inner1 = left + right;
        double inner2 = left - right;
        double A2 = inner1 < 0.0 ? -Math.pow(-inner1, 0.3333333333333333) : Math.pow(inner1, 0.3333333333333333);
        double B = inner2 < 0.0 ? -Math.pow(-inner2, 0.3333333333333333) : Math.pow(inner2, 0.3333333333333333);
        return A2 + B - p / 3.0;
    }
}

