/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.trustregion;

import java.io.PrintStream;
import org.ddogleg.optimization.OptimizationException;
import org.ddogleg.optimization.trustregion.TrustRegionBase_F64;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class TrustRegionUpdateDogleg_F64<S extends DMatrix>
implements TrustRegionBase_F64.ParameterUpdate<S> {
    protected TrustRegionBase_F64<S, ?> owner;
    protected double minimumFunctionValue;
    protected DMatrixRMaj direction = new DMatrixRMaj(1, 1);
    protected double gBg;
    protected DMatrixRMaj stepGN = new DMatrixRMaj(1, 1);
    protected double distanceGN;
    protected DMatrixRMaj stepCauchy = new DMatrixRMaj(1, 1);
    protected boolean positiveDefinite;
    double distanceCauchy;
    double predictedReduction;
    double stepLength;
    @Nullable
    PrintStream verbose = null;

    @Override
    public void initialize(TrustRegionBase_F64<S, ?> owner, int numberOfParameters, double minimumFunctionValue) {
        this.owner = owner;
        this.minimumFunctionValue = minimumFunctionValue;
        this.direction.reshape(numberOfParameters, 1);
        this.stepGN.reshape(numberOfParameters, 1);
        this.stepCauchy.reshape(numberOfParameters, 1);
    }

    @Override
    public void initializeUpdate() {
        CommonOps_DDRM.divide(this.owner.gradient, this.owner.gradientNorm, this.direction);
        this.gBg = this.owner.hessian.innerVectorHessian(this.direction);
        if (UtilEjml.isUncountable(this.gBg)) {
            throw new OptimizationException("Uncountable. gBg=" + this.gBg);
        }
        if (this.gBg > 0.0 && this.solveGaussNewtonPoint(this.stepGN)) {
            this.positiveDefinite = true;
            this.distanceCauchy = this.owner.gradientNorm / this.gBg;
            CommonOps_DDRM.scale(-1.0, this.stepGN);
            this.distanceGN = NormOps_DDRM.normF(this.stepGN);
        } else {
            this.positiveDefinite = false;
        }
    }

    protected boolean solveGaussNewtonPoint(DMatrixRMaj pointGN) {
        if (!this.owner.hessian.initializeSolver()) {
            return false;
        }
        if (!this.owner.hessian.solve(this.direction, pointGN)) {
            return false;
        }
        CommonOps_DDRM.scale(this.owner.gradientNorm, pointGN);
        return true;
    }

    @Override
    public void computeUpdate(DMatrixRMaj step, double regionRadius) {
        if (this.positiveDefinite) {
            if (this.distanceGN <= regionRadius) {
                if (this.verbose != null) {
                    this.verbose.println("   newton");
                }
                this.gaussNewtonStep(step);
            } else if (this.distanceCauchy >= regionRadius) {
                if (this.verbose != null) {
                    this.verbose.println("   cauchy");
                }
                this.cauchyStep(regionRadius, step);
            } else {
                if (this.verbose != null) {
                    this.verbose.println("   combined");
                }
                this.combinedStep(regionRadius, step);
            }
        } else {
            if (this.verbose != null) {
                this.verbose.println("   not positive-definite. gBg=" + this.gBg);
            }
            this.stepLength = regionRadius;
            CommonOps_DDRM.scale(-this.stepLength, this.direction, step);
            this.predictedReduction = this.stepLength * this.owner.gradientNorm - 0.5 * this.stepLength * this.stepLength * this.gBg;
        }
    }

    protected void gaussNewtonStep(DMatrixRMaj step) {
        step.set(this.stepGN);
        this.predictedReduction = this.owner.computePredictedReduction(this.stepGN);
        this.stepLength = this.distanceGN;
    }

    @Override
    public double getPredictedReduction() {
        return this.predictedReduction;
    }

    @Override
    public double getStepLength() {
        return this.stepLength;
    }

    @Override
    public void setVerbose(@Nullable PrintStream verbose, int level) {
        this.verbose = verbose;
    }

    protected void cauchyStep(double regionRadius, DMatrixRMaj step) {
        CommonOps_DDRM.scale(-regionRadius, this.direction, step);
        this.stepLength = regionRadius;
        this.predictedReduction = regionRadius * (this.owner.gradientNorm - 0.5 * regionRadius * this.gBg);
    }

    protected void combinedStep(double regionRadius, DMatrixRMaj step) {
        CommonOps_DDRM.scale(-this.distanceCauchy, this.direction, this.stepCauchy);
        this.stepLength = regionRadius;
        double distancePtoGN = SpecializedOps_DDRM.diffNormF(this.stepCauchy, this.stepGN);
        double f = TrustRegionUpdateDogleg_F64.fractionCauchyToGN(this.distanceCauchy, this.distanceGN, distancePtoGN, regionRadius);
        CommonOps_DDRM.add(1.0 - f, this.stepCauchy, f, this.stepGN, step);
        this.predictedReduction = this.owner.computePredictedReduction(step);
    }

    static double fractionCauchyToGN(double lengthCauchy, double lengthGN, double lengthPtoGN, double region) {
        double a = lengthGN;
        double b = lengthCauchy;
        double c = lengthPtoGN;
        double cosineA = (a * a - b * b - c * c) / (-2.0 * b * c);
        double angleA = Math.acos(cosineA);
        a = region;
        double angleB = Math.asin(b / a * Math.sin(angleA));
        double angleC = Math.PI - angleA - angleB;
        c = Math.sqrt(a * a + b * b - 2.0 * a * b * Math.cos(angleC));
        return c / lengthPtoGN;
    }
}

