/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.quasinewton;

import java.io.PrintStream;
import org.ddogleg.optimization.LineSearch;
import org.ddogleg.optimization.functions.GradientLineFunction;
import org.ddogleg.optimization.quasinewton.EquationsBFGS;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class QuasiNewtonBFGS {
    private int N;
    private double ftol;
    private double gtol;
    private GradientLineFunction function;
    private LineSearch lineSearch;
    private double funcMinValue;
    private double derivAtZero;
    private DMatrixRMaj B;
    private DMatrixRMaj searchVector;
    private DMatrixRMaj g;
    private DMatrixRMaj s;
    private DMatrixRMaj y;
    private DMatrixRMaj x;
    private double fx;
    private DMatrixRMaj temp0_Nx1;
    private DMatrixRMaj temp1_Nx1;
    private int mode;
    @Nullable
    private PrintStream verbose;
    private int verboseLevel;
    private boolean hasConverged;
    private int iterations;
    private boolean updated;
    double initialStep;
    double maxStep;
    boolean firstStep;

    public QuasiNewtonBFGS(LineSearch lineSearch) {
        this.lineSearch = lineSearch;
    }

    public void setFunction(GradientLineFunction function, double funcMinValue) {
        this.function = function;
        this.funcMinValue = funcMinValue;
        this.lineSearch.setFunction(function, funcMinValue);
        this.N = function.getN();
        this.B = new DMatrixRMaj(this.N, this.N);
        this.searchVector = new DMatrixRMaj(this.N, 1);
        this.g = new DMatrixRMaj(this.N, 1);
        this.s = new DMatrixRMaj(this.N, 1);
        this.y = new DMatrixRMaj(this.N, 1);
        this.x = new DMatrixRMaj(this.N, 1);
        this.temp0_Nx1 = new DMatrixRMaj(this.N, 1);
        this.temp1_Nx1 = new DMatrixRMaj(this.N, 1);
    }

    public void setConvergence(double ftol, double gtol) {
        if (ftol < 0.0) {
            throw new IllegalArgumentException("ftol < 0");
        }
        if (gtol < 0.0) {
            throw new IllegalArgumentException("gtol < 0");
        }
        this.ftol = ftol;
        this.gtol = gtol;
    }

    public void setInitialHInv(DMatrixRMaj Hinverse) {
        this.B.set(Hinverse);
    }

    public void initialize(double[] initial) {
        this.mode = 0;
        this.hasConverged = false;
        this.iterations = 0;
        this.s.zero();
        CommonOps_DDRM.setIdentity(this.B);
        System.arraycopy(initial, 0, this.x.data, 0, this.N);
        this.function.setInput(this.x.data);
        this.fx = this.function.computeFunction();
        this.updated = false;
        if (this.verbose != null) {
            this.verbose.println("Steps     fx        change      |step|   f-test     g-test    max-step ");
            this.verbose.printf("%-4d  %9.3E  %10.3E  %9.3E  %9.3E  %9.3E  %6.2f\n", this.iterations, this.fx, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public double[] getParameters() {
        return this.x.data;
    }

    public boolean iterate() {
        this.updated = false;
        if (this.mode == 0) {
            return this.computeSearchDirection();
        }
        return this.performLineSearch();
    }

    private boolean computeSearchDirection() {
        this.function.computeGradient(this.temp0_Nx1.data);
        for (int i = 0; i < this.N; ++i) {
            this.y.data[i] = this.temp0_Nx1.data[i] - this.g.data[i];
            this.g.data[i] = this.temp0_Nx1.data[i];
        }
        if (this.iterations != 0) {
            EquationsBFGS.inverseUpdate(this.B, this.s, this.y, this.temp0_Nx1, this.temp1_Nx1);
        }
        CommonOps_DDRM.mult(-1.0, this.B, this.g, this.searchVector);
        if (!this.setupLineSearch(this.fx, this.x.data, this.g.data, this.searchVector.data)) {
            this.resetMatrixB();
            CommonOps_DDRM.mult(-1.0, this.B, this.g, this.searchVector);
            this.setupLineSearch(this.fx, this.x.data, this.g.data, this.searchVector.data);
        } else if (Math.abs(this.derivAtZero) <= this.gtol) {
            if (this.verbose != null) {
                this.verbose.printf("finished select direction, gtest=%e\n", Math.abs(this.derivAtZero));
            }
            System.arraycopy(this.function.getCurrentState(), 0, this.x.data, 0, this.N);
            return this.terminateSearch(true);
        }
        this.mode = 1;
        ++this.iterations;
        return false;
    }

    private void resetMatrixB() {
        int i;
        double maxDiag = 0.0;
        for (i = 0; i < this.N; ++i) {
            double d = Math.abs(this.B.get(i, i));
            if (!(d > maxDiag)) continue;
            maxDiag = d;
        }
        this.B.zero();
        for (i = 0; i < this.N; ++i) {
            this.B.set(i, i, maxDiag);
        }
    }

    private boolean setupLineSearch(double funcAtStart, double[] startPoint, double[] startDeriv, double[] direction) {
        this.derivAtZero = 0.0;
        for (int i = 0; i < this.N; ++i) {
            this.derivAtZero += startDeriv[i] * direction[i];
        }
        if (this.derivAtZero > 0.0) {
            return false;
        }
        if (this.derivAtZero == 0.0) {
            return true;
        }
        this.function.setLine(startPoint, direction);
        this.maxStep = (this.funcMinValue - funcAtStart) / (this.lineSearch.getGTol() * this.derivAtZero);
        this.initialStep = 1.0 < this.maxStep ? 1.0 : this.maxStep;
        this.invokeLineInitialize(funcAtStart, this.maxStep);
        return true;
    }

    private void invokeLineInitialize(double funcAtStart, double maxStep) {
        this.function.setInput(this.initialStep);
        double funcAtInit = this.function.computeFunction();
        this.lineSearch.init(funcAtStart, this.derivAtZero, funcAtInit, this.initialStep, 0.0, maxStep);
        this.firstStep = true;
    }

    private boolean performLineSearch() {
        if (this.lineSearch.iterate()) {
            if (!this.lineSearch.isConverged()) {
                if (this.firstStep) {
                    this.initialStep /= 2.0;
                    if (this.initialStep != 0.0) {
                        this.invokeLineInitialize(this.fx, this.maxStep);
                        return false;
                    }
                    if (this.verbose != null && this.verboseLevel != 0) {
                        this.verbose.println("Initial step reduced to zero");
                    }
                    return this.terminateSearch(false);
                }
                return this.terminateSearch(false);
            }
            this.firstStep = false;
            double step = this.lineSearch.getStep();
            System.arraycopy(this.function.getCurrentState(), 0, this.x.data, 0, this.N);
            for (int i = 0; i < this.N; ++i) {
                this.s.data[i] = step * this.searchVector.data[i];
            }
            this.updated = true;
            double fstp = this.lineSearch.getFunction();
            if (this.verbose != null) {
                double actualStep = NormOps_DDRM.fastNormF(this.s);
                double ftest_val = Math.abs(fstp - this.fx) / Math.abs(this.fx);
                double gtest_val = Math.abs(this.derivAtZero);
                this.verbose.printf("%-4d  %9.3E  %10.3E  %9.3E  %9.3E  %9.3E  %6.3f\n", this.iterations, fstp, fstp - this.fx, actualStep, ftest_val, gtest_val, this.maxStep);
            }
            if (Math.abs(fstp - this.fx) <= this.ftol * Math.abs(this.fx) || Math.abs(this.derivAtZero) < this.gtol) {
                if (this.verbose != null) {
                    this.verbose.println("converged after line search.");
                }
                return this.terminateSearch(true);
            }
            if (fstp > this.fx) {
                throw new RuntimeException("Bug! Worse results!");
            }
            this.fx = fstp;
            this.mode = 0;
        }
        return false;
    }

    private boolean terminateSearch(boolean converged) {
        this.hasConverged = converged;
        return true;
    }

    public boolean isConverged() {
        return this.hasConverged;
    }

    public double getFx() {
        return this.fx;
    }

    public boolean isUpdatedParameters() {
        return this.updated;
    }

    public void setVerbose(@Nullable PrintStream out, int level) {
        this.verbose = out;
        if (level != 0) {
            this.lineSearch.setVerbose(out, level);
        }
    }

    public LineSearch getLineSearch() {
        return this.lineSearch;
    }

    public double getFuncMinValue() {
        return this.funcMinValue;
    }
}

