/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UnconstrainedLeastSquaresSchur;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ddogleg.optimization.lm.UnconLeastSqLevenbergMarquardtSchur_F64;
import org.ddogleg.optimization.lm.UnconLeastSqLevenbergMarquardt_F64;
import org.ddogleg.optimization.math.HessianLeastSquares_DSCC;
import org.ddogleg.optimization.math.HessianSchurComplement_DSCC;
import org.ddogleg.optimization.math.MatrixMath;
import org.ddogleg.optimization.math.MatrixMath_DSCC;
import org.ddogleg.optimization.trustregion.ConfigTrustRegion;
import org.ddogleg.optimization.trustregion.TrustRegionBase_F64;
import org.ddogleg.optimization.trustregion.TrustRegionUpdateCauchy_F64;
import org.ddogleg.optimization.trustregion.TrustRegionUpdateDogleg_F64;
import org.ddogleg.optimization.trustregion.UnconLeastSqTrustRegionSchur_F64;
import org.ddogleg.optimization.trustregion.UnconLeastSqTrustRegion_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.FillReducing;
import org.ejml.sparse.csc.factory.LinearSolverFactory_DSCC;
import org.jetbrains.annotations.Nullable;

public class FactoryOptimizationSparse {
    public static UnconstrainedLeastSquaresSchur<DMatrixSparseCSC> doglegSchur(@Nullable ConfigTrustRegion config) {
        if (config == null) {
            config = new ConfigTrustRegion();
        }
        HessianSchurComplement_DSCC hessian = new HessianSchurComplement_DSCC();
        TrustRegionUpdateDogleg_F64 update = new TrustRegionUpdateDogleg_F64();
        UnconLeastSqTrustRegionSchur_F64<DMatrixSparseCSC> alg = new UnconLeastSqTrustRegionSchur_F64<DMatrixSparseCSC>((TrustRegionBase_F64.ParameterUpdate<DMatrixSparseCSC>)update, hessian);
        alg.configure(config);
        return alg;
    }

    public static UnconstrainedLeastSquares<DMatrixSparseCSC> dogleg(@Nullable ConfigTrustRegion config) {
        if (config == null) {
            config = new ConfigTrustRegion();
        }
        LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solver = LinearSolverFactory_DSCC.cholesky(FillReducing.NONE);
        HessianLeastSquares_DSCC hessian = new HessianLeastSquares_DSCC(solver);
        MatrixMath_DSCC math = new MatrixMath_DSCC();
        TrustRegionUpdateDogleg_F64 update = new TrustRegionUpdateDogleg_F64();
        UnconLeastSqTrustRegion_F64<DMatrixSparseCSC> alg = new UnconLeastSqTrustRegion_F64<DMatrixSparseCSC>(update, hessian, math);
        alg.configure(config);
        return alg;
    }

    public static UnconstrainedLeastSquares<DMatrixSparseCSC> cauchy(@Nullable ConfigTrustRegion config) {
        if (config == null) {
            config = new ConfigTrustRegion();
        }
        HessianLeastSquares_DSCC hessian = new HessianLeastSquares_DSCC();
        MatrixMath_DSCC math = new MatrixMath_DSCC();
        TrustRegionUpdateCauchy_F64 update = new TrustRegionUpdateCauchy_F64();
        UnconLeastSqTrustRegion_F64<DMatrixSparseCSC> alg = new UnconLeastSqTrustRegion_F64<DMatrixSparseCSC>(update, hessian, math);
        alg.configure(config);
        return alg;
    }

    public static UnconstrainedLeastSquares<DMatrixSparseCSC> levenbergMarquardt(@Nullable ConfigLevenbergMarquardt config) {
        if (config == null) {
            config = new ConfigLevenbergMarquardt();
        }
        LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solver = LinearSolverFactory_DSCC.cholesky(FillReducing.NONE);
        HessianLeastSquares_DSCC hessian = new HessianLeastSquares_DSCC(solver);
        UnconLeastSqLevenbergMarquardt_F64<DMatrixSparseCSC> lm = new UnconLeastSqLevenbergMarquardt_F64<DMatrixSparseCSC>((MatrixMath<DMatrixSparseCSC>)new MatrixMath_DSCC(), hessian);
        lm.configure(config);
        return lm;
    }

    public static UnconstrainedLeastSquaresSchur<DMatrixSparseCSC> levenbergMarquardtSchur(@Nullable ConfigLevenbergMarquardt config) {
        if (config == null) {
            config = new ConfigLevenbergMarquardt();
        }
        HessianSchurComplement_DSCC hessian = new HessianSchurComplement_DSCC();
        UnconLeastSqLevenbergMarquardtSchur_F64<DMatrixSparseCSC> lm = new UnconLeastSqLevenbergMarquardtSchur_F64<DMatrixSparseCSC>((MatrixMath<DMatrixSparseCSC>)new MatrixMath_DSCC(), hessian);
        lm.configure(config);
        return lm;
    }
}

