/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class VpTree
implements NearestNeighbor<double[]> {
    DogArray_I32 indexes;
    private double[][] items;
    @Nullable
    private Node root;
    private final Random random;

    public VpTree(long randSeed) {
        this.random = new Random(randSeed);
    }

    @Override
    public void setPoints(List<double[]> points, boolean trackIndicies) {
        this.items = (double[][])points.toArray((T[])new double[0][]);
        this.indexes = new DogArray_I32();
        this.indexes.resize(points.size());
        for (int i = 0; i < points.size(); ++i) {
            this.indexes.data[i] = i;
        }
        this.root = this.buildFromPoints(0, this.items.length);
    }

    @Nullable
    private Node buildFromPoints(int lower, int upper) {
        if (upper == lower) {
            return null;
        }
        Node node = new Node();
        node.index = lower;
        if (upper - lower > 1) {
            int i = this.random.nextInt(upper - lower - 1) + lower;
            this.listSwap((E[])this.items, lower, i);
            this.listSwap(this.indexes, lower, i);
            int median = (upper + lower + 1) / 2;
            this.nthElement(lower + 1, upper, median, this.items[lower]);
            node.threshold = VpTree.distance(this.items[lower], this.items[median]);
            node.index = lower;
            node.left = this.buildFromPoints(lower + 1, median);
            node.right = this.buildFromPoints(median, upper);
        }
        return node;
    }

    private void nthElement(int left, int right, int n, double[] origin) {
        int npos = this.partitionItems(left, right, n, origin);
        if (npos < n) {
            this.nthElement(npos + 1, right, n, origin);
        }
        if (npos > n) {
            this.nthElement(left, npos, n, origin);
        }
    }

    private int partitionItems(int left, int right, int pivot, double[] origin) {
        double pivotDistance = VpTree.distance(origin, this.items[pivot]);
        this.listSwap((E[])this.items, pivot, right - 1);
        this.listSwap(this.indexes, pivot, right - 1);
        int storeIndex = left;
        for (int i = left; i < right - 1; ++i) {
            if (!(VpTree.distance(origin, this.items[i]) <= pivotDistance)) continue;
            this.listSwap((E[])this.items, i, storeIndex);
            this.listSwap(this.indexes, i, storeIndex);
            ++storeIndex;
        }
        this.listSwap((E[])this.items, storeIndex, right - 1);
        this.listSwap(this.indexes, storeIndex, right - 1);
        return storeIndex;
    }

    private <E> void listSwap(E[] list, int a, int b) {
        E tmp = list[a];
        list[a] = list[b];
        list[b] = tmp;
    }

    private void listSwap(DogArray_I32 list, int a, int b) {
        int tmp = list.get(a);
        list.data[a] = list.data[b];
        list.data[b] = tmp;
    }

    @Override
    public NearestNeighbor.Search<double[]> createSearch() {
        return new InternalSearch();
    }

    private static double distance(double[] p1, double[] p2) {
        switch (p1.length) {
            case 2: {
                return Math.sqrt((p1[0] - p2[0]) * (p1[0] - p2[0]) + (p1[1] - p2[1]) * (p1[1] - p2[1]));
            }
            case 3: {
                return Math.sqrt((p1[0] - p2[0]) * (p1[0] - p2[0]) + (p1[1] - p2[1]) * (p1[1] - p2[1]) + (p1[2] - p2[2]) * (p1[2] - p2[2]));
            }
        }
        double dist = 0.0;
        for (int i = p1.length - 1; i >= 0; --i) {
            double d = p1[i] - p2[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    private static class Node {
        int index;
        double threshold;
        @Nullable
        Node left;
        @Nullable
        Node right;

        private Node() {
        }
    }

    private class InternalSearch
    implements NearestNeighbor.Search<double[]> {
        private InternalSearch() {
        }

        @Override
        public boolean findNearest(double[] point, double maxDistance, NnData<double[]> result) {
            boolean r = this.searchNearest(point, maxDistance < 0.0 ? Double.POSITIVE_INFINITY : Math.sqrt(maxDistance), result);
            result.distance *= result.distance;
            return r;
        }

        @Override
        public void findNearest(double[] target, double maxDistance, int numNeighbors, DogArray<NnData<double[]>> results) {
            results.reset();
            PriorityQueue<HeapItem> heap = this.search(target, maxDistance < 0.0 ? Double.POSITIVE_INFINITY : Math.sqrt(maxDistance), numNeighbors);
            while (!heap.isEmpty()) {
                HeapItem heapItem = heap.poll();
                NnData<double[]> objects = results.grow();
                objects.index = VpTree.this.indexes.get(heapItem.index);
                objects.point = VpTree.this.items[heapItem.index];
                objects.distance = heapItem.dist * heapItem.dist;
            }
            results.reverse();
        }

        private PriorityQueue<HeapItem> search(double[] target, double maxDistance, int k) {
            PriorityQueue<HeapItem> heap = new PriorityQueue<HeapItem>();
            if (VpTree.this.root == null) {
                return heap;
            }
            double tau = maxDistance;
            FastArray<Node> nodes = new FastArray<Node>(Node.class, 20);
            nodes.add(VpTree.this.root);
            while (nodes.size() > 0) {
                Node node = nodes.removeTail();
                double dist = VpTree.distance(VpTree.this.items[node.index], target);
                if (dist <= tau) {
                    if (heap.size() == k) {
                        heap.poll();
                    }
                    heap.add(new HeapItem(node.index, dist));
                    if (heap.size() == k) {
                        tau = ((HeapItem)heap.element()).dist;
                    }
                }
                if (node.left != null && dist - tau <= node.threshold) {
                    nodes.add(node.left);
                }
                if (node.right == null || !(dist + tau >= node.threshold)) continue;
                nodes.add(node.right);
            }
            return heap;
        }

        private boolean searchNearest(double[] target, double maxDistance, NnData<double[]> result) {
            if (VpTree.this.root == null) {
                return false;
            }
            double tau = maxDistance;
            FastArray<Node> nodes = new FastArray<Node>(Node.class, 20);
            nodes.add(VpTree.this.root);
            result.distance = Double.POSITIVE_INFINITY;
            boolean found = false;
            while (nodes.size() > 0) {
                Node node = (Node)nodes.getTail();
                nodes.removeTail();
                double dist = VpTree.distance(VpTree.this.items[node.index], target);
                if (dist <= tau && dist < result.distance) {
                    result.distance = dist;
                    result.index = VpTree.this.indexes.data[node.index];
                    result.point = VpTree.this.items[node.index];
                    tau = dist;
                    found = true;
                }
                if (node.left != null && dist - tau <= node.threshold) {
                    nodes.add(node.left);
                }
                if (node.right == null || !(dist + tau >= node.threshold)) continue;
                nodes.add(node.right);
            }
            return found;
        }
    }

    private static class HeapItem
    implements Comparable<HeapItem> {
        int index;
        double dist;

        HeapItem(int index, double dist) {
            this.index = index;
            this.dist = dist;
        }

        @Override
        public int compareTo(HeapItem o) {
            return (int)Math.signum(o.dist - this.dist);
        }
    }
}

