/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.ransac;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.InlierThreshold;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;

public class Ransac<Model, Point>
implements ModelMatcher<Model, Point>,
InlierThreshold {
    protected int sampleSize;
    protected double thresholdFit;
    protected ModelGenerator<Model, Point> modelGenerator;
    protected DistanceFromModel<Model, Point> modelDistance;
    protected Random rand;
    protected long randSeed;
    protected List<Point> candidatePoints = new ArrayList<Point>();
    protected List<Point> bestFitPoints = new ArrayList<Point>();
    protected Model bestFitParam;
    protected Model candidateParam;
    protected int maxIterations;
    protected List<Point> dataSet = new ArrayList<Point>();
    protected List<Point> initialSample = new ArrayList<Point>();
    protected int[] matchToInput = new int[1];
    protected int[] bestMatchToInput = new int[1];

    public Ransac(long randSeed, ModelManager<Model> modelManager, ModelGenerator<Model, Point> modelGenerator, DistanceFromModel<Model, Point> modelDistance, int maxIterations, double thresholdFit) {
        this.modelGenerator = modelGenerator;
        this.modelDistance = modelDistance;
        this.randSeed = randSeed;
        this.rand = new Random(randSeed);
        this.maxIterations = maxIterations;
        this.bestFitParam = modelManager.createModelInstance();
        this.candidateParam = modelManager.createModelInstance();
        this.sampleSize = modelGenerator.getMinimumPoints();
        this.thresholdFit = thresholdFit;
    }

    @Override
    public boolean process(List<Point> _dataSet) {
        if (_dataSet.size() < this.modelGenerator.getMinimumPoints()) {
            return false;
        }
        this.dataSet.clear();
        this.dataSet.addAll(_dataSet);
        this.initialize(this.dataSet);
        for (int i = 0; i < this.maxIterations && this.bestFitPoints.size() != this.dataSet.size(); ++i) {
            Ransac.randomDraw(this.dataSet, this.sampleSize, this.initialSample, this.rand);
            if (!this.modelGenerator.generate(this.initialSample, this.candidateParam) || !this.selectMatchSet(_dataSet, this.thresholdFit, this.candidateParam) || this.bestFitPoints.size() >= this.candidatePoints.size()) continue;
            this.swapCandidateWithBest();
        }
        return this.bestFitPoints.size() > 0;
    }

    public void initialize(List<Point> dataSet) {
        this.bestFitPoints.clear();
        if (dataSet.size() > this.matchToInput.length) {
            this.matchToInput = new int[dataSet.size()];
            this.bestMatchToInput = new int[dataSet.size()];
        }
    }

    public static <T> void randomDraw(List<T> dataSet, int numSample, List<T> initialSample, Random rand) {
        initialSample.clear();
        for (int i = 0; i < numSample; ++i) {
            int indexLast = dataSet.size() - i - 1;
            int indexSelected = rand.nextInt(indexLast + 1);
            T a = dataSet.get(indexSelected);
            initialSample.add(a);
            dataSet.set(indexSelected, dataSet.set(indexLast, a));
        }
    }

    protected boolean selectMatchSet(List<Point> dataSet, double threshold, Model param) {
        this.candidatePoints.clear();
        this.modelDistance.setModel(param);
        int maxFailures = dataSet.size() - this.bestFitPoints.size();
        for (int i = 0; i < dataSet.size() && maxFailures >= 0; ++i) {
            Point point = dataSet.get(i);
            double distance = this.modelDistance.distance(point);
            if (distance < threshold) {
                this.matchToInput[this.candidatePoints.size()] = i;
                this.candidatePoints.add(point);
                continue;
            }
            --maxFailures;
        }
        return maxFailures >= 0;
    }

    protected void swapCandidateWithBest() {
        List<Point> tempPts = this.candidatePoints;
        this.candidatePoints = this.bestFitPoints;
        this.bestFitPoints = tempPts;
        int[] tempIndex = this.matchToInput;
        this.matchToInput = this.bestMatchToInput;
        this.bestMatchToInput = tempIndex;
        Model m = this.candidateParam;
        this.candidateParam = this.bestFitParam;
        this.bestFitParam = m;
    }

    @Override
    public List<Point> getMatchSet() {
        return this.bestFitPoints;
    }

    @Override
    public int getInputIndex(int matchIndex) {
        return this.bestMatchToInput[matchIndex];
    }

    @Override
    public Model getModelParameters() {
        return this.bestFitParam;
    }

    @Override
    public double getFitQuality() {
        return this.bestFitPoints.size();
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public int getMinimumSize() {
        return this.sampleSize;
    }

    @Override
    public void reset() {
        this.rand = new Random(this.randSeed);
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    public double getThresholdFit() {
        return this.thresholdFit;
    }

    @Override
    public void setThresholdFit(double thresholdFit) {
        this.thresholdFit = thresholdFit;
    }

    @Override
    public Class<Point> getPointType() {
        return this.modelDistance.getPointType();
    }

    @Override
    public Class<Model> getModelType() {
        return this.modelDistance.getModelType();
    }
}

