/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.lmeds;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.InlierFraction;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.sorting.QuickSelect;

public class LeastMedianOfSquares<Model, Point>
implements ModelMatcher<Model, Point>,
InlierFraction {
    private Random rand;
    private long randSeed;
    private int totalCycles;
    private int sampleSize;
    private double maxMedianError;
    private ModelGenerator<Model, Point> generator;
    private DistanceFromModel<Model, Point> errorMetric;
    private List<Point> smallSet = new ArrayList<Point>();
    private Model candidate;
    private Model bestParam;
    private double bestMedian;
    private double errorFraction = 0.5;
    protected List<Point> dataSet = new ArrayList<Point>();
    private double[] errors = new double[1];
    private int[] matchToInput = new int[1];
    private List<Point> inlierSet;
    private double inlierFrac;

    public LeastMedianOfSquares(long randSeed, int totalCycles, double maxMedianError, double inlierFraction, ModelManager<Model> modelManager, ModelGenerator<Model, Point> generator, DistanceFromModel<Model, Point> errorMetric) {
        this.randSeed = randSeed;
        this.rand = new Random(randSeed);
        this.totalCycles = totalCycles;
        this.maxMedianError = maxMedianError;
        this.inlierFrac = inlierFraction;
        this.generator = generator;
        this.errorMetric = errorMetric;
        this.bestParam = modelManager.createModelInstance();
        this.candidate = modelManager.createModelInstance();
        this.sampleSize = generator.getMinimumPoints();
        if (this.inlierFrac > 0.0) {
            this.inlierSet = new ArrayList<Point>();
        } else if (this.inlierFrac > 1.0) {
            throw new IllegalArgumentException("Inlier fraction must be <= 1");
        }
    }

    public LeastMedianOfSquares(long randSeed, int totalCycles, ModelManager<Model> modelManager, ModelGenerator<Model, Point> generator, DistanceFromModel<Model, Point> errorMetric) {
        this(randSeed, totalCycles, Double.MAX_VALUE, 0.0, modelManager, generator, errorMetric);
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    public boolean process(List<Point> _dataSet) {
        if (_dataSet.size() < this.sampleSize) {
            return false;
        }
        this.dataSet.clear();
        this.dataSet.addAll(_dataSet);
        int N = this.dataSet.size();
        if (this.errors.length < N) {
            this.errors = new double[N];
            this.matchToInput = new int[N];
        }
        this.bestMedian = Double.MAX_VALUE;
        for (int i = 0; i < this.totalCycles; ++i) {
            Ransac.randomDraw(this.dataSet, this.sampleSize, this.smallSet, this.rand);
            if (!this.generator.generate(this.smallSet, this.candidate)) continue;
            this.errorMetric.setModel(this.candidate);
            this.errorMetric.distances(_dataSet, this.errors);
            double median = QuickSelect.select(this.errors, (int)((double)N * this.errorFraction + 0.5), N);
            if (!(median < this.bestMedian)) continue;
            this.bestMedian = median;
            Model t = this.bestParam;
            this.bestParam = this.candidate;
            this.candidate = t;
        }
        this.computeInlierSet(_dataSet, N);
        return this.bestMedian <= this.maxMedianError;
    }

    private void computeInlierSet(List<Point> dataSet, int n) {
        int numPts = (int)((double)n * this.inlierFrac);
        if (this.inlierFrac > 0.0 && numPts > this.sampleSize) {
            this.inlierSet.clear();
            this.errorMetric.setModel(this.bestParam);
            this.errorMetric.distances(dataSet, this.errors);
            int[] indexes = new int[n];
            QuickSelect.selectIndex(this.errors, numPts, n, indexes);
            for (int i = 0; i < numPts; ++i) {
                int origIndex = indexes[i];
                this.inlierSet.add(dataSet.get(origIndex));
                this.matchToInput[i] = origIndex;
            }
        } else {
            this.inlierSet = dataSet;
        }
    }

    @Override
    public double getErrorFraction() {
        return this.errorFraction;
    }

    @Override
    public void setErrorFraction(double errorFraction) {
        this.errorFraction = errorFraction;
    }

    @Override
    public Model getModelParameters() {
        return this.bestParam;
    }

    @Override
    public List<Point> getMatchSet() {
        return this.inlierSet;
    }

    @Override
    public int getInputIndex(int matchIndex) {
        return this.matchToInput[matchIndex];
    }

    @Override
    public double getFitQuality() {
        return this.bestMedian;
    }

    @Override
    public int getMinimumSize() {
        return this.sampleSize;
    }

    @Override
    public void reset() {
        this.rand = new Random(this.randSeed);
    }

    @Override
    public Class<Point> getPointType() {
        return this.errorMetric.getPointType();
    }

    @Override
    public Class<Model> getModelType() {
        return this.errorMetric.getModelType();
    }
}

