/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.combinatorics;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Combinations<T> {
    protected List<T> a;
    protected int N;
    protected int k;
    protected int[] bins;
    protected int c;
    protected int state;

    public Combinations(List<T> a, int bucketSize) {
        this.init(a, bucketSize);
    }

    public Combinations() {
    }

    public final void init(List<T> list, int bucketSize) {
        if (list.size() < bucketSize) {
            throw new RuntimeException("There needs to be more than or equal to elements in the 'list' that there are in the bucket");
        }
        this.k = bucketSize;
        this.c = bucketSize - 1;
        this.N = list.size();
        this.bins = new int[bucketSize];
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i] = i;
        }
        this.a = list;
        this.state = 1;
    }

    public boolean next() {
        if (this.state == 2) {
            return false;
        }
        this.state = 1;
        int n = this.c;
        this.bins[n] = this.bins[n] + 1;
        if (this.bins[this.c] >= this.N) {
            boolean allgood = false;
            for (int i = this.c - 1; i >= 0; --i) {
                int n2 = i;
                this.bins[n2] = this.bins[n2] + 1;
                if (this.bins[i] > this.N - (this.k - i)) continue;
                allgood = true;
                for (int j = i + 1; j < this.k; ++j) {
                    this.bins[j] = this.bins[j - 1] + 1;
                }
                break;
            }
            if (!allgood) {
                this.state = 2;
                for (int j = 0; j < this.bins.length; ++j) {
                    this.bins[j] = j + this.N - this.bins.length;
                }
            }
            return allgood;
        }
        return true;
    }

    public boolean previous() {
        if (this.state == 0) {
            return false;
        }
        this.state = 1;
        for (int i = this.c; i >= 0; --i) {
            int n = i;
            this.bins[n] = this.bins[n] - 1;
            if (i == 0) {
                if (this.bins[0] >= 0) break;
                this.state = 0;
                for (int j = 0; j < this.bins.length; ++j) {
                    this.bins[j] = j;
                }
                return false;
            }
            if (this.bins[i] > this.bins[i - 1]) break;
            this.bins[i] = this.N - 1 - (this.c - i);
        }
        return true;
    }

    public long computeTotalCombinations() {
        return Combinations.computeTotalCombinations(this.a.size(), this.k);
    }

    public static long computeTotalCombinations(int setSize, int comboSize) {
        long numerator = setSize;
        long denominator = comboSize;
        for (int i = 1; i < comboSize; ++i) {
            numerator *= (long)(setSize - i);
            denominator *= (long)(comboSize - i);
        }
        return numerator / denominator;
    }

    public int getBucketSize() {
        return this.k;
    }

    public T get(int i) {
        return this.a.get(this.bins[i]);
    }

    public List<T> getBucket(@Nullable List<T> storage) {
        if (storage == null) {
            storage = new ArrayList<T>();
        } else {
            storage.clear();
        }
        for (int i = 0; i < this.bins.length; ++i) {
            storage.add(this.a.get(this.bins[i]));
        }
        return storage;
    }

    public List<T> getOutside(@Nullable List<T> storage) {
        if (storage == null) {
            storage = new ArrayList<T>();
        } else {
            storage.clear();
        }
        storage.addAll(this.a);
        for (int i = this.bins.length - 1; i >= 0; --i) {
            storage.remove(this.bins[i]);
        }
        return storage;
    }
}

