/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering;

import org.ddogleg.clustering.KMeansInitializers;
import org.ddogleg.clustering.gmm.ExpectationMaximizationGmm_F64;
import org.ddogleg.clustering.gmm.SeedFromKMeans_F64;
import org.ddogleg.clustering.kmeans.InitializeKMeans_F64;
import org.ddogleg.clustering.kmeans.InitializePlusPlus;
import org.ddogleg.clustering.kmeans.InitializeStandard_F64;
import org.ddogleg.clustering.kmeans.StandardKMeans_F64;
import org.jetbrains.annotations.Nullable;

public class FactoryClustering {
    public static ExpectationMaximizationGmm_F64 gaussianMixtureModelEM_F64(int maxIterations, int maxConverge, double convergeTol) {
        StandardKMeans_F64 kmeans = FactoryClustering.kMeans_F64(null, maxIterations, maxConverge, convergeTol);
        SeedFromKMeans_F64 seeds = new SeedFromKMeans_F64(kmeans);
        return new ExpectationMaximizationGmm_F64(maxIterations, convergeTol, seeds);
    }

    public static StandardKMeans_F64 kMeans_F64(@Nullable KMeansInitializers initializer, int maxIterations, int maxConverge, double convergeTol) {
        InitializeKMeans_F64 seed;
        if (initializer == null) {
            seed = new InitializePlusPlus();
        } else {
            switch (initializer) {
                case PLUS_PLUS: {
                    seed = new InitializePlusPlus();
                    break;
                }
                case STANDARD: {
                    seed = new InitializeStandard_F64();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown initializer " + (Object)((Object)initializer));
                }
            }
        }
        return new StandardKMeans_F64(maxIterations, maxConverge, convergeTol, seed);
    }
}

