/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.Coders;
import org.tukaani.xz.FinishableWrapperOutputStream;
import org.tukaani.xz.LZMA2InputStream;
import org.tukaani.xz.LZMA2Options;

class LZMA2Decoder
extends Coders.CoderBase {
    LZMA2Decoder() {
    }

    InputStream decode(InputStream in, Coder coder, byte[] password) throws IOException {
        int dictionarySizeBits = 0xFF & coder.properties[0];
        if ((dictionarySizeBits & 0xFFFFFFC0) != 0) {
            throw new IOException("Unsupported LZMA2 property bits");
        }
        if (dictionarySizeBits > 40) {
            throw new IOException("Dictionary larger than 4GiB maximum size");
        }
        int dictionarySize = dictionarySizeBits == 40 ? -1 : (2 | dictionarySizeBits & 1) << dictionarySizeBits / 2 + 11;
        return new LZMA2InputStream(in, dictionarySize);
    }

    OutputStream encode(OutputStream out, byte[] password) throws IOException {
        LZMA2Options options = new LZMA2Options();
        options.setDictSize(0x800000);
        FinishableWrapperOutputStream wrapped = new FinishableWrapperOutputStream(out);
        return options.getOutputStream(wrapped);
    }
}

