/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.utils;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import jiconfont.IconCode;
import jiconfont.icons.google_material_design_icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import mdlaf.utils.MaterialColors;
import sun.swing.ImageIconUIResource;

public class MaterialImageFactory {
    private static MaterialImageFactory SINGLETON;
    private static final String PATH_RESOUSES = "/imgs/";
    public static final String RIGHT_ARROW = "right_arrow";
    public static final String LEFT_ARROW = "left_arrow";
    public static final String DOWN_ARROW = "down_arrow";
    public static final String UP_ARROW = "up_arrow";
    public static final String CHECKED_BLACK_BOX = "painted_checked_box";
    public static final String UNCHECKED_BLACK_BOX = "unchecked_box";
    public static final String RADIO_BUTTON_BLACK_ON = "radio_button_on";
    public static final String RADIO_BUTTON_BLACK_OFF = "radio_button_off";
    public static final String TOGGLE_BUTTON_BLACK_ON = "toggle_on";
    public static final String TOGGLE_BUTTON_BLACK_OFF = "toggle_off";
    public static final String BACK_ARROW_BLACK = "back_arrow";
    public static final String COMPUTER_BLACK = "computer";
    public static final String FILE_BLACK = "file";
    public static final String FLOPPY_DRIVE_BLACK = "floppy_drive";
    public static final String FOLDER_BLACK = "folder";
    public static final String HARD_DRIVE_BLACK = "hard_drive";
    public static final String HOME_BLACK = "home";
    public static final String LIST_BLACK = "list";
    public static final String NEW_FOLDER_BLACK = "new_folder";
    public static final String DETAILS_BLACK = "details";
    public static final String YES_COLLAPSED = "yes-collapsed";
    public static final String NO_COLLAPSED = "no-collapsed";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String QUESTION = "question";
    public static final String INFORMATION = "information";
    public static final String CLOSE_WINDOWS_BLACK = "close-button";
    public static final String MAXIMIZE_WINDOWS_BLACK = "maximize";
    public static final String MINIMIZE_WINDOWS_BLACK = "minimize";
    public static final String ICONIFY_WINDOWS_BLACK = "restore";
    public static final String RADIO_BUTTON_WHITE_OFF = "white/radio_unchecked-white";
    public static final String CHECKED_WHITE_BOX = "white/checked_white";
    public static final String RADIO_BUTTON_WHITE_ON = "white/radio-checked-white";
    public static final String UNCHECKED_WHITE_BOX = "white/unchecked_white";
    public static final String BACK_ARROW_WHITE = "white/back_arrow";
    public static final String COMPUTER_WHITE = "white/computer";
    public static final String FILE_WHITE = "white/file";
    public static final String FLOPPY_DRIVE_WHITE = "white/floppy_drive";
    public static final String FOLDER_WHITE = "white/folder";
    public static final String HARD_DRIVE_WHITE = "white/hard_drive";
    public static final String HOME_WHITE = "white/home";
    public static final String LIST_WHITE = "white/list";
    public static final String NEW_FOLDER_WHITE = "white/new_folder";
    public static final String DETAILS_WHITE = "white/details";
    public static final String CLOSE_WINDOWS_WHITE = "white/close-button";
    public static final String MAXIMIZE_WINDOWS_WHITE = "white/maximize";
    public static final String MINIMIZE_WINDOWS_WHITE = "white/minimize";
    public static final String ICONIFY_WINDOWS_WHITE = "white/restore";
    public static final String TOGGLE_BUTTON_ON_WHITE = "white/toggle_on";
    public static final String TOGGLE_BUTTON_OFF_WHITE = "white/toggle_off";
    private Map<String, ImageIconUIResource> cacheImage = new HashMap<String, ImageIconUIResource>();

    public static void registerIcons(IconCode iconCode) {
        if (iconCode == null) {
            String errorMessage = "\n- Icon code null you can found the name icon here: https://jiconfont.github.io/\nAn example can be this IconFontSwing.register(GoogleMaterialDesignIcons.getIconFont());";
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static MaterialImageFactory getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new MaterialImageFactory();
        }
        return SINGLETON;
    }

    private MaterialImageFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageIconUIResource getImage(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument null");
        }
        String path = PATH_RESOUSES.trim() + key.trim() + ".png".trim();
        if (this.cacheImage.containsKey(path)) {
            return this.cacheImage.get(path);
        }
        try (InputStream inputStream = MaterialImageFactory.class.getResourceAsStream(path);){
            BufferedImage image = ImageIO.read(inputStream);
            this.cacheImage.put(path, new ImageIconUIResource(image));
            ImageIconUIResource imageIconUIResource = this.cacheImage.get(path);
            return imageIconUIResource;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Image " + path + " wasn't loaded");
        }
    }

    public ImageIconUIResource getImage(IconCode iconCode, int dimension, Color color) {
        String key;
        if (iconCode == null || dimension <= 0) {
            String errorMessage = "Don't know motivation this exceptions";
            if (iconCode == null) {
                if (errorMessage.contains("Don't know motivation this exceptions")) {
                    errorMessage = "";
                }
                errorMessage = errorMessage + "\n- Icon code null, you can found the name icon color here: https://material.io/resources/icons/?style=baseline\nan valid code can be this: MaterialImageFactory.getInstance().getImage(GoogleMaterialDesignIcons.KEYBOARD_ARROW_RIGHT, Color.BLUE);";
            }
            if (dimension <= 0) {
                if (errorMessage.contains("Don't know motivation this exceptions")) {
                    errorMessage = "";
                }
                errorMessage = errorMessage + "\n- Dimension of icon doesn't valid, you should insert the dimension > 0";
            }
            errorMessage = errorMessage + "\n\n";
            throw new IllegalArgumentException(errorMessage);
        }
        if (color == null) {
            color = MaterialColors.BLACK;
        }
        if (this.cacheImage.containsKey(key = iconCode.name() + dimension + color.toString())) {
            return this.cacheImage.get(key);
        }
        ImageIconUIResource icon = new ImageIconUIResource(IconFontSwing.buildImage(iconCode, dimension, color));
        this.cacheImage.put(key, icon);
        return icon;
    }

    public ImageIconUIResource getImage(IconCode iconCode, int dimension) {
        return this.getImage(iconCode, dimension, null);
    }

    public ImageIconUIResource getImage(IconCode iconCode) {
        return this.getImage(iconCode, 20, null);
    }

    public ImageIconUIResource getImage(IconCode iconCode, Color color) {
        return this.getImage(iconCode, 20, color);
    }

    static {
        IconFontSwing.register(GoogleMaterialDesignIcons.getIconFont());
    }
}

