/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.themes;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import jiconfont.IconCode;
import jiconfont.icons.google_material_design_icons.GoogleMaterialDesignIcons;
import mdlaf.shadows.DropShadowBorder;
import mdlaf.themes.AbstractMaterialTheme;
import mdlaf.utils.MaterialBorders;
import mdlaf.utils.MaterialColors;
import mdlaf.utils.MaterialFontFactory;
import mdlaf.utils.MaterialImageFactory;

public class MaterialOceanicTheme
extends AbstractMaterialTheme {
    @Override
    public void installTheme() {
        this.installColor();
        this.installFonts();
        this.installBorders();
        this.installIcons();
    }

    @Override
    protected void installFonts() {
        this.fontBold = MaterialFontFactory.getInstance().getFont("BOLD");
        this.fontItalic = MaterialFontFactory.getInstance().getFont("ITALIC");
        this.fontMedium = MaterialFontFactory.getInstance().getFont("MEDIUM");
        this.fontRegular = MaterialFontFactory.getInstance().getFont("REGULAR");
    }

    @Override
    protected void installIcons() {
        this.selectedCheckBoxIcon = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.CHECK_BOX, this.highlightBackgroundPrimary);
        this.unselectedCheckBoxIcon = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.CHECK_BOX_OUTLINE_BLANK, MaterialColors.WHITE);
        this.selectedRadioButtonIcon = MaterialImageFactory.getInstance().getImage("white/radio-checked-white");
        this.unselectedRadioButtonIcon = MaterialImageFactory.getInstance().getImage("white/radio_unchecked-white");
        this.selectedCheckBoxIconTable = this.selectedCheckBoxIcon;
        this.unselectedCheckBoxIconTable = this.unselectedCheckBoxIcon;
        this.selectedCheckBoxIconSelectionRowTable = this.selectedCheckBoxIcon;
        this.unselectedCheckBoxIconSelectionRowTable = this.unselectedCheckBoxIcon;
        this.closedIconTree = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.KEYBOARD_ARROW_RIGHT, MaterialColors.WHITE);
        this.openIconTree = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.KEYBOARD_ARROW_DOWN, this.highlightBackgroundPrimary);
        this.yesCollapsedTaskPane = MaterialImageFactory.getInstance().getImage("yes-collapsed");
        this.noCollapsedTaskPane = MaterialImageFactory.getInstance().getImage("no-collapsed");
        this.warningIconOptionPane = MaterialImageFactory.getInstance().getImage("warning");
        this.errorIconIconOptionPane = MaterialImageFactory.getInstance().getImage("error");
        this.questionIconOptionPane = MaterialImageFactory.getInstance().getImage("question");
        this.informationIconOptionPane = MaterialImageFactory.getInstance().getImage("information");
        this.iconComputerFileChooser = MaterialImageFactory.getInstance().getImage("white/computer");
        this.iconDirectoryFileChooser = MaterialImageFactory.getInstance().getImage("white/folder");
        this.iconFileFileChooser = MaterialImageFactory.getInstance().getImage("white/file");
        this.iconFloppyDriveFileChooser = MaterialImageFactory.getInstance().getImage("white/floppy_drive");
        this.iconHardDriveFileChooser = MaterialImageFactory.getInstance().getImage("white/hard_drive");
        this.iconHomeFileChooser = MaterialImageFactory.getInstance().getImage("white/home");
        this.iconListFileChooser = MaterialImageFactory.getInstance().getImage("white/list");
        this.iconDetailsFileChooser = MaterialImageFactory.getInstance().getImage("white/details");
        this.iconNewFolderFileChooser = MaterialImageFactory.getInstance().getImage("white/new_folder");
        this.iconUpFolderFileChooser = MaterialImageFactory.getInstance().getImage("white/back_arrow");
        this.unselectedIconToggleButton = MaterialImageFactory.getInstance().getImage("white/toggle_off");
        this.selectedIconToggleButton = MaterialImageFactory.getInstance().getImage("white/toggle_on");
        this.iconCloseTitlePane = MaterialImageFactory.getInstance().getImage("white/close-button");
    }

    @Override
    protected void installBorders() {
        super.installBorders();
        this.borderMenuBar = new BorderUIResource(new DropShadowBorder(Color.DARK_GRAY, 10, 4, 0.3f, 12, false, false, true, false));
        this.borderPopupMenu = MaterialBorders.OCEAN_LINE_BORDER;
        this.borderSpinner = new BorderUIResource(BorderFactory.createLineBorder(this.backgroundTextField));
        this.borderSlider = new BorderUIResource(BorderFactory.createCompoundBorder(MaterialBorders.DARK_LINE_BORDER, BorderFactory.createEmptyBorder(15, 15, 15, 15)));
        this.cellBorderTableHeader = new BorderUIResource(BorderFactory.createCompoundBorder(MaterialBorders.DARK_LINE_BORDER, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.borderToolBar = MaterialBorders.OCEAN_LINE_BORDER;
        this.borderDialogRootPane = MaterialBorders.OCEAN_LINE_BORDER;
        this.borderProgressBar = MaterialBorders.OCEAN_LINE_BORDER;
        this.borderComboBox = MaterialBorders.roundedLineColorBorder(MaterialColors.WHITE, 12);
        this.borderTable = MaterialBorders.OCEAN_LINE_BORDER;
        this.borderTableHeader = MaterialBorders.OCEAN_LINE_BORDER;
        this.borderTitledBorder = new BorderUIResource(BorderFactory.createLineBorder(MaterialColors.WHITE));
    }

    @Override
    protected void installColor() {
        this.backgroundPrimary = MaterialColors.DARKLY_STRONG_BLUE;
        this.highlightBackgroundPrimary = MaterialColors.LIME_A400;
        this.textColor = MaterialColors.WHITE;
        this.disableTextColor = MaterialColors.GRAY_500;
        this.buttonBackgroundColor = MaterialColors.DARKLY_STRONG_BLUE;
        this.buttonBackgroundColorMouseHover = MaterialColors.DARKLY_BLUE;
        this.buttonTextColor = MaterialColors.WHITE;
        this.buttonDefaultBackgroundColorMouseHover = MaterialColors.LIME_200;
        this.buttonDefaultBackgroundColor = MaterialColors.LIME_A200;
        this.buttonDefaultTextColor = MaterialColors.BLACK;
        this.buttonDisabledBackground = MaterialColors.COSMO_DARK_GRAY;
        this.buttonDisabledForeground = MaterialColors.GRAY_500;
        this.buttonFocusColor = MaterialColors.WHITE;
        this.buttonDefaultFocusColor = MaterialColors.BLACK;
        this.buttonBorderColor = MaterialColors.GRAY_200;
        this.buttonColorHighlight = MaterialColors.GRAY_400;
        this.selectedInDropDownBackgroundComboBox = MaterialColors.LIME_A400;
        this.selectedForegroundComboBox = MaterialColors.BLACK;
        this.menuBackground = new ColorUIResource(31, 51, 71);
        this.menuBackgroundMouseHover = MaterialColors.DARKLY_BLUE;
        this.menuTextColor = MaterialColors.WHITE;
        this.menuDisableBackground = MaterialColors.TRANSPANENT;
        this.arrowButtonColorScrollBar = MaterialColors.DARKLY_STRONG_BLUE;
        this.trackColorScrollBar = MaterialColors.DARKLY_BLUE;
        this.thumbColorScrollBar = MaterialColors.GRAY_500;
        this.thumbDarkShadowColorScrollBar = MaterialColors.GRAY_500;
        this.thumbHighlightColorScrollBar = MaterialColors.GRAY_500;
        this.thumbShadowColorScrollBar = MaterialColors.GRAY_500;
        this.arrowButtonOnClickColorScrollBar = MaterialColors.DARKLY_BLUE;
        this.mouseHoverColorScrollBar = MaterialColors.GRAY_300;
        this.trackColorSlider = MaterialColors.DARKLY_BLUE;
        this.haloColorSlider = MaterialColors.bleach(MaterialColors.LIME_A200, 0.5f);
        this.highlightColorTabbedPane = MaterialColors.DARKLY_STRONG_BLUE;
        this.borderHighlightColorTabbedPane = MaterialColors.DARKLY_STRONG_BLUE;
        this.focusColorLineTabbedPane = MaterialColors.LIME_A400;
        this.disableColorTabTabbedPane = MaterialColors.COSMO_STRONG_GRAY;
        this.backgroundTable = MaterialColors.DARKLY_BLUE;
        this.backgroundTableHeader = MaterialColors.DARKLY_STRONG_BLUE;
        this.foregroundTable = MaterialColors.WHITE;
        this.foregroundTableHeader = MaterialColors.LIME_A400;
        this.selectionBackgroundTable = MaterialColors.LIME_A100;
        this.selectionForegroundTable = MaterialColors.BLACK;
        this.gridColorTable = MaterialColors.COSMO_BLACK;
        this.alternateRowBackgroundTable = MaterialColors.DARKLY_STRONG_BLUE;
        this.dockingBackgroundToolBar = MaterialColors.LIGHT_GREEN_A100;
        this.floatingBackgroundToolBar = MaterialColors.GRAY_200;
        this.selectionBackgroundTree = this.backgroundPrimary;
        this.selectionBorderColorTree = this.backgroundPrimary;
        this.backgroundTextField = MaterialColors.DARKLY_BLUE;
        this.inactiveForegroundTextField = MaterialColors.WHITE;
        this.inactiveBackgroundTextField = MaterialColors.DARKLY_BLUE;
        this.selectionBackgroundTextField = MaterialColors.LIME_A100;
        this.selectionForegroundTextField = MaterialColors.BLACK;
        this.disabledBackgroudnTextField = MaterialColors.DARKLY_BLUE;
        this.disabledForegroundTextField = MaterialColors.GRAY_500;
        this.inactiveColorLineTextField = MaterialColors.WHITE;
        this.activeColorLineTextField = MaterialColors.LIME_A400;
        this.arrowButtonBackgroundSpinner = this.backgroundTextField;
        this.mouseHoverButtonColorSpinner = MaterialColors.DARKLY_STRONG_BLUE;
        this.titleBackgroundGradientStartTaskPane = MaterialColors.GRAY_300;
        this.titleBackgroundGradientEndTaskPane = MaterialColors.GRAY_500;
        this.titleOverTaskPane = MaterialColors.WHITE;
        this.specialTitleOverTaskPane = MaterialColors.WHITE;
        this.backgroundTaskPane = MaterialColors.DARKLY_STRONG_BLUE;
        this.borderColorTaskPane = MaterialColors.DARKLY_STRONG_BLUE;
        this.contentBackgroundTaskPane = MaterialColors.DARKLY_STRONG_BLUE;
        this.selectionBackgroundList = MaterialColors.DARKLY_BLUE;
        this.selectionForegroundList = MaterialColors.WHITE;
        this.backgroundProgressBar = MaterialColors.DARKLY_BLUE;
        this.foregroundProgressBar = MaterialColors.LIME_A400;
        this.withoutIconSelectedBackgroundToggleButton = this.highlightBackgroundPrimary;
        this.withoutIconSelectedForegoundToggleButton = MaterialColors.BLACK;
        this.withoutIconBackgroundToggleButton = this.backgroundPrimary;
        this.withoutIconForegroundToggleButton = this.textColor;
        this.colorDividierSplitPane = MaterialColors.COSMO_DARK_GRAY;
        this.colorDividierFocusSplitPane = MaterialColors.LIME_A400;
        this.colorTextTitledBorder = this.textColor;
        this.backgroundSeparator = MaterialColors.GRAY_300;
        this.foregroundSeparator = MaterialColors.GRAY_300;
    }

    @Override
    public void installUIDefault(UIDefaults table) {
        super.installUIDefault(table);
    }

    @Override
    public String getName() {
        return "Material Dark";
    }
}

