/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.spinner;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSpinnerUI;
import mdlaf.animation.MaterialUIMovement;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialSpinnerUI
extends BasicSpinnerUI {
    protected JButton upArrowButton;
    protected JButton downArrowButton;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialSpinnerUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JSpinner spinner = (JSpinner)c;
        spinner.setFont(UIManager.getFont("Spinner.font"));
        spinner.setBackground(UIManager.getColor("Spinner.background"));
        spinner.setForeground(UIManager.getColor("Spinner.foreground"));
        spinner.getEditor().setBorder(UIManager.getBorder("Spinner.border"));
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.spinner.setFont(null);
        this.spinner.setBackground(null);
        this.spinner.setForeground(null);
        this.spinner.getEditor().setBorder(null);
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(MaterialDrawingUtils.getAliasedGraphics(g), c);
        this.configureLocalButton(this.upArrowButton);
        this.configureLocalButton(this.downArrowButton);
    }

    @Override
    protected Component createNextButton() {
        Icon icon = UIManager.getIcon("Spinner.nextButtonIcon");
        JButton button = icon != null ? new JButton(icon) : new BasicArrowButton(1);
        this.configureLocalButton(button);
        this.installNextButtonListeners(button);
        this.upArrowButton = button;
        return button;
    }

    @Override
    protected Component createPreviousButton() {
        Icon icon = UIManager.getIcon("Spinner.previousButtonIcon");
        JButton button = icon != null ? new JButton(icon) : new BasicArrowButton(5);
        this.configureLocalButton(button);
        this.installPreviousButtonListeners(button);
        this.downArrowButton = button;
        return button;
    }

    protected void configureLocalButton(JButton arrowButton) {
        if (arrowButton == null) {
            return;
        }
        arrowButton.setOpaque(true);
        arrowButton.setBackground(UIManager.getColor("Spinner.arrowButtonBackground"));
        if (UIManager.getBoolean("Spinner.mouseHoverEnabled")) {
            arrowButton.addMouseListener(MaterialUIMovement.getMovement(arrowButton, UIManager.getColor("Spinner.mouseHoverColor")));
        }
        arrowButton.setBorder(BorderFactory.createLineBorder(arrowButton.getBackground()));
    }
}

