/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.animation;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;
import mdlaf.components.button.MaterialButtonUI;

public class MaterialUITimer
implements MouseListener,
ActionListener,
MouseMotionListener {
    private Color from;
    private Color to;
    private boolean forward;
    private int alpha;
    private int steps;
    private int[] forwardDeltas;
    private int[] backwardDeltas;
    private JComponent component;
    private Timer timer;
    private WrapperInformationsButton wrapperInformationsButton;

    protected MaterialUITimer(JComponent component, Color to, int steps, int interval) {
        if (component == null) {
            return;
        }
        if (component.getCursor().getType() == 3) {
            return;
        }
        component.setCursor(Cursor.getPredefinedCursor(12));
        if (component instanceof JButton) {
            JButton button = (JButton)component;
            if (button.getUI() instanceof MaterialButtonUI) {
                MaterialButtonUI materialButtonUI = (MaterialButtonUI)button.getUI();
                if (button.isDefaultButton()) {
                    this.from = UIManager.getColor("Button[Default].background");
                    materialButtonUI.setColorMouseHoverDefaultButton(to);
                } else {
                    this.from = component.getBackground();
                    materialButtonUI.setColorMouseHoverNormalButton(to);
                }
            }
        } else {
            this.from = component.getBackground();
        }
        this.to = to;
        this.forwardDeltas = new int[4];
        this.backwardDeltas = new int[4];
        this.forwardDeltas[0] = (this.from.getRed() - to.getRed()) / steps;
        this.forwardDeltas[1] = (this.from.getGreen() - to.getGreen()) / steps;
        this.forwardDeltas[2] = (this.from.getBlue() - to.getBlue()) / steps;
        this.forwardDeltas[3] = (this.from.getAlpha() - to.getAlpha()) / steps;
        this.backwardDeltas[0] = (to.getRed() - this.from.getRed()) / steps;
        this.backwardDeltas[1] = (to.getGreen() - this.from.getGreen()) / steps;
        this.backwardDeltas[2] = (to.getBlue() - this.from.getBlue()) / steps;
        this.backwardDeltas[3] = (to.getAlpha() - this.from.getAlpha()) / steps;
        this.steps = steps;
        this.component = component;
        this.timer = new Timer(interval, this);
        component.setBackground(this.from);
    }

    private Color nextColor() {
        int rValue = this.from.getRed() - this.alpha * this.forwardDeltas[0];
        int gValue = this.from.getGreen() - this.alpha * this.forwardDeltas[1];
        int bValue = this.from.getBlue() - this.alpha * this.forwardDeltas[2];
        int aValue = this.from.getAlpha() - this.alpha * this.forwardDeltas[3];
        return new Color(rValue, gValue, bValue, aValue);
    }

    private Color previousColor() {
        int rValue = this.to.getRed() - (this.steps - this.alpha) * this.backwardDeltas[0];
        int gValue = this.to.getGreen() - (this.steps - this.alpha) * this.backwardDeltas[1];
        int bValue = this.to.getBlue() - (this.steps - this.alpha) * this.backwardDeltas[2];
        int aValue = this.to.getAlpha() - (this.steps - this.alpha) * this.backwardDeltas[3];
        return new Color(rValue, gValue, bValue, aValue);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (!me.getComponent().isEnabled()) {
            return;
        }
        this.alpha = this.steps - 1;
        this.forward = false;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
        this.alpha = 0;
        this.forward = true;
        this.timer.start();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        if (!me.getComponent().isEnabled()) {
            return;
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.alpha = this.steps - 1;
        this.forward = false;
        this.timer.start();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (!me.getComponent().isEnabled()) {
            return;
        }
        this.alpha = 0;
        this.forward = true;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!this.component.isEnabled()) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
            return;
        }
        if (this.forward) {
            this.component.setBackground(this.nextColor());
            ++this.alpha;
        } else {
            this.component.setBackground(this.previousColor());
            --this.alpha;
        }
        if ((this.alpha == this.steps + 1 || this.alpha == -1) && this.timer.isRunning()) {
            this.timer.stop();
        }
        if (this.alpha == -1) {
            this.component.setBackground(this.from);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.component.isEnabled() && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (!this.component.isEnabled() && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (!this.component.isEnabled() && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    @Deprecated
    private class WrapperInformationsButton {
        private Color background;
        private Color foreground;
        private Color defaultBackground;
        private Color defaultForeground;
        private Color disabledForeground;
        private Color disabledBackground;

        public WrapperInformationsButton(JButton button) {
            if (!(button.getUI() instanceof MaterialButtonUI)) {
                throw new RuntimeException("UI button's not instance of MaterialButtonUI");
            }
            MaterialButtonUI materialButtonUI = (MaterialButtonUI)button.getUI();
            this.background = materialButtonUI.getBackground();
            this.foreground = materialButtonUI.getForeground();
            this.disabledBackground = materialButtonUI.getDisabledBackground();
            this.disabledForeground = materialButtonUI.getDisabledForeground();
            if (materialButtonUI.isDefaultButton().booleanValue()) {
                this.defaultBackground = materialButtonUI.getDefaultBackground();
                this.defaultForeground = materialButtonUI.getDefaultForeground();
            }
        }

        public synchronized void setOriginValues(JButton button) {
            if (button == null || !(button.getUI() instanceof MaterialButtonUI)) {
                String messsage = button == null ? "Button component null" : "UI button's not instance of MaterialButtonUI";
                throw new RuntimeException(messsage);
            }
            MaterialButtonUI materialButtonUI = (MaterialButtonUI)button.getUI();
            materialButtonUI.setBackground(this.background);
            materialButtonUI.setForeground(this.foreground);
            materialButtonUI.setDisabledBackground(this.disabledBackground);
            materialButtonUI.setDisabledForeground(this.disabledForeground);
            if (materialButtonUI.isDefaultButton().booleanValue()) {
                if (this.defaultBackground == null || this.defaultForeground == null) {
                    throw new RuntimeException("Value defaultBackground or/and defaultForeground is/are null");
                }
                materialButtonUI.setDefaultBackground(this.defaultBackground);
                materialButtonUI.setDefaultForeground(this.defaultForeground);
            }
            button.repaint();
        }
    }
}

