/*
 * Decompiled with CFR 0.152.
 */
package mdlaf;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import mdlaf.MaterialLookAndFeelInfo;
import mdlaf.components.button.MaterialButtonUI;
import mdlaf.components.checkbox.MaterialCheckBoxUI;
import mdlaf.components.checkboxmenuitem.MaterialCheckBoxMenuItemUI;
import mdlaf.components.colorchooser.MaterialColorChooser;
import mdlaf.components.combobox.MaterialComboBoxUI;
import mdlaf.components.editorpane.MaterialEditorPaneUI;
import mdlaf.components.filechooser.MaterialFileChooserUI;
import mdlaf.components.formattertextfield.MaterialFormattedTextFieldUI;
import mdlaf.components.internalframe.MaterialInternalFrameUI;
import mdlaf.components.label.MaterialLabelUI;
import mdlaf.components.list.MaterialListUI;
import mdlaf.components.menu.MaterialMenuUI;
import mdlaf.components.menubar.MaterialMenuBarUI;
import mdlaf.components.menuitem.MaterialMenuItemUI;
import mdlaf.components.optionpane.MaterialOptionPaneUI;
import mdlaf.components.panel.MaterialPanelUI;
import mdlaf.components.password.MaterialPasswordFieldUI;
import mdlaf.components.popupmenu.MaterialPopupMenuUI;
import mdlaf.components.progressbar.MaterialProgressBarUI;
import mdlaf.components.radiobutton.MaterialRadioButtonUI;
import mdlaf.components.radiobuttonmenuitem.MaterialRadioButtonMenuItemUI;
import mdlaf.components.rootpane.MaterialRootPaneUI;
import mdlaf.components.scrollbar.MaterialScrollBarUI;
import mdlaf.components.separator.MaterialSeparatorUI;
import mdlaf.components.slider.MaterialSliderUI;
import mdlaf.components.spinner.MaterialSpinnerUI;
import mdlaf.components.splitpane.MaterialSplitPaneUI;
import mdlaf.components.tabbedpane.MaterialTabbedPaneUI;
import mdlaf.components.table.MaterialTableHeaderUI;
import mdlaf.components.table.MaterialTableUI;
import mdlaf.components.taskpane.MaterialTaskPaneUI;
import mdlaf.components.textarea.MaterialTextAreaUI;
import mdlaf.components.textfield.MaterialTextFieldUI;
import mdlaf.components.textpane.MaterialTextPaneUI;
import mdlaf.components.togglebutton.MaterialToggleButtonUI;
import mdlaf.components.toolbar.MaterialToolBarUI;
import mdlaf.components.tooltip.MaterialToolTipUI;
import mdlaf.components.tree.MaterialTreeUI;
import mdlaf.themes.MaterialLiteTheme;
import mdlaf.themes.MaterialTheme;
import mdlaf.themes.exceptions.MaterialChangeThemeException;
import mdlaf.utils.MaterialBorders;
import mdlaf.utils.MaterialColors;
import mdlaf.utils.MaterialFontFactory;
import mdlaf.utils.MaterialImageFactory;
import sun.awt.SunToolkit;

public class MaterialLookAndFeel
extends MetalLookAndFeel {
    protected BasicLookAndFeel basicLookAndFeel;
    protected MaterialTheme theme;
    private static final String buttonUI = MaterialButtonUI.class.getCanonicalName();
    private static final String textfieldUI = MaterialTextFieldUI.class.getCanonicalName();
    private static final String passwordFieldUI = MaterialPasswordFieldUI.class.getCanonicalName();
    private static final String tableUI = MaterialTableUI.class.getCanonicalName();
    private static final String tableHeaderUI = MaterialTableHeaderUI.class.getCanonicalName();
    private static final String treeUI = MaterialTreeUI.class.getCanonicalName();
    private static final String spinnerUI = MaterialSpinnerUI.class.getCanonicalName();
    private static final String panelUI = MaterialPanelUI.class.getCanonicalName();
    private static final String labelUI = MaterialLabelUI.class.getCanonicalName();
    private static final String menuItemUI = MaterialMenuItemUI.class.getCanonicalName();
    private static final String menuBarUI = MaterialMenuBarUI.class.getCanonicalName();
    private static final String menuUI = MaterialMenuUI.class.getCanonicalName();
    private static final String checkBoxUI = MaterialCheckBoxUI.class.getCanonicalName();
    private static final String radioButtonUI = MaterialRadioButtonUI.class.getCanonicalName();
    private static final String tabbedPaneUI = MaterialTabbedPaneUI.class.getCanonicalName();
    private static final String toggleButtonUI = MaterialToggleButtonUI.class.getCanonicalName();
    private static final String scrollBarUI = MaterialScrollBarUI.class.getCanonicalName();
    private static final String comboBoxUI = MaterialComboBoxUI.class.getCanonicalName();
    private static final String popupMenuUI = MaterialPopupMenuUI.class.getCanonicalName();
    private static final String toolbarUI = MaterialToolBarUI.class.getCanonicalName();
    private static final String sliderUI = MaterialSliderUI.class.getCanonicalName();
    private static final String progressBarUI = MaterialProgressBarUI.class.getCanonicalName();
    private static final String radioButtonMenuItemUI = MaterialRadioButtonMenuItemUI.class.getCanonicalName();
    private static final String checkBoxMenuItemUI = MaterialCheckBoxMenuItemUI.class.getCanonicalName();
    private static final String textPaneUI = MaterialTextPaneUI.class.getCanonicalName();
    private static final String separatorUI = MaterialSeparatorUI.class.getCanonicalName();
    private static final String fileChooserUI = MaterialFileChooserUI.class.getCanonicalName();
    private static final String toolTipUI = MaterialToolTipUI.class.getCanonicalName();
    private static final String taskPaneUI = MaterialTaskPaneUI.class.getCanonicalName();
    private static final String formattedTextFieldUI = MaterialFormattedTextFieldUI.class.getCanonicalName();
    private static final String listUI = MaterialListUI.class.getCanonicalName();
    private static final String internalFrameUI = MaterialInternalFrameUI.class.getCanonicalName();
    private static final String textAreaUI = MaterialTextAreaUI.class.getCanonicalName();
    private static final String editorPane = MaterialEditorPaneUI.class.getCanonicalName();
    private static final String rootPane = MaterialRootPaneUI.class.getCanonicalName();
    private static final String optionPaneUI = MaterialOptionPaneUI.class.getCanonicalName();
    private static final String colorChooserUI = MaterialColorChooser.class.getCanonicalName();
    private static final String splitPaneUI = MaterialSplitPaneUI.class.getCanonicalName();
    Object fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
    Object multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});

    public static void changeTheme(MaterialTheme theme) {
        if (theme == null) {
            throw new IllegalArgumentException("Theme null");
        }
        BasicLookAndFeel blaf = (BasicLookAndFeel)UIManager.getLookAndFeel();
        if (blaf instanceof MaterialLookAndFeel) {
            MaterialLookAndFeel materialLookAndFeel = (MaterialLookAndFeel)blaf;
            UIManager.removeAuxiliaryLookAndFeel(materialLookAndFeel);
            theme.installTheme();
            materialLookAndFeel.setTheme(theme);
            try {
                UIManager.setLookAndFeel(materialLookAndFeel);
            }
            catch (UnsupportedLookAndFeelException e) {
                throw new MaterialChangeThemeException("Exception generated when I change the theme\nError exception is: " + e.getLocalizedMessage());
            }
            return;
        }
        throw new MaterialChangeThemeException("The look and feel setted not is MaterialLookAnfFeel");
    }

    public MaterialLookAndFeel() {
        this(new MaterialLiteTheme());
    }

    public MaterialLookAndFeel(MaterialTheme theme) {
        this.theme = theme;
        theme.installTheme();
        try {
            this.basicLookAndFeel = new MetalLookAndFeel();
            MaterialLookAndFeelInfo info = new MaterialLookAndFeelInfo(this.getName(), this.getClass().getCanonicalName());
            UIManager.installLookAndFeel(info);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Material Look And Feel with: " + this.theme.getName();
    }

    @Override
    public String getID() {
        return "MaterialLookAndFeel";
    }

    @Override
    public String getDescription() {
        return "A modern Material Design UI for Java Swing";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        table.put("ButtonUI", buttonUI);
        table.put("TextFieldUI", textfieldUI);
        table.put("PasswordFieldUI", passwordFieldUI);
        table.put("TableUI", tableUI);
        table.put("TableHeaderUI", tableHeaderUI);
        table.put("TreeUI", treeUI);
        table.put("SpinnerUI", spinnerUI);
        table.put("PanelUI", panelUI);
        table.put("LabelUI", labelUI);
        table.put("MenuItemUI", menuItemUI);
        table.put("MenuBarUI", menuBarUI);
        table.put("MenuUI", menuUI);
        table.put("CheckBoxUI", checkBoxUI);
        table.put("RadioButtonUI", radioButtonUI);
        table.put("TabbedPaneUI", tabbedPaneUI);
        table.put("ToggleButtonUI", toggleButtonUI);
        table.put("ScrollBarUI", scrollBarUI);
        table.put("ComboBoxUI", comboBoxUI);
        table.put("PopupMenuUI", popupMenuUI);
        table.put("ToolBarUI", toolbarUI);
        table.put("SliderUI", sliderUI);
        table.put("ProgressBarUI", progressBarUI);
        table.put("RadioButtonMenuItemUI", radioButtonMenuItemUI);
        table.put("CheckBoxMenuItemUI", checkBoxMenuItemUI);
        table.put("TextPaneUI", textPaneUI);
        table.put("SeparatorUI", separatorUI);
        table.put("FileChooserUI", fileChooserUI);
        table.put("ToolTipUI", toolTipUI);
        table.put("FormattedTextFieldUI", formattedTextFieldUI);
        table.put("ListUI", listUI);
        table.put("TextAreaUI", textAreaUI);
        table.put("EditorPaneUI", editorPane);
        table.put("InternalFrameUI", internalFrameUI);
        table.put("RootPaneUI", rootPane);
        table.put("OptionPaneUI", optionPaneUI);
        table.put("SplitPaneUI", splitPaneUI);
        table.put("ColorChooserUI", colorChooserUI);
        table.put("swingx/TaskPaneUI", taskPaneUI);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        table.put("Button.highlight", this.theme.getButtonColorHighlight());
        table.put("Button.opaque", (Object)this.theme.getOpaqueButton());
        table.put("Button.background", this.theme.getButtonBackgroundColor());
        table.put("Button.border", this.theme.getButtonBorder());
        table.put("Button.arc", (Object)this.theme.getArcButton());
        table.put("Button.foreground", this.theme.getButtonTextColor());
        table.put("Button[Default].background", this.theme.getButtonDefaultBackgroundColor());
        table.put("Button[Default].foreground", this.theme.getButtonDefaultTextColor());
        table.put("Button.disabledBackground", this.theme.getButtonDisabledBackground());
        table.put("Button.disabledForeground", this.theme.getButtonDisabledForeground());
        table.put("Button.font", this.theme.getButtonFont());
        table.put("Button[Default].mouseHoverColor", this.theme.getButtonDefaultBackgroundColorMouseHover());
        table.put("Button.mouseHoverColor", this.theme.getButtonBackgroundColorMouseHover());
        table.put("Button.mouseHoverEnable", (Object)this.theme.getMouseHoverButtonEnable());
        table.put("Button.mouseHoverBorder", (Object)false);
        table.put("Button.focusable", (Object)this.theme.getButtonFocusable());
        table.put("Button[focus].color", this.theme.getButtonFocusColor());
        table.put("Button.disabledText", this.theme.getButtonDisableTextColor());
        table.put("Button[Default].shadowPixel", (Object)3);
        table.put("Button[Default][focus].color", this.theme.getButtonDefaultFocusColor());
        table.put("Button[border].enable", (Object)this.theme.getButtonBorderEnable());
        table.put("Button[border].color", this.theme.getButtonBorderColor());
        table.put("Button[border].toAll", (Object)this.theme.getButtonBorderEnableToAll());
        table.put("CheckBox.font", this.theme.getFontRegular());
        table.put("CheckBox.background", this.theme.getBackgroundPrimary());
        table.put("CheckBox.foreground", this.theme.getTextColor());
        table.put("CheckBox.disabledText", this.theme.getDisableTextColor());
        table.put("CheckBox.icon", this.theme.getUnselectedCheckBoxIcon());
        table.put("CheckBox.selectedIcon", this.theme.getSelectedCheckBoxIcon());
        table.put("ComboBox.font", this.theme.getFontRegular());
        table.put("ComboBox.background", this.theme.getBackgroundPrimary());
        table.put("ComboBox.foreground", this.theme.getTextColor());
        table.put("ComboBox.border", this.theme.getBorderComboBox());
        table.put("ComboBox.borderItems", new BorderUIResource(BorderFactory.createEmptyBorder(1, 2, 0, 1)));
        table.put("ComboBox.buttonBackground", this.theme.getBackgroundPrimary());
        table.put("ComboBox[button].border", BorderFactory.createLineBorder(this.theme.getBackgroundPrimary()));
        table.put("ComboBox.disabledBackground", this.theme.getBackgroundPrimary());
        table.put("ComboBox.disabledForeground", this.theme.getDisableTextColor());
        table.put("ComboBox.selectionBackground", this.theme.getBackgroundPrimary());
        table.put("ComboBox.selectionForeground", this.theme.getTextColor());
        table.put("ComboBox[item].selectionForeground", this.theme.getSelectedForegroundComboBox());
        table.put("ComboBox.selectedInDropDownBackground", this.theme.getSelectedInDropDownBackgroundComboBox());
        table.put("ComboBox.mouseHoverColor", this.theme.getButtonBackgroundColorMouseHover());
        table.put("ComboBox.unfocusColor", this.theme.getTextColor());
        table.put("ComboBox.focusColor", this.theme.getHighlightBackgroundPrimary());
        table.put("ComboBox.mouseHoverEnabled", (Object)this.theme.getMouseHoverEnableComboBox());
        table.put("ComboBox.arc", (Object)this.theme.getArchBorderComboBox());
        table.put("ComboBox.focusable", (Object)this.theme.getFocusableComboBox());
        table.put("ComboBox.lightWeightPopupEnabled", (Object)this.theme.getLightWeightPopupEnabledComboBox());
        table.put("Label.font", this.theme.getFontRegular());
        table.put("Label.background", this.theme.getBackgroundPrimary());
        table.put("Label.foreground", this.theme.getTextColor());
        table.put("Label.disabledForeground", this.theme.getDisableTextColor());
        table.put("Label.border", new BorderUIResource(BorderFactory.createEmptyBorder()));
        table.put("Menu.font", this.theme.getFontRegular());
        table.put("Menu.border", this.theme.getBorderMenu());
        table.put("Menu.background", this.theme.getMenuBackground());
        table.put("Menu.foreground", this.theme.getMenuTextColor());
        table.put("Menu.opaque", (Object)true);
        table.put("Menu.selectionBackground", this.theme.getMenuBackgroundMouseHover());
        table.put("Menu.selectionForeground", this.theme.getMenuTextColor());
        table.put("Menu.disabledForeground", this.theme.getMenuDisableBackground());
        table.put("Menu.acceleratorSelectionForeground", this.theme.getMenuTextColor());
        table.put("Menu.menuPopupOffsetY", (Object)3);
        table.put("Menu[MouseOver].enable", (Object)this.theme.getMouseHoverEnableMenu());
        table.put("Menu.arrowIcon", this.theme.getMenuArrowIcon());
        table.put("Menu[arrowIcon].hoverColor", this.theme.getMenuArrowHoverColor());
        table.put("Menu[arrowIcon].color", this.theme.getMenuTextColor());
        table.put("Menu[arrowIcon].height", (Object)this.theme.getMenuArrowHeight());
        table.put("Menu[arrowIcon].width", (Object)this.theme.getMenuArrowWidth());
        table.put("MenuBar.font", MaterialFontFactory.getInstance().getFont("BOLD"));
        table.put("MenuBar.background", this.theme.getMenuBackground());
        table.put("MenuBar.border", this.theme.getBorderMenuBar());
        table.put("MenuBar.foreground", this.theme.getMenuTextColor());
        table.put("MenuItem.disabledForeground", this.theme.getDisableTextColor());
        table.put("MenuItem.selectionBackground", this.theme.getMenuBackgroundMouseHover());
        table.put("MenuItem.selectionForeground", this.theme.getTextColor());
        table.put("MenuItem.font", this.theme.getFontRegular());
        table.put("MenuItem.background", this.theme.getMenuBackground());
        table.put("MenuItem.foreground", this.theme.getMenuTextColor());
        table.put("MenuItem.border", this.theme.getBorderMenu());
        table.put("Panel.font", this.theme.getFontRegular());
        table.put("Panel.background", this.theme.getBackgroundPrimary());
        table.put("Panel.border", this.theme.getBorderPanel());
        table.put("PopupMenu.border", this.theme.getBorderPopupMenu());
        table.put("PopupMenu.background", this.theme.getBackgroundPrimary());
        table.put("PopupMenu.foreground", this.theme.getTextColor());
        table.put("RadioButton.font", this.theme.getFontRegular());
        table.put("RadioButton.background", this.theme.getBackgroundPrimary());
        table.put("RadioButton.foreground", this.theme.getTextColor());
        table.put("RadioButton.icon", this.theme.getUnselectedRadioButtonIcon());
        table.put("RadioButton.selectedIcon", this.theme.getSelectedRadioButtonIcon());
        table.put("RadioButton.disabledText", this.theme.getDisableTextColor());
        table.put("Spinner.font", this.theme.getFontRegular());
        table.put("Spinner.background", this.theme.getBackgroundPrimary());
        table.put("Spinner.foreground", this.theme.getTextColor());
        table.put("Spinner.border", this.theme.getBorderSpinner());
        table.put("Spinner.arrowButtonBackground", this.theme.getArrowButtonBackgroundSpinner());
        table.put("Spinner.arrowButtonBorder", this.theme.getArrowButtonBorderSpinner());
        table.put("Spinner.mouseHoverEnabled", (Object)this.theme.getMouseHoverEnableSpinner());
        table.put("Spinner.mouseHoverColor", this.theme.getMouseHoverButtonColorSpinner());
        table.put("ScrollBar.font", this.theme.getFontRegular());
        table.put("ScrollBar.track", this.theme.getTrackColorScrollBar());
        table.put("ScrollBar.thumb", this.theme.getThumbColorScrollBar());
        table.put("ScrollBar.thumbDarkShadow", this.theme.getThumbDarkShadowColorScrollBar());
        table.put("ScrollBar.thumbHighlight", this.theme.getThumbHighlightColorScrollBar());
        table.put("ScrollBar.thumbShadow", this.theme.getThumbShadowColorScrollBar());
        table.put("ScrollBar.arrowButtonBackground", this.theme.getArrowButtonOnClickColorScrollBar());
        table.put("ScrollBar.enableArrow", (Object)this.theme.getEnableArrowScrollBar());
        table.put("ScrollBar.arrowButtonBorder", this.theme.getArrowButtonBorderScrollBar());
        table.put("ScrollBar.width", (Object)14);
        table.put("ScrollBar[MouseHover].enable", (Object)this.theme.getMouseHoverEnableScrollBar());
        table.put("ScrollBar[MouseHover].color", this.theme.getMouseHoverColorScrollBar());
        table.put("ScrollBar[OnClick].color", this.theme.getArrowButtonOnClickColorScrollBar());
        table.put("ScrollPane.background", this.theme.getBackgroundPrimary());
        table.put("ScrollPane.border", this.theme.getBorderPanel());
        table.put("ScrollPane.font", this.theme.getFontRegular());
        table.put("Slider.font", this.theme.getFontRegular());
        table.put("Slider.background", this.theme.getBackgroundPrimary());
        table.put("Slider.foreground", this.theme.getHighlightBackgroundPrimary());
        table.put("Slider.trackColor", this.theme.getTrackColorSlider());
        table.put("Slider[halo].color", this.theme.getHaloColorSlider());
        table.put("Slider.border", this.theme.getBorderSlider());
        table.put("SplitPane.border", this.theme.getBorderPanel());
        table.put("SplitPane.background", this.theme.getDisableTextColor());
        table.put("SplitPane.dividerSize", (Object)this.theme.getSizeDividierSplitPane());
        table.put("SplitPaneDivider.border", this.theme.getDividierBorderSplitPane());
        table.put("SplitPaneDivider.background", this.theme.getColorDividierSplitPane());
        table.put("SplitPaneDivider.draggingColor", this.theme.getColorDividierFocusSplitPane());
        table.put("TabbedPane.font", this.theme.getFontRegular());
        table.put("TabbedPane.background", this.theme.getBackgroundPrimary());
        table.put("TabbedPane.tabAreaBackground", this.theme.getBackgroundPrimary());
        table.put("TabbedPane.foreground", this.theme.getTextColor());
        table.put("TabbedPane.disabledForeground", this.theme.getDisableTextColor());
        table.put("TabbedPane.selectionForeground", this.theme.getFocusColorLineTabbedPane());
        table.put("TabbedPane.contentAreaColor", this.theme.getButtonTextColor());
        table.put("TabbedPane.disableContentAreaColor", this.theme.getDisableColorTabTabbedPane());
        table.put("TabbedPane.border", this.theme.getBorderPanel());
        table.put("TabbedPane.shadow", this.theme.getBackgroundPrimary());
        table.put("TabbedPane.darkShadow", this.theme.getBackgroundPrimary());
        table.put("TabbedPane.highlight", this.theme.getDisableTextColor());
        table.put("TabbedPane.selected", this.theme.getTextColor());
        table.put("TabbedPane.light", this.theme.getBackgroundPrimary());
        table.put("TabbedPane.borderHighlightColor", this.theme.getBorderHighlightColorTabbedPane());
        table.put("TabbedPane[focus].colorLine", this.theme.getFocusColorLineTabbedPane());
        table.put("TabbedPane[MouseHover].enable", (Object)this.theme.getMouseHoverEnableTabbedPane());
        table.put("TabbedPane.tabInsets", new InsetsUIResource(6, 12, 10, 12));
        table.put("TabbedPane.contentBorderInsets", new InsetsUIResource(6, 20, 10, 20));
        table.put("TabbedPane.selectedTabPadInsets", this.theme.getSelectedTabInsetsTabbedPane());
        table.put("TabbedPane.lineHeight", (Object)this.theme.getLineHeightTabbedPane());
        table.put("TabbedPane[focus].margin", (Object)5);
        table.put("Table.selectionBackground", this.theme.getSelectionBackgroundTable());
        table.put("Table.selectionForeground", this.theme.getSelectionForegroundTable());
        table.put("Table.background", this.theme.getBackgroundTable());
        table.put("Table.foreground", this.theme.getForegroundTable());
        table.put("Table.font", this.theme.getFontRegular());
        table.put("Table.border", this.theme.getBorderTable());
        table.put("Table.gridColor", this.theme.getGridColorTable());
        table.put("Table.focusable", (Object)this.theme.getTableFocusable());
        table.put("Table.opaque", (Object)this.theme.getTableOpaque());
        table.put("Table.alternateRowColor", this.theme.getAlternateRowBackgroundTable());
        table.put("Table[row].height", (Object)this.theme.getHeightRowTable());
        table.put("Table[CheckBox].checked", this.theme.getSelectedCheckBoxIconTable());
        table.put("Table[CheckBox].unchecked", this.theme.getUnselectedCheckBoxIconTable());
        table.put("Table[CheckBox].selectionChecked", this.theme.getSelectedCheckBoxIconSelectionRowTable());
        table.put("Table[CheckBox].selectionUnchecked", this.theme.getUnselectedCheckBoxIconSelectionRowTable());
        table.put("Table.focusCellHighlightBorder", new BorderUIResource(BorderFactory.createEmptyBorder()));
        table.put("Table.showVerticalLines", (Object)false);
        table.put("Table.showHorizontalLines", (Object)false);
        table.put("Table.intercellSpacing", new Dimension(0, 0));
        table.put("TableHeader.background", this.theme.getBackgroundTableHeader());
        table.put("TableHeader.foreground", this.theme.getForegroundTableHeader());
        table.put("TableHeader.border", this.theme.getBorderTableHeader());
        table.put("TableHeader.font", this.theme.getFontBold());
        table.put("TableHeader.cellBorder", this.theme.getCellBorderTableHeader());
        table.put("TableHeader.gridColor", this.theme.getBackgroundTableHeader());
        table.put("TextArea.background", this.theme.getBackgroundTextField());
        table.put("TextArea.border", this.theme.getBorderTextField());
        table.put("TextArea.selectionBackground", this.theme.getSelectionBackgroundTextField());
        table.put("TextArea.selectionForeground", this.theme.getSelectionForegroundTextField());
        table.put("TextArea.foreground", this.theme.getTextColor());
        table.put("TextArea.font", this.theme.getFontBold());
        table.put("ToggleButton.border", BorderFactory.createEmptyBorder());
        table.put("ToggleButton.font", this.theme.getFontRegular());
        table.put("ToggleButton.background", this.theme.getBackgroundPrimary());
        table.put("ToggleButton.select", this.theme.getHighlightBackgroundPrimary());
        table.put("ToggleButton.foreground", this.theme.getTextColor());
        table.put("ToggleButton.disabledText", this.theme.getDisableTextColor());
        table.put("ToggleButton.icon", this.theme.getUnselectedIconToggleButton());
        table.put("ToggleButton.selectedIcon", this.theme.getSelectedIconToggleButton());
        table.put("ToggleButton.withoutIcon", (Object)this.theme.isWithoutIconToggleButton());
        table.put("ToggleButton[withoutIcon].selectedBackground", this.theme.getWithoutIconSelectedBackgroundToggleButton());
        table.put("ToggleButton[withoutIcon].selectedForeground", this.theme.getWithoutIconSelectedForegoundToggleButton());
        table.put("ToggleButton[withoutIcon].background", this.theme.getWithoutIconBackgroundToggleButton());
        table.put("ToggleButton[withoutIcon].foreground", this.theme.getWithoutIconForegroundToggleButton());
        table.put("ToggleButton[withoutIcon].selectedBorder", this.theme.getWithoutIconSelectedBorderToggleButton());
        table.put("ToggleButton[withoutIcon].border", this.theme.getWithoutIconBorderToggleButton());
        table.put("ToolBar.font", this.theme.getFontRegular());
        table.put("ToolBar.background", this.theme.getBackgroundPrimary());
        table.put("ToolBar.foreground", this.theme.getTextColor());
        table.put("ToolBar.border", this.theme.getBorderToolBar());
        table.put("ToolBar.dockingBackground", this.theme.getDockingBackgroundToolBar());
        table.put("ToolBar.floatingBackground", this.theme.getFloatingBackgroundToolBar());
        table.put("Tree.font", this.theme.getFontRegular());
        table.put("Tree.selectionForeground", this.theme.getHighlightBackgroundPrimary());
        table.put("Tree.foreground", this.theme.getTextColor());
        table.put("Tree.selectionBackground", this.theme.getSelectionBackgroundTree());
        table.put("Tree.background", this.theme.getBackgroundPrimary());
        table.put("Tree.selectionBorderColor", this.theme.getSelectionBorderColorTree());
        table.put("Tree.border", this.theme.getBorderTree());
        table.put("Tree.collapsedIcon", (Object)null);
        table.put("Tree.expandedIcon", (Object)null);
        table.put("Tree.closedIcon", this.theme.getClosedIconTree());
        table.put("Tree.openIcon", this.theme.getOpenIconTree());
        table.put("Tree.leafIcon", (Object)null);
        table.put("RadioButtonMenuItem.foreground", this.theme.getTextColor());
        table.put("RadioButtonMenuItem.selectionForeground", this.theme.getTextColor());
        table.put("RadioButtonMenuItem.background", this.theme.getMenuBackground());
        table.put("RadioButtonMenuItem.selectionBackground", this.theme.getMenuBackgroundMouseHover());
        table.put("RadioButtonMenuItem.border", this.theme.getBorderMenu());
        table.put("RadioButtonMenuItem.checkIcon", this.theme.getUnselectedRadioButtonIcon());
        table.put("RadioButtonMenuItem.selectedCheckIcon", this.theme.getSelectedRadioButtonIcon());
        table.put("CheckBoxMenuItem.background", this.theme.getMenuBackground());
        table.put("CheckBoxMenuItem.selectionBackground", this.theme.getMenuBackgroundMouseHover());
        table.put("CheckBoxMenuItem.foreground", this.theme.getTextColor());
        table.put("CheckBoxMenuItem.selectionForeground", this.theme.getTextColor());
        table.put("CheckBoxMenuItem.border", this.theme.getBorderMenu());
        table.put("CheckBoxMenuItem.checkIcon", this.theme.getUnselectedCheckBoxIconTable());
        table.put("CheckBoxMenuItem.selectedCheckIcon", this.theme.getSelectedCheckBoxIconTable());
        table.put("TextPane.border", this.theme.getBorderPanel());
        table.put("TextPane.background", this.theme.getBackgroundTextField());
        table.put("TextPane.foreground", this.theme.getTextColor());
        table.put("TextPane.selectionBackground", this.theme.getHighlightBackgroundPrimary());
        table.put("TextPane.inactiveForeground", this.theme.getDisableTextColor());
        table.put("TextPane.font", this.theme.getFontItalic());
        table.put("TextPane.focusInputMap", this.multilineInputMap);
        table.put("EditorPane.border", this.theme.getBorderPanel());
        table.put("EditorPane.background", this.theme.getBackgroundTextField());
        table.put("EditorPane.foreground", this.theme.getTextColor());
        table.put("EditorPane.selectionBackground", this.theme.getSelectionBackgroundTextField());
        table.put("EditorPane.inactiveForeground", this.theme.getSelectionForegroundTextField());
        table.put("EditorPane.font", this.theme.getFontRegular());
        table.put("EditorPane.focusInputMap", this.multilineInputMap);
        table.put("Separator.background", this.theme.getBackgroundSeparator());
        table.put("Separator.foreground", this.theme.getForegroundSeparator());
        table.put("ToolTip.background", MaterialColors.GRAY_500);
        table.put("ToolTip.foreground", MaterialColors.GRAY_50);
        table.put("ToolTip.border", BorderFactory.createEmptyBorder(5, 5, 5, 5));
        table.put("TextField.background", this.theme.getBackgroundTextField());
        table.put("TextField.foreground", this.theme.getTextColor());
        table.put("TextField.font", this.theme.getFontRegular());
        table.put("TextField.disabledBackground", this.theme.getDisabledBackgroudnTextField());
        table.put("TextField.disabledForeground", this.theme.getDisabledForegroundTextField());
        table.put("TextField.inactiveForeground", this.theme.getInactiveForegroundTextField());
        table.put("TextField.inactiveBackground", this.theme.getInactiveBackgroundTextField());
        table.put("TextField.selectionBackground", this.theme.getSelectionBackgroundTextField());
        table.put("TextField.selectionForeground", this.theme.getSelectionForegroundTextField());
        table.put("TextField[Line].inactiveColor", this.theme.getInactiveColorLineTextField());
        table.put("TextField[Line].activeColor", this.theme.getActiveColorLineTextField());
        table.put("TextField.border", this.theme.getBorderTextField());
        table.put("TextField.focusInputMap", this.fieldInputMap);
        table.put("PasswordField.background", this.theme.getBackgroundTextField());
        table.put("PasswordField.foreground", this.theme.getTextColor());
        table.put("PasswordField.disabledBackground", this.theme.getDisabledBackgroudnTextField());
        table.put("PasswordField.disabledForeground", this.theme.getDisabledForegroundTextField());
        table.put("PasswordField.inactiveForeground", this.theme.getInactiveForegroundTextField());
        table.put("PasswordField.inactiveBackground", this.theme.getInactiveBackgroundTextField());
        table.put("PasswordField.selectionBackground", this.theme.getSelectionBackgroundTextField());
        table.put("PasswordField.selectionForeground", this.theme.getSelectionForegroundTextField());
        table.put("PasswordField[Line].inactiveColor", this.theme.getInactiveColorLineTextField());
        table.put("PasswordField[Line].activeColor", this.theme.getActiveColorLineTextField());
        table.put("PasswordField.border", this.theme.getBorderTextField());
        table.put("PasswordField.echoChar", Character.valueOf(this.theme.getEchoCharPasswordField()));
        table.put("PasswordField.focusInputMap", this.fieldInputMap);
        table.put("TitledBorder.border", this.theme.getBorderTitledBorder());
        table.put("TitledBorder.font", this.theme.getFontMedium());
        table.put("TitledBorder.titleColor", this.theme.getColorTextTitledBorder());
        table.put("TaskTaskPane.font", this.theme.getFontMedium());
        table.put("TaskPane.titleBackgroundGradientStart", this.theme.getTitleBackgroundGradientStartTaskPane());
        table.put("TaskPane.titleBackgroundGradientEnd", this.theme.getTitleBackgroundGradientEndTaskPane());
        table.put("TaskPane.titleOver", this.theme.getTitleOverTaskPane());
        table.put("TaskPane.specialTitleOver", this.theme.getSpecialTitleOverTaskPane());
        table.put("TaskPane.background", this.theme.getBackgroundTaskPane());
        table.put("TaskPane.foreground", this.theme.getTextColor());
        table.put("TaskPane.borderColor", this.theme.getBorderColorTaskPane());
        table.put("TaskPane.border", this.theme.getBorderTaskPane());
        table.put("TaskPane.contentBackground", this.theme.getContentBackgroundTaskPane());
        table.put("TaskPane.yesCollapsed", this.theme.getYesCollapsedTaskPane());
        table.put("TaskPane.noCollapsed", this.theme.getNoCollapsedTaskPane());
        table.put("FormattedTextField.background", this.theme.getBackgroundTextField());
        table.put("FormattedTextField.foreground", this.theme.getTextColor());
        table.put("FormattedTextField.inactiveForeground", this.theme.getInactiveForegroundTextField());
        table.put("FormattedTextField.inactiveBackground", this.theme.getInactiveBackgroundTextField());
        table.put("FormattedTextField.selectionBackground", this.theme.getSelectionBackgroundTextField());
        table.put("FormattedTextField.selectionForeground", this.theme.getSelectionForegroundTextField());
        table.put("FormattedTextField.border", this.theme.getBorderTextField());
        table.put("List.background", this.theme.getBackgroundPrimary());
        table.put("List.foreground", this.theme.getTextColor());
        table.put("List.border", MaterialBorders.LIGHT_SHADOW_BORDER);
        table.put("List.font", this.theme.getFontMedium());
        table.put("List.selectionBackground", this.theme.getSelectionBackgroundList());
        table.put("List.selectionForeground", this.theme.getSelectionForegroundList());
        table.put("List.focusCellHighlightBorder", this.theme.getFocusCellHighlightBorder());
        table.put("List[item].border", this.theme.getBorderItemList());
        table.put("List.focusable", (Object)true);
        table.put("RootPane.frameBorder", this.theme.getBorderFrameRootPane());
        table.put("RootPane.background", this.theme.getBackgroundPrimary());
        table.put("RootPane.plainDialogBorder", this.theme.getBorderDialogRootPane());
        table.put("RootPane.informationDialogBorder", this.theme.getBorderDialogRootPane());
        table.put("RootPane.errorDialogBorder", this.theme.getBorderDialogRootPane());
        table.put("RootPane.fileChooserDialogBorder", this.theme.getBorderDialogRootPane());
        table.put("RootPane.questionDialogBorder", this.theme.getBorderDialogRootPane());
        table.put("RootPane.warningDialogBorder", this.theme.getBorderDialogRootPane());
        table.put("RootPane.colorChooserDialogBorder", this.theme.getBackgroundPrimary());
        table.put("InternalFrame.maximizeIcon", MaterialImageFactory.getInstance().getImage("white/maximize"));
        table.put("InternalFrame.minimizeIcon", MaterialImageFactory.getInstance().getImage("white/minimize"));
        table.put("InternalFrame.closeIcon", this.theme.getIconCloseTitlePane());
        table.put("InternalFrame.iconifyIcon", MaterialImageFactory.getInstance().getImage("white/restore"));
        table.put("InternalFrame.activeTitleBackground", MaterialColors.COSMO_BLACK);
        table.put("InternalFrame.activeTitleForeground", MaterialColors.BLACK);
        table.put("InternalFrame.inactiveTitleBackground", MaterialColors.COSMO_BLACK);
        table.put("InternalFrame.inactiveTitleForeground", MaterialColors.BLACK);
        table.put("InternalFrame.titleFont", this.theme.getFontBold());
        table.put("InternalFrame.background", MaterialColors.LIGHT_BLUE_500);
        table.put("InternalFrame.border", MaterialBorders.DEFAULT_SHADOW_BORDER);
        table.put("Material.activeCaption", this.theme.getMenuBackground());
        table.put("Material.inactiveCaption", this.theme.getMenuBackground());
        table.put("Material.activeCaptionText", this.theme.getTextColor());
        table.put("Material.inactiveCaptionText", this.theme.getDisableTextColor());
        table.put("Material.activeCaptionBorder", MaterialBorders.LIGHT_LINE_BORDER);
        table.put("Material.inactiveCaptionBorder", MaterialBorders.LIGHT_LINE_BORDER);
        table.put("OptionPane.background", this.theme.getBackgroundPrimary());
        table.put("OptionPane.foreground", this.theme.getTextColor());
        table.put("OptionPane.border", BorderFactory.createEmptyBorder());
        table.put("OptionPane.font", this.theme.getFontRegular());
        table.put("OptionPane.enableIcon", (Object)this.theme.getEnableIconOptionPane());
        table.put("OptionPaneUI.warningIcon", this.theme.getWarningIconOptionPane());
        table.put("OptionPaneUI.errorIcon", this.theme.getErrorIconIconOptionPane());
        table.put("OptionPaneUI.questionIcon", this.theme.getQuestionIconOptionPane());
        table.put("OptionPaneUI.informationIcon", this.theme.getInformationIconOptionPane());
        table.put("OptionPane.errorDialog.titlePane.background", this.theme.getBackgroundPrimary());
        table.put("OptionPane.errorDialog.titlePane.foreground", this.theme.getTextColor());
        table.put("OptionPane.errorDialog.titlePane.shadow", MaterialColors.COSMO_STRONG_GRAY);
        table.put("OptionPane.questionDialog.titlePane.background", this.theme.getBackgroundPrimary());
        table.put("OptionPane.questionDialog.titlePane.foreground", this.theme.getTextColor());
        table.put("OptionPane.questionDialog.titlePane.shadow", MaterialColors.COSMO_STRONG_GRAY);
        table.put("OptionPane.warningDialog.titlePane.background", this.theme.getBackgroundPrimary());
        table.put("OptionPane.warningDialog.titlePane.foreground", this.theme.getTextColor());
        table.put("OptionPane.warningDialog.titlePane.shadow", MaterialColors.COSMO_STRONG_GRAY);
        table.put("OptionPane.messageForeground", this.theme.getTextColor());
        table.put("FileChooser[icons].computer", this.theme.getIconComputerFileChooser());
        table.put("FileChooser[icons].directory", this.theme.getIconDirectoryFileChooser());
        table.put("FileChooser[icons].file", this.theme.getIconFileFileChooser());
        table.put("FileChooser[icons].floppyDrive", this.theme.getIconFloppyDriveFileChooser());
        table.put("FileChooser[icons].hardDrive", this.theme.getIconHardDriveFileChooser());
        table.put("FileChooser[icons].home", this.theme.getIconHomeFileChooser());
        table.put("FileChooser[icons].list", this.theme.getIconListFileChooser());
        table.put("FileChooser[icons].details", this.theme.getIconDetailsFileChooser());
        table.put("FileChooser[icons].newFolder", this.theme.getIconNewFolderFileChooser());
        table.put("FileChooser[icons].upFolder", this.theme.getIconUpFolderFileChooser());
        table.put("ProgressBar.border", this.theme.getBorderProgressBar());
        table.put("ProgressBar.background", this.theme.getBackgroundProgressBar());
        table.put("ProgressBar.foreground", this.theme.getForegroundProgressBar());
        table.put("ProgressBar.verticalSize", (Object)1);
        table.put("ColorChooser.background", this.theme.getBackgroundPrimary());
        table.put("ColorChooser.foreground", this.theme.getTextColor());
        table.put("ColorChooser.border", this.theme.getBorderPanel());
        this.theme.installUIDefault(table);
    }

    @Override
    public UIDefaults getDefaults() {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("getDefaults", new Class[0]);
            superMethod.setAccessible(true);
            UIDefaults defaults = (UIDefaults)superMethod.invoke((Object)this.basicLookAndFeel, new Object[0]);
            this.initClassDefaults(defaults);
            this.initComponentDefaults(defaults);
            this.theme.installTheme();
            defaults.put("OptionPane.warningIcon", MaterialImageFactory.getInstance().getImage("warning"));
            defaults.put("OptionPane.errorIcon", MaterialImageFactory.getInstance().getImage("error"));
            defaults.put("OptionPane.questionIcon", MaterialImageFactory.getInstance().getImage("question"));
            defaults.put("OptionPane.informationIcon", MaterialImageFactory.getInstance().getImage("information"));
            return defaults;
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
            return super.getDefaults();
        }
    }

    @Override
    public void uninitialize() {
        this.call("uninitialize");
    }

    public MaterialTheme getTheme() {
        return this.theme;
    }

    public void setTheme(MaterialTheme theme) {
        this.theme = theme;
    }

    public static int getFocusAcceleratorKeyMask() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk instanceof SunToolkit) {
            return ((SunToolkit)tk).getFocusAcceleratorKeyMask();
        }
        return 8;
    }

    protected void call(String method) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method, new Class[0]);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.basicLookAndFeel, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

