/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.DefaultHighlighterDark;

import com.github.weisj.darklaf.color.ColorWrapper;
import com.github.weisj.darklaf.ui.text.StyleConstantsEx;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class DarkHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    private static final boolean DEBUG_COLOR = false;
    private Paint paint;
    private Color color;
    private ColorWrapper wrapper;
    private boolean roundedEdges;
    private AlphaComposite alphaComposite;
    private float alpha;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private int repaintCount = 0;
    private int arcSize;
    private boolean suppressRounded = false;
    private boolean enabled;

    public DarkHighlightPainter() {
        this((Paint)null);
    }

    public DarkHighlightPainter(Paint paint) {
        this(paint, false);
    }

    public DarkHighlightPainter(Paint paint, boolean rounded) {
        this(paint, rounded, 1.0f);
    }

    public DarkHighlightPainter(Paint paint, boolean rounded, float alpha) {
        super(null);
        this.setPaint(paint);
        this.setRoundedEdges(rounded);
        this.setAlpha(alpha);
        this.setEnabled(true);
        this.arcSize = UIManager.getInt("Highlight.arc");
        this.wrapper = new ColorWrapper(this.color){

            @Override
            public boolean equals(Object obj) {
                return obj != null && DarkHighlightPainter.this.enabled;
            }
        };
    }

    public boolean getRoundedEdges() {
        return this.roundedEdges;
    }

    public void setRoundedEdges(boolean rounded) {
        this.roundedEdges = rounded;
    }

    @Override
    public Color getColor() {
        return this.wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        if (!this.enabled) {
            return;
        }
        Rectangle alloc = bounds.getBounds();
        Graphics2D g2d = (Graphics2D)g;
        GraphicsContext context = new GraphicsContext(g2d);
        this.color = c.getSelectedTextColor();
        this.wrapper.setColor(this.color);
        if (this.getAlpha() < 1.0f) {
            g2d.setComposite(this.getAlphaComposite());
        }
        try {
            TextUI mapper = c.getUI();
            Rectangle p0 = mapper.modelToView(c, offs0, Position.Bias.Forward);
            Rectangle p1 = mapper.modelToView(c, offs1, Position.Bias.Forward);
            this.setupColor(g2d, c);
            if (p0.y == p1.y) {
                p1.width = 0;
                Rectangle r = p0.union(p1);
                g2d.fillRect(r.x, r.y, r.width, r.height);
            } else {
                int p0ToMarginWidth = alloc.x + alloc.width - p0.x;
                g2d.fillRect(p0.x, p0.y, p0ToMarginWidth, p0.height);
                if (p0.y + p0.height != p1.y) {
                    g2d.fillRect(alloc.x, p0.y + p0.height, alloc.width, p1.y - (p0.y + p0.height));
                }
                g2d.fillRect(alloc.x, p1.y, p1.x - alloc.x, p1.height);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            context.restore();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    private AlphaComposite getAlphaComposite() {
        if (this.alphaComposite == null) {
            this.alphaComposite = AlphaComposite.getInstance(3, this.alpha);
        }
        return this.alphaComposite;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        this.alpha = Math.max(alpha, 0.0f);
        this.alpha = Math.min(1.0f, alpha);
        this.alphaComposite = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
        if (!this.enabled) {
            return bounds;
        }
        this.color = (Color)view.getAttributes().getAttribute(StyleConstantsEx.SelectedForeground);
        if (this.color == null) {
            this.color = c.getSelectedTextColor();
        }
        this.wrapper.setColor(this.color);
        Shape dirtyShape = null;
        Graphics2D g2d = (Graphics2D)g;
        GraphicsContext context = GraphicsUtil.setupAAPainting(g2d);
        Insets ins = c.getInsets();
        g2d.setClip(ins.left, ins.top, c.getWidth() - ins.left - ins.right, c.getHeight() - ins.top - ins.bottom);
        if (this.getAlpha() < 1.0f) {
            g2d.setComposite(this.getAlphaComposite());
        }
        try {
            dirtyShape = this.paintLayerImpl(g2d, offs0, offs1, c);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            context.restore();
        }
        if (dirtyShape != null && (this.selectionEnd != c.getSelectionEnd() || this.selectionStart != c.getSelectionStart() || this.repaintCount < 2)) {
            this.selectionStart = c.getSelectionStart();
            this.selectionEnd = c.getSelectionEnd();
            c.repaint(dirtyShape.getBounds());
            this.repaintCount = !c.getComponentOrientation().isLeftToRight() ? (this.repaintCount >= 1 ? 0 : 1) : 2;
        }
        context.restore();
        return dirtyShape;
    }

    protected Shape paintLayerImpl(Graphics2D g2d, int offs0, int offs1, JTextComponent c) throws BadLocationException {
        Shape dirtyShape;
        Rectangle posStart = c.modelToView(c.getSelectionStart());
        Rectangle posStartPrev = c.modelToView(Math.max(0, c.getSelectionStart() - 1));
        Rectangle posEnd = c.modelToView(c.getSelectionEnd());
        Rectangle posEndPrev = c.modelToView(Math.max(0, c.getSelectionEnd() - 1));
        Rectangle posOffs0 = c.modelToView(offs0);
        Rectangle posOffs0Prev = c.modelToView(Math.max(0, offs0 - 1)).getBounds();
        Rectangle posOffs1 = c.getUI().modelToView(c, offs1, Position.Bias.Backward);
        Rectangle posOffs1Forward = c.modelToView(offs1);
        Rectangle posOffs1Next = c.modelToView(Math.min(c.getDocument().getLength(), offs1 - 1));
        boolean selectionStart = c.getSelectionStart() >= offs0;
        boolean selectionEnd = c.getSelectionEnd() <= offs1;
        Insets margin = c.getInsets();
        boolean firstLineNotPainted = posStartPrev.y + posStartPrev.height == posStart.y;
        boolean lastLineNotPainted = posOffs1Next.y == posEnd.y && posOffs1.y == posOffs1Forward.y;
        boolean isToEndOfLine = posOffs1.y < posEnd.y && !lastLineNotPainted;
        boolean isToStartOfLine = !selectionEnd && posOffs0.y > posStart.y && posOffs0.y != posOffs0Prev.y;
        Rectangle alloc = offs0 == offs1 && posEnd.y != posStart.y ? new Rectangle(margin.left, posOffs0.y, c.getWidth() - margin.left - margin.right, posOffs0.height) : new Rectangle(posOffs0.x, posOffs0.y, posOffs1.x + posOffs1.width - posOffs0.x, posOffs1.y + posOffs1.height - posOffs0.y);
        boolean isFirstLine = alloc.y == posStart.y;
        boolean isSecondLine = posStart.y + posStart.height == alloc.y;
        boolean isSecondLastLine = alloc.y + alloc.height == posEnd.y;
        boolean isLastLine = alloc.y == posEnd.y || isSecondLastLine && posEnd.y != posEndPrev.y;
        boolean endBeforeStart = (double)posEnd.x < (double)posStart.x + (double)this.arcSize / 2.0 && (posEnd.y == posStart.y + posStart.height || posEnd.y <= posStart.y + 2 * posStart.height && posEnd.x == margin.left);
        int originalWidth = alloc.width;
        int originalX = alloc.x;
        alloc.width = Math.max(2 * this.arcSize, alloc.width);
        alloc.x = Math.max(margin.left, Math.min(c.getWidth() - margin.right - alloc.width, alloc.x));
        this.setupColor(g2d, c);
        if (offs0 == offs1 && posEnd.y != posStart.y) {
            isToEndOfLine = false;
            isToStartOfLine = false;
            dirtyShape = this.paintMiddleSelection(g2d, alloc, c, false, false, isFirstLine, isLastLine, isSecondLastLine, isSecondLine, firstLineNotPainted, lastLineNotPainted);
        } else if (!selectionStart && !selectionEnd) {
            dirtyShape = this.paintMiddleSelection(g2d, alloc, c, isToEndOfLine, isToStartOfLine, isFirstLine, isLastLine, isSecondLastLine, isSecondLine, firstLineNotPainted, lastLineNotPainted);
        } else if (posEnd.y == posStart.y) {
            Rectangle rect = alloc;
            if (originalWidth < 2 * this.arcSize && this.isRounded(c)) {
                this.suppressRounded = true;
                rect = new Rectangle(originalX, alloc.y, originalWidth, alloc.height);
            }
            this.paintSelection(g2d, c, rect, selectionStart, selectionEnd);
            dirtyShape = alloc;
            this.suppressRounded = false;
        } else {
            dirtyShape = selectionStart ? this.paintSelectionStart(g2d, alloc, c, posStart, posOffs0, endBeforeStart, isSecondLastLine, isToEndOfLine) : this.paintSelectionEnd(g2d, alloc, c, posStart, isFirstLine, isSecondLine, isToStartOfLine, isToEndOfLine, endBeforeStart);
        }
        dirtyShape = this.paintExtension(g2d, c, isToEndOfLine, isToStartOfLine, isFirstLine, isLastLine, isSecondLine, isSecondLastLine, selectionStart, selectionEnd, posStart, posEnd, dirtyShape.getBounds());
        return dirtyShape;
    }

    private Shape paintMiddleSelection(Graphics2D g, Rectangle r, JTextComponent c, boolean toEndOfLine, boolean toStartOfLine, boolean isFirstLine, boolean isLastLine, boolean isSecondLastLine, boolean isSecondLine, boolean firstLineNotPainted, boolean lastLineNotPainted) {
        if (toStartOfLine) {
            r.width -= this.arcSize;
            r.x += this.arcSize;
        }
        if (toEndOfLine) {
            r.width -= this.arcSize;
        }
        if (!this.isRounded(c)) {
            g.fillRect(r.x, r.y, r.width, r.height);
        } else {
            boolean firstVisual = isFirstLine || isSecondLine && firstLineNotPainted;
            boolean lastVisual = isLastLine || isSecondLine && lastLineNotPainted;
            this.paintRoundRect(g, r, this.arcSize, firstVisual, firstVisual, isLastLine, lastVisual);
        }
        return r;
    }

    private Shape paintSelectionStart(Graphics2D g2d, Rectangle r, JTextComponent c, Rectangle posStart, Rectangle posOffs0, boolean endBeforeStart, boolean isSecondLastLine, boolean extendToEnd) {
        Insets margin = c.getInsets();
        boolean rounded = this.isRounded(c);
        if (rounded && extendToEnd) {
            r.width -= this.arcSize;
        }
        if (rounded) {
            boolean drawCorner;
            boolean roundLeftBottom;
            boolean bl = roundLeftBottom = endBeforeStart && isSecondLastLine;
            if (r.width < 2 * this.arcSize) {
                r.width = 2 * this.arcSize;
            }
            this.paintRoundRect(g2d, r, this.arcSize, true, false, roundLeftBottom, false);
            boolean bl2 = drawCorner = posOffs0.equals(posStart) && !roundLeftBottom && r.x >= margin.left + this.arcSize;
            if (drawCorner) {
                this.paintStartArc(g2d, r);
                r.x -= this.arcSize;
                r.width += this.arcSize;
            }
        } else {
            g2d.fillRect(r.x, r.y, r.width, r.height);
        }
        return r;
    }

    private Shape paintSelection(Graphics2D g2d, JTextComponent c, Rectangle r, boolean selectionStart, boolean selectionEnd) {
        if (this.isRounded(c)) {
            this.paintRoundedLeftRight(g2d, selectionStart, selectionEnd, r);
        } else {
            g2d.fillRect(r.x, r.y, r.width, r.height);
        }
        return r;
    }

    private Shape paintSelectionEnd(Graphics2D g2d, Rectangle r, JTextComponent c, Rectangle posStart, boolean isFirstLine, boolean isSecondLine, boolean extendToStart, boolean extendToEnd, boolean endBeforeStart) {
        boolean rounded = this.isRounded(c);
        Insets margin = c.getInsets();
        if ((double)(r.x + r.width) >= (double)(c.getWidth() - margin.right) - (double)this.arcSize / 2.0) {
            int end = c.getWidth() - margin.right;
            r.width = end - r.x;
            if (rounded && extendToEnd) {
                r.width -= this.arcSize;
            }
        }
        if (rounded) {
            boolean drawCorner;
            boolean roundRightTop = endBeforeStart && !extendToEnd;
            boolean roundLeftBottom = !isFirstLine && !extendToStart;
            boolean roundLeftTop = isSecondLine && !extendToStart && posStart.x >= r.x + this.arcSize;
            this.paintRoundRect(g2d, r, this.arcSize, roundLeftTop, roundRightTop, roundLeftBottom, !extendToEnd);
            boolean bl = drawCorner = !extendToEnd && !roundRightTop && r.x + r.width <= c.getWidth() - margin.right - this.arcSize;
            if (drawCorner) {
                this.paintEndArc(g2d, r);
                r.width += this.arcSize;
            }
        } else {
            g2d.fillRect(r.x, r.y, r.width, r.height);
        }
        return r;
    }

    private boolean isRounded(JTextComponent c) {
        return !this.suppressRounded && (this.roundedEdges || Boolean.TRUE.equals(c.getClientProperty("JTextComponent.roundedSelection")));
    }

    private Shape paintExtension(Graphics2D g2d, JTextComponent c, boolean isToEndOfLine, boolean isToStartOfLine, boolean isFirstLine, boolean isLastLine, boolean isSecondLine, boolean isSecondLastLine, boolean selectionStart, boolean selectionEnd, Rectangle posStart, Rectangle posEnd, Rectangle r) {
        int start;
        Insets ins = c.getInsets();
        boolean rounded = this.isRounded(c);
        if (isToEndOfLine) {
            start = r.x + r.width;
            int w = c.getWidth() - start - ins.right;
            w = Math.max(2 * this.arcSize, w);
            start = Math.min(start, c.getWidth() - ins.right - w);
            if (rounded) {
                boolean roundTop = isFirstLine || selectionStart;
                boolean roundBottom = isLastLine || isSecondLastLine && posEnd.x + posEnd.width <= start + w - this.arcSize;
                boolean roundLeftTop = isFirstLine && start == ins.left;
                this.paintRoundRect(g2d, new Rectangle(start, r.y, w, r.height), this.arcSize, roundLeftTop, roundTop, false, roundBottom);
            } else {
                g2d.fillRect(start, r.y, w, r.height);
            }
            r.x = Math.min(r.x, start);
            r.width += w;
        }
        if (isToStartOfLine) {
            start = ins.left;
            int end = r.x;
            int w = end - start;
            w = Math.max(2 * this.arcSize, w);
            end = Math.max(end, start + w);
            if (rounded) {
                boolean roundTop = isFirstLine || isSecondLine && posStart.x >= start + this.arcSize;
                boolean roundBottom = isLastLine || selectionEnd;
                boolean roundRightBottom = isLastLine && end == c.getWidth() - ins.right;
                this.paintRoundRect(g2d, new Rectangle(start, r.y, w, r.height), this.arcSize, roundTop, false, roundBottom, roundRightBottom);
            } else {
                g2d.fillRect(start, r.y, w, r.height);
            }
            r.width += w;
            r.x = start;
        }
        return r;
    }

    private void paintRoundRect(Graphics g, Rectangle r, int arcSize, boolean leftTop, boolean rightTop, boolean leftBottom, boolean rightBottom) {
        int aw = Math.min(arcSize, r.width);
        int ah = Math.min(arcSize, r.height);
        g.fillRoundRect(r.x, r.y, r.width, r.height, aw, ah);
        if (!leftTop) {
            g.fillRect(r.x, r.y, aw, ah);
        }
        if (!leftBottom) {
            g.fillRect(r.x, r.y + r.height - ah, aw, ah);
        }
        if (!rightTop) {
            g.fillRect(r.x + r.width - aw, r.y, aw, ah);
        }
        if (!rightBottom) {
            g.fillRect(r.x + r.width - aw, r.y + r.height - ah, aw, ah);
        }
    }

    private void paintStartArc(Graphics2D g2d, Rectangle r) {
        Area arc = new Area(new Rectangle2D.Double((double)(r.x - this.arcSize) + 0.25, (double)(r.y + r.height - this.arcSize) + 0.25, this.arcSize, this.arcSize));
        arc.subtract(new Area(new Arc2D.Double((double)(r.x - 2 * this.arcSize) + 0.25, (double)(r.y + r.height - 2 * this.arcSize) + 0.25, 2 * this.arcSize, 2 * this.arcSize, 0.0, -90.0, 2)));
        g2d.fill(arc);
        r.x -= this.arcSize;
        r.width += this.arcSize;
    }

    private void paintRoundedLeftRight(Graphics g, boolean left, boolean right, Rectangle r) {
        if (right || left) {
            g.fillRoundRect(r.x, r.y, r.width, r.height, this.arcSize, this.arcSize);
            if (!left) {
                g.fillRect(r.x, r.y, this.arcSize, r.height);
            }
            if (!right) {
                g.fillRect(r.x + r.width - this.arcSize, r.y, this.arcSize, r.height);
            }
        } else {
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    private void paintEndArc(Graphics2D g2d, Rectangle r) {
        Area arc = new Area(new Rectangle2D.Double((double)(r.x + r.width) - 0.25, (double)r.y - 0.25, this.arcSize, this.arcSize));
        arc.subtract(new Area(new Arc2D.Double((double)(r.x + r.width) - 0.25, (double)r.y - 0.25, 2 * this.arcSize, 2 * this.arcSize, 90.0, 90.0, 2)));
        g2d.fill(arc);
    }

    private void setupColor(Graphics2D g2d, JTextComponent c) {
        Paint paint = this.getPaint();
        if (paint == null) {
            g2d.setColor(c.getSelectionColor());
        } else {
            g2d.setPaint(paint);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

