/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.point;

import georegression.struct.GeoTuple_I32;
import java.util.Objects;

public class Point2D_I32
extends GeoTuple_I32<Point2D_I32> {
    public int x;
    public int y;

    public Point2D_I32(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point2D_I32(Point2D_I32 orig) {
        this.x = orig.x;
        this.y = orig.y;
    }

    public Point2D_I32() {
    }

    public void setTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public double distance(Point2D_I32 a) {
        int dx = this.x - a.x;
        int dy = this.y - a.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(int x, int y) {
        int dx = this.x - x;
        int dy = this.y - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public int distance2(Point2D_I32 a) {
        int dx = this.x - a.x;
        int dy = this.y - a.y;
        return dx * dx + dy * dy;
    }

    public int distance2(int x, int y) {
        int dx = this.x - x;
        int dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public boolean isIdentical(int x, int y) {
        return this.x == x && this.y == y;
    }

    @Override
    public void setTo(Point2D_I32 src) {
        this.x = src.x;
        this.y = src.y;
    }

    @Override
    public int getIdx(int index) {
        if (index == 0) {
            return this.x;
        }
        if (index == 1) {
            return this.y;
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public void setIdx(int index, int value) {
        if (index == 0) {
            this.x = value;
        } else if (index == 1) {
            this.y = value;
        } else {
            throw new RuntimeException("Invalid index " + index);
        }
    }

    public void print() {
        System.out.println(this.toString());
    }

    @Override
    public Point2D_I32 copy() {
        return new Point2D_I32(this);
    }

    public String toString() {
        return "Point2D_I32{x=" + this.x + ", y=" + this.y + '}';
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Point2D_I32 createNewInstance() {
        return new Point2D_I32();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Point2D_I32)) {
            return false;
        }
        Point2D_I32 p = (Point2D_I32)obj;
        return this.x == p.x && this.y == p.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }
}

