/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point3D_F64;
import java.io.Serializable;

public class LineSegment3D_F64
implements Serializable {
    public Point3D_F64 a = new Point3D_F64();
    public Point3D_F64 b = new Point3D_F64();

    public LineSegment3D_F64() {
    }

    public LineSegment3D_F64(Point3D_F64 a, Point3D_F64 b) {
        this.setTo(a, b);
    }

    public LineSegment3D_F64(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.setTo(x0, y0, z0, x1, y1, z1);
    }

    public static LineSegment3D_F64 wrap(Point3D_F64 a, Point3D_F64 b) {
        LineSegment3D_F64 ret = new LineSegment3D_F64();
        ret.a = a;
        ret.b = b;
        return ret;
    }

    public void setTo(LineSegment3D_F64 l) {
        this.a.setTo(l.a);
        this.b.setTo(l.b);
    }

    public void setTo(Point3D_F64 a, Point3D_F64 b) {
        this.a.setTo(a);
        this.b.setTo(b);
    }

    public void setTo(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.a.setTo(x0, y0, z0);
        this.b.setTo(x1, y1, z1);
    }

    public Point3D_F64 getA() {
        return this.a;
    }

    public void setA(Point3D_F64 a) {
        this.a = a;
    }

    public Point3D_F64 getB() {
        return this.b;
    }

    public void setB(Point3D_F64 b) {
        this.b = b;
    }

    public double slopeX() {
        return this.b.x - this.a.x;
    }

    public double slopeY() {
        return this.b.y - this.a.y;
    }

    public double getLength() {
        return this.a.distance((GeoTuple_F64)this.b);
    }

    public double getLength2() {
        return this.a.distance2((GeoTuple_F64)this.b);
    }

    public LineSegment3D_F64 copy() {
        return new LineSegment3D_F64(this.a, this.b);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{a=" + this.a + ", b=" + this.b + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineSegment3D_F64)) {
            return false;
        }
        LineSegment3D_F64 o = (LineSegment3D_F64)obj;
        return this.a.equals(o.a) && this.b.equals(o.b);
    }

    public int hashCode() {
        return this.a.hashCode() + this.b.hashCode();
    }
}

