/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import java.io.Serializable;
import org.ejml.FancyPrint;

public class LineParametric3D_F32
implements Serializable {
    public Point3D_F32 p;
    public Vector3D_F32 slope;

    public LineParametric3D_F32(float x_0, float y_0, float z_0, float slopeX, float slopeY, float slopeZ) {
        this();
        this.p.setTo(x_0, y_0, z_0);
        this.slope.setTo(slopeX, slopeY, slopeZ);
    }

    public LineParametric3D_F32(Point3D_F32 p, Vector3D_F32 slope) {
        this();
        this.setPoint(p);
        this.setSlope(slope);
    }

    public LineParametric3D_F32() {
        this.p = new Point3D_F32();
        this.slope = new Vector3D_F32();
    }

    public LineParametric3D_F32(LineParametric3D_F32 l) {
        this();
        this.p.setTo(l.p);
        this.slope.setTo(l.slope);
    }

    public LineParametric3D_F32(boolean declare) {
        if (declare) {
            this.p = new Point3D_F32();
            this.slope = new Vector3D_F32();
        }
    }

    public void setPointOnLine(float t, Point3D_F32 where) {
        where.x = this.p.x + t * this.slope.x;
        where.y = this.p.y + t * this.slope.y;
        where.z = this.p.z + t * this.slope.z;
    }

    public void setPoint(Point3D_F32 pt) {
        this.p.setTo(pt);
    }

    public void setPoint(float x, float y, float z) {
        this.p.x = x;
        this.p.y = y;
        this.p.z = z;
    }

    public void setSlope(Vector3D_F32 slope) {
        this.slope.setTo(slope);
    }

    public void setSlope(float slopeX, float slopeY, float slopeZ) {
        this.slope.x = slopeX;
        this.slope.y = slopeY;
        this.slope.z = slopeZ;
    }

    public Point3D_F32 getPointOnLine(float t) {
        return new Point3D_F32(this.slope.x * t + this.p.x, this.slope.y * t + this.p.y, this.slope.z * t + this.p.z);
    }

    public Point3D_F32 getPoint() {
        return this.p;
    }

    public Vector3D_F32 getSlope() {
        return this.slope;
    }

    public final float getSlopeX() {
        return this.slope.x;
    }

    public final float getSlopeY() {
        return this.slope.y;
    }

    public final float getSlopeZ() {
        return this.slope.z;
    }

    public final float getX() {
        return this.p.x;
    }

    public final float getY() {
        return this.p.y;
    }

    public final float getZ() {
        return this.p.z;
    }

    public void setTo(float x_0, float y_0, float z_0, float slopeX, float slopeY, float slopeZ) {
        this.p.setTo(x_0, y_0, z_0);
        this.slope.setTo(slopeX, slopeY, slopeZ);
    }

    public void setTo(LineParametric3D_F32 o) {
        this.p.setTo(o.p);
        this.slope.setTo(o.slope);
    }

    public Point3D_F32 getP() {
        return this.p;
    }

    public void setP(Point3D_F32 p) {
        this.p = p;
    }

    public LineParametric3D_F32 copy() {
        return new LineParametric3D_F32(this.p, this.slope);
    }

    public String toString() {
        FancyPrint f = new FancyPrint();
        return this.getClass().getSimpleName() + " P( " + f.s(this.p.x) + " " + f.s(this.p.y) + " " + f.s(this.p.z) + " ) Slope( " + f.s(this.slope.x) + " " + f.s(this.slope.y) + " " + f.s(this.slope.z) + " )";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineParametric3D_F32)) {
            return false;
        }
        LineParametric3D_F32 o = (LineParametric3D_F32)obj;
        return this.p.equals(o.p) && this.slope.equals(o.slope);
    }

    public int hashCode() {
        return this.p.hashCode() + this.slope.hashCode();
    }
}

