/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.homography;

import georegression.struct.Matrix3x3_F64;
import georegression.struct.homography.Homography;
import org.ejml.data.DMatrixRMaj;
import org.ejml.ops.DConvertMatrixStruct;
import org.jetbrains.annotations.Nullable;

public class Homography2D_F64
extends Matrix3x3_F64
implements Homography<Homography2D_F64> {
    public Homography2D_F64(double a11, double a12, double a13, double a21, double a22, double a23, double a31, double a32, double a33) {
        this.a11 = a11;
        this.a12 = a12;
        this.a13 = a13;
        this.a21 = a21;
        this.a22 = a22;
        this.a23 = a23;
        this.a31 = a31;
        this.a32 = a32;
        this.a33 = a33;
    }

    public Homography2D_F64(Homography2D_F64 a) {
        this.setTo(a);
    }

    public Homography2D_F64() {
        this.reset();
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Homography2D_F64 createInstance() {
        return new Homography2D_F64();
    }

    @Override
    public void setTo(Homography2D_F64 target) {
        super.set(target);
    }

    @Override
    public Homography2D_F64 concat(Homography2D_F64 second, @Nullable Homography2D_F64 ret) {
        if (ret == null) {
            ret = new Homography2D_F64();
        }
        ret.a11 = second.a11 * this.a11 + second.a12 * this.a21 + second.a13 * this.a31;
        ret.a12 = second.a11 * this.a12 + second.a12 * this.a22 + second.a13 * this.a32;
        ret.a13 = second.a11 * this.a13 + second.a12 * this.a23 + second.a13 * this.a33;
        ret.a21 = second.a21 * this.a11 + second.a22 * this.a21 + second.a23 * this.a31;
        ret.a22 = second.a21 * this.a12 + second.a22 * this.a22 + second.a23 * this.a32;
        ret.a23 = second.a21 * this.a13 + second.a22 * this.a23 + second.a23 * this.a33;
        ret.a31 = second.a31 * this.a11 + second.a32 * this.a21 + second.a33 * this.a31;
        ret.a32 = second.a31 * this.a12 + second.a32 * this.a22 + second.a33 * this.a32;
        ret.a33 = second.a31 * this.a13 + second.a32 * this.a23 + second.a33 * this.a33;
        return ret;
    }

    @Override
    public Homography2D_F64 invert(@Nullable Homography2D_F64 ret) {
        if (ret == null) {
            ret = new Homography2D_F64();
        }
        double m11 = this.a22 * this.a33 - this.a23 * this.a32;
        double m12 = -(this.a21 * this.a33 - this.a23 * this.a31);
        double m13 = this.a21 * this.a32 - this.a22 * this.a31;
        double m21 = -(this.a12 * this.a33 - this.a13 * this.a32);
        double m22 = this.a11 * this.a33 - this.a13 * this.a31;
        double m23 = -(this.a11 * this.a32 - this.a12 * this.a31);
        double m31 = this.a12 * this.a23 - this.a13 * this.a22;
        double m32 = -(this.a11 * this.a23 - this.a13 * this.a21);
        double m33 = this.a11 * this.a22 - this.a12 * this.a21;
        double det = this.a11 * m11 + this.a12 * m12 + this.a13 * m13;
        ret.a11 = m11 / det;
        ret.a12 = m21 / det;
        ret.a13 = m31 / det;
        ret.a21 = m12 / det;
        ret.a22 = m22 / det;
        ret.a23 = m32 / det;
        ret.a31 = m13 / det;
        ret.a32 = m23 / det;
        ret.a33 = m33 / det;
        return ret;
    }

    @Override
    public void reset() {
        this.a33 = 1.0;
        this.a22 = 1.0;
        this.a11 = 1.0;
        this.a32 = 0.0;
        this.a31 = 0.0;
        this.a23 = 0.0;
        this.a21 = 0.0;
        this.a13 = 0.0;
        this.a12 = 0.0;
    }

    public DMatrixRMaj ddrm() {
        return this.ddrm(null);
    }

    public DMatrixRMaj ddrm(@Nullable DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(3, 3);
        }
        DConvertMatrixStruct.convert(this, output);
        return output;
    }

    public Homography2D_F64 copy() {
        return new Homography2D_F64(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.format("[ %5.2e %5.2e %5.2e ; %5.2e %5.2e %5.2e ; %5.2e %5.2e %5.2e ]", this.a11, this.a12, this.a13, this.a21, this.a22, this.a23, this.a31, this.a32, this.a33);
    }
}

