/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.curve;

import java.io.Serializable;
import org.ejml.FancyPrint;
import org.ejml.UtilEjml;

public class ConicGeneral_F32
implements Serializable {
    public float A;
    public float B;
    public float C;
    public float D;
    public float E;
    public float F;

    public ConicGeneral_F32(float a, float b, float c, float d, float e, float f) {
        this.A = a;
        this.B = b;
        this.C = c;
        this.D = d;
        this.E = e;
        this.F = f;
    }

    public ConicGeneral_F32(ConicGeneral_F32 original) {
        this.setTo(original);
    }

    public ConicGeneral_F32() {
    }

    public float evaluate(float x, float y) {
        return this.A * x * x + this.B * x * y + this.C * y * y + this.D * x + this.E * y + this.F;
    }

    public boolean hasUncountable() {
        return UtilEjml.isUncountable(this.A) || UtilEjml.isUncountable(this.B) || UtilEjml.isUncountable(this.C) || UtilEjml.isUncountable(this.D) || UtilEjml.isUncountable(this.E) || UtilEjml.isUncountable(this.F);
    }

    public boolean isEllipse(float tol) {
        return this.B * this.B + tol < 4.0f * this.A * this.C;
    }

    public boolean isParabola(float tol) {
        return Math.abs(this.B * this.B - 4.0f * this.A * this.C) <= tol;
    }

    public boolean isHyperbola(float tol) {
        return this.B * this.B - tol > 4.0f * this.A * this.C;
    }

    public void setTo(ConicGeneral_F32 original) {
        this.A = original.A;
        this.B = original.B;
        this.C = original.C;
        this.D = original.D;
        this.E = original.E;
        this.F = original.F;
    }

    public void setTo(float a, float b, float c, float d, float e, float f) {
        this.A = a;
        this.B = b;
        this.C = c;
        this.D = d;
        this.E = e;
        this.F = f;
    }

    public ConicGeneral_F32 copy() {
        return new ConicGeneral_F32(this.A, this.B, this.C, this.D, this.E, this.F);
    }

    public String toString() {
        FancyPrint fp = new FancyPrint();
        return "ConicGeneral_F32{A=" + fp.p(this.A) + ", B=" + fp.p(this.B) + ", C=" + fp.p(this.C) + ", D=" + fp.p(this.D) + ", E=" + fp.p(this.E) + ", F=" + fp.p(this.F) + '}';
    }
}

