/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.affine;

import georegression.struct.affine.Affine;
import org.jetbrains.annotations.Nullable;

public class Affine2D_F64
implements Affine<Affine2D_F64> {
    public double a11;
    public double a12;
    public double a21;
    public double a22;
    public double tx;
    public double ty;

    public Affine2D_F64(double a11, double a12, double a21, double a22, double tx, double ty) {
        this.setTo(a11, a12, a21, a22, tx, ty);
    }

    public Affine2D_F64() {
        this.reset();
    }

    public void setTo(double a11, double a12, double a21, double a22, double tx, double ty) {
        this.a11 = a11;
        this.a12 = a12;
        this.a21 = a21;
        this.a22 = a22;
        this.tx = tx;
        this.ty = ty;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Affine2D_F64 createInstance() {
        return new Affine2D_F64();
    }

    @Override
    public void setTo(Affine2D_F64 target) {
        this.a11 = target.a11;
        this.a12 = target.a12;
        this.a21 = target.a21;
        this.a22 = target.a22;
        this.tx = target.tx;
        this.ty = target.ty;
    }

    @Override
    public Affine2D_F64 concat(Affine2D_F64 second, @Nullable Affine2D_F64 ret) {
        if (ret == null) {
            ret = new Affine2D_F64();
        }
        ret.a11 = second.a11 * this.a11 + second.a12 * this.a21;
        ret.a12 = second.a11 * this.a12 + second.a12 * this.a22;
        ret.a21 = second.a21 * this.a11 + second.a22 * this.a21;
        ret.a22 = second.a21 * this.a12 + second.a22 * this.a22;
        ret.tx = second.a11 * this.tx + second.a12 * this.ty + second.tx;
        ret.ty = second.a21 * this.tx + second.a22 * this.ty + second.ty;
        return ret;
    }

    @Override
    public Affine2D_F64 invert(@Nullable Affine2D_F64 inverse) {
        if (inverse == null) {
            inverse = new Affine2D_F64();
        }
        double div = this.a11 * this.a22 - this.a12 * this.a21;
        inverse.a11 = this.a22 / div;
        inverse.a12 = -this.a12 / div;
        inverse.a21 = -this.a21 / div;
        inverse.a22 = this.a11 / div;
        inverse.tx = -(inverse.a11 * this.tx + inverse.a12 * this.ty);
        inverse.ty = -(inverse.a21 * this.tx + inverse.a22 * this.ty);
        return inverse;
    }

    @Override
    public void reset() {
        this.a22 = 1.0;
        this.a11 = 1.0;
        this.a21 = 0.0;
        this.a12 = 0.0;
        this.ty = 0.0;
        this.tx = 0.0;
    }

    public Affine2D_F64 copy() {
        return new Affine2D_F64(this.a11, this.a12, this.a21, this.a22, this.tx, this.ty);
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.format("[ %5.2e %5.2e %5.2e ; %5.2e %5.2e %5.2e ]", this.a11, this.a12, this.tx, this.a21, this.a22, this.ty);
    }
}

