/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric.alg;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;

public class DistancePointTriangle3D_F64 {
    private Point3D_F64 B = new Point3D_F64();
    private Vector3D_F64 E0 = new Vector3D_F64();
    private Vector3D_F64 E1 = new Vector3D_F64();
    private Vector3D_F64 N = new Vector3D_F64();
    private double s;
    private double t;
    private Vector3D_F64 D = new Vector3D_F64();
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;

    public void setTriangle(Point3D_F64 p0, Point3D_F64 p1, Point3D_F64 p2) {
        this.B.setTo(p0);
        GeometryMath_F64.sub(p1, p0, this.E0);
        GeometryMath_F64.sub(p2, p0, this.E1);
    }

    public void closestPoint(Point3D_F64 P, Point3D_F64 closestPt) {
        GeometryMath_F64.sub(this.B, P, this.D);
        this.a = this.E0.dot(this.E0);
        this.b = this.E0.dot(this.E1);
        this.c = this.E1.dot(this.E1);
        this.d = this.E0.dot(this.D);
        this.e = this.E1.dot(this.D);
        double det = this.a * this.c - this.b * this.b;
        this.s = this.b * this.e - this.c * this.d;
        this.t = this.b * this.d - this.a * this.e;
        if (this.s + this.t <= det) {
            if (this.s < 0.0) {
                if (this.t < 0.0) {
                    this.region4();
                } else {
                    this.region3();
                }
            } else if (this.t < 0.0) {
                this.region5();
            } else {
                this.region0(det);
            }
        } else if (this.s < 0.0) {
            this.region2();
        } else if (this.t < 0.0) {
            this.region6();
        } else {
            this.region1();
        }
        closestPt.x = this.B.x + this.s * this.E0.x + this.t * this.E1.x;
        closestPt.y = this.B.y + this.s * this.E0.y + this.t * this.E1.y;
        closestPt.z = this.B.z + this.s * this.E0.z + this.t * this.E1.z;
    }

    public double sign(Point3D_F64 P) {
        GeometryMath_F64.cross(this.E1, (GeoTuple3D_F64)this.E0, (GeoTuple3D_F64)this.N);
        double d = this.N.x * (P.x - this.B.x) + this.N.y * (P.y - this.B.y) + this.N.z * (P.z - this.B.z);
        return Math.signum(d);
    }

    protected void region0(double det) {
        double invDet = 1.0 / det;
        this.s *= invDet;
        this.t *= invDet;
    }

    protected void region1() {
        double denom;
        double numer = this.c + this.e - this.b - this.d;
        this.s = numer <= 0.0 ? 0.0 : (numer >= (denom = this.a - 2.0 * this.b + this.c) ? 1.0 : numer / denom);
        this.t = 1.0 - this.s;
    }

    protected void region2() {
        double tmp1 = this.c + this.e;
        double tmp0 = this.b + this.d;
        if (tmp1 > tmp0) {
            double numer = tmp1 - tmp0;
            double denom = this.a - 2.0 * this.b + this.c;
            this.s = numer <= denom ? 1.0 : numer / denom;
            this.t = 1.0 - this.s;
        } else {
            this.s = 0.0;
            this.t = tmp1 <= 0.0 ? 1.0 : (this.e >= 0.0 ? 0.0 : -this.e / this.c);
        }
    }

    protected void region3() {
        this.s = 0.0;
        this.t = this.e >= 0.0 ? 0.0 : (-this.e >= this.c ? 1.0 : -this.e / this.c);
    }

    protected void region4() {
        if (this.d < 0.0) {
            this.t = 0.0;
            this.s = -this.d >= this.a ? 1.0 : -this.d / this.a;
        } else {
            this.s = 0.0;
            this.t = this.e >= 0.0 ? 0.0 : (-this.e >= this.c ? 1.0 : -this.e / this.c);
        }
    }

    protected void region5() {
        this.t = 0.0;
        this.s = this.d >= 0.0 ? 0.0 : (-this.d >= this.a ? 1.0 : -this.d / this.a);
    }

    protected void region6() {
        double tmp1 = this.a + this.d;
        double tmp0 = this.b + this.e;
        if (tmp1 > tmp0) {
            double numer = tmp1 - tmp0;
            double denom = this.a - 2.0 * this.b + this.c;
            this.t = numer >= denom ? 1.0 : numer / denom;
            this.s = 1.0 - this.t;
        } else {
            this.t = 0.0;
            this.s = tmp1 <= 0.0 ? 1.0 : (this.d >= 0.0 ? 0.0 : -this.d / this.a);
        }
    }
}

