/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.metric.Intersection3D_F64;
import georegression.metric.MiscOps;
import georegression.metric.alg.DistancePointTriangle3D_F64;
import georegression.struct.GeoTuple_F64;
import georegression.struct.line.LineParametric3D_F64;
import georegression.struct.line.LineSegment3D_F64;
import georegression.struct.plane.PlaneGeneral3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.shapes.Box3D_F64;
import georegression.struct.shapes.Cylinder3D_F64;
import georegression.struct.shapes.Sphere3D_F64;
import georegression.struct.shapes.Triangle3D_F64;

public class Distance3D_F64 {
    public static double distance(LineParametric3D_F64 l0, LineParametric3D_F64 l1) {
        double dz;
        double dy;
        double t1;
        double x = l0.p.x - l1.p.x;
        double y = l0.p.y - l1.p.y;
        double z = l0.p.z - l1.p.z;
        double dv01v1 = MiscOps.dot(x, y, z, l1.slope);
        double dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        double dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        double bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        double t0 = bottom == 0.0 ? 0.0 : (dv01v1 * dv1v0 - MiscOps.dot(x, y, z, l0.slope) * dv1v1) / bottom;
        double dx = l0.p.x + t0 * l0.slope.x - (l1.p.x + (t1 = (dv01v1 + t0 * dv1v0) / dv1v1) * l1.slope.x);
        double distanceSq = dx * dx + (dy = l0.p.y + t0 * l0.slope.y - (l1.p.y + t1 * l1.slope.y)) * dy + (dz = l0.p.z + t0 * l0.slope.z - (l1.p.z + t1 * l1.slope.z)) * dz;
        if (distanceSq < 0.0) {
            return 0.0;
        }
        return Math.sqrt(distanceSq);
    }

    public static double distance(LineParametric3D_F64 l, Point3D_F64 p) {
        double x = l.p.x - p.x;
        double y = l.p.y - p.y;
        double z = l.p.z - p.z;
        double cc = x * x + y * y + z * z;
        double b = MiscOps.dot(x, y, z, l.slope) / l.slope.norm();
        double distanceSq = cc - b * b;
        if (distanceSq < 0.0) {
            return 0.0;
        }
        return Math.sqrt(distanceSq);
    }

    public static double distance(LineSegment3D_F64 l, Point3D_F64 p) {
        double dx = p.x - l.a.x;
        double dy = p.y - l.a.y;
        double dz = p.z - l.a.z;
        double cc = dx * dx + dy * dy + dz * dz;
        double slope_x = l.b.x - l.a.x;
        double slope_y = l.b.y - l.a.y;
        double slope_z = l.b.z - l.a.z;
        double n = Math.sqrt(slope_x * slope_x + slope_y * slope_y + slope_z * slope_z);
        double d = (slope_x * dx + slope_y * dy + slope_z * dz) / n;
        if (d <= 0.0) {
            return p.distance((GeoTuple_F64)l.a);
        }
        if (d >= n) {
            return p.distance((GeoTuple_F64)l.b);
        }
        double distanceSq = cc - d * d;
        if (distanceSq < 0.0) {
            return 0.0;
        }
        return Math.sqrt(distanceSq);
    }

    public static double distance(PlaneGeneral3D_F64 plane, Point3D_F64 point) {
        double top = plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
        return top / Math.sqrt(plane.A * plane.A + plane.B * plane.B + plane.C * plane.C);
    }

    public static double distance(Sphere3D_F64 sphere, Point3D_F64 point) {
        double r = point.distance((GeoTuple_F64)sphere.center);
        return r - sphere.radius;
    }

    public static double distance(Cylinder3D_F64 cylinder, Point3D_F64 point) {
        double r = Distance3D_F64.distance(cylinder.line, point);
        return r - cylinder.radius;
    }

    public static double distance(Triangle3D_F64 triangle, Point3D_F64 point) {
        DistancePointTriangle3D_F64 alg = new DistancePointTriangle3D_F64();
        alg.setTriangle(triangle.v0, triangle.v1, triangle.v2);
        Point3D_F64 cp = new Point3D_F64();
        alg.closestPoint(point, cp);
        double d = point.distance((GeoTuple_F64)cp);
        return alg.sign(point) * d;
    }

    public static double scoreIoU(Box3D_F64 a, Box3D_F64 b) {
        double areaI = Intersection3D_F64.intersectionArea(a, b);
        if (areaI == 0.0) {
            return 0.0;
        }
        return areaI / (a.area() + b.area() - areaI);
    }
}

