/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.metric.Intersection3D_F32;
import georegression.metric.MiscOps;
import georegression.metric.alg.DistancePointTriangle3D_F32;
import georegression.struct.GeoTuple_F32;
import georegression.struct.line.LineParametric3D_F32;
import georegression.struct.line.LineSegment3D_F32;
import georegression.struct.plane.PlaneGeneral3D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.shapes.Box3D_F32;
import georegression.struct.shapes.Cylinder3D_F32;
import georegression.struct.shapes.Sphere3D_F32;
import georegression.struct.shapes.Triangle3D_F32;

public class Distance3D_F32 {
    public static float distance(LineParametric3D_F32 l0, LineParametric3D_F32 l1) {
        float dz;
        float dy;
        float t1;
        float x = l0.p.x - l1.p.x;
        float y = l0.p.y - l1.p.y;
        float z = l0.p.z - l1.p.z;
        float dv01v1 = MiscOps.dot(x, y, z, l1.slope);
        float dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        float dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        float bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        float t0 = bottom == 0.0f ? 0.0f : (dv01v1 * dv1v0 - MiscOps.dot(x, y, z, l0.slope) * dv1v1) / bottom;
        float dx = l0.p.x + t0 * l0.slope.x - (l1.p.x + (t1 = (dv01v1 + t0 * dv1v0) / dv1v1) * l1.slope.x);
        float distanceSq = dx * dx + (dy = l0.p.y + t0 * l0.slope.y - (l1.p.y + t1 * l1.slope.y)) * dy + (dz = l0.p.z + t0 * l0.slope.z - (l1.p.z + t1 * l1.slope.z)) * dz;
        if (distanceSq < 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(distanceSq);
    }

    public static float distance(LineParametric3D_F32 l, Point3D_F32 p) {
        float x = l.p.x - p.x;
        float y = l.p.y - p.y;
        float z = l.p.z - p.z;
        float cc = x * x + y * y + z * z;
        float b = MiscOps.dot(x, y, z, l.slope) / l.slope.norm();
        float distanceSq = cc - b * b;
        if (distanceSq < 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(distanceSq);
    }

    public static float distance(LineSegment3D_F32 l, Point3D_F32 p) {
        float dx = p.x - l.a.x;
        float dy = p.y - l.a.y;
        float dz = p.z - l.a.z;
        float cc = dx * dx + dy * dy + dz * dz;
        float slope_x = l.b.x - l.a.x;
        float slope_y = l.b.y - l.a.y;
        float slope_z = l.b.z - l.a.z;
        float n = (float)Math.sqrt(slope_x * slope_x + slope_y * slope_y + slope_z * slope_z);
        float d = (slope_x * dx + slope_y * dy + slope_z * dz) / n;
        if (d <= 0.0f) {
            return p.distance((GeoTuple_F32)l.a);
        }
        if (d >= n) {
            return p.distance((GeoTuple_F32)l.b);
        }
        float distanceSq = cc - d * d;
        if (distanceSq < 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(distanceSq);
    }

    public static float distance(PlaneGeneral3D_F32 plane, Point3D_F32 point) {
        float top = plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
        return top / (float)Math.sqrt(plane.A * plane.A + plane.B * plane.B + plane.C * plane.C);
    }

    public static float distance(Sphere3D_F32 sphere, Point3D_F32 point) {
        float r = point.distance((GeoTuple_F32)sphere.center);
        return r - sphere.radius;
    }

    public static float distance(Cylinder3D_F32 cylinder, Point3D_F32 point) {
        float r = Distance3D_F32.distance(cylinder.line, point);
        return r - cylinder.radius;
    }

    public static float distance(Triangle3D_F32 triangle, Point3D_F32 point) {
        DistancePointTriangle3D_F32 alg = new DistancePointTriangle3D_F32();
        alg.setTriangle(triangle.v0, triangle.v1, triangle.v2);
        Point3D_F32 cp = new Point3D_F32();
        alg.closestPoint(point, cp);
        float d = point.distance((GeoTuple_F32)cp);
        return alg.sign(point) * d;
    }

    public static float scoreIoU(Box3D_F32 a, Box3D_F32 b) {
        float areaI = Intersection3D_F32.intersectionArea(a, b);
        if (areaI == 0.0f) {
            return 0.0f;
        }
        return areaI / (a.area() + b.area() - areaI);
    }
}

