/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_I32;
import georegression.struct.shapes.Rectangle2D_I32;
import java.util.List;

public class UtilPolygons2D_I32 {
    public static void bounding(List<Point2D_I32> points, Rectangle2D_I32 rectangle) {
        rectangle.x0 = Integer.MAX_VALUE;
        rectangle.y0 = Integer.MAX_VALUE;
        rectangle.x1 = Integer.MIN_VALUE;
        rectangle.y1 = Integer.MIN_VALUE;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_I32 p = points.get(i);
            if (p.x < rectangle.x0) {
                rectangle.x0 = p.x;
            }
            if (p.x > rectangle.x1) {
                rectangle.x1 = p.x;
            }
            if (p.y < rectangle.y0) {
                rectangle.y0 = p.y;
            }
            if (p.y <= rectangle.y1) continue;
            rectangle.y1 = p.y;
        }
        ++rectangle.x1;
        ++rectangle.y1;
    }

    public static void bounding(Polygon2D_I32 quad, Rectangle2D_I32 rectangle) {
        UtilPolygons2D_I32.bounding(quad.vertexes.toList(), rectangle);
    }

    public static boolean isCCW(List<Point2D_I32> polygon) {
        int N = polygon.size();
        int sign = 0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            int k = (i + 2) % N;
            if (UtilPolygons2D_I32.isPositiveZ(polygon.get(i), polygon.get(j), polygon.get(k))) {
                ++sign;
                continue;
            }
            --sign;
        }
        return sign < 0;
    }

    public static void flip(Polygon2D_I32 a) {
        int N = a.size();
        int H = N / 2;
        for (int i = 1; i <= H; ++i) {
            int j = N - i;
            Point2D_I32 tmp = ((Point2D_I32[])a.vertexes.data)[i];
            ((Point2D_I32[])a.vertexes.data)[i] = ((Point2D_I32[])a.vertexes.data)[j];
            ((Point2D_I32[])a.vertexes.data)[j] = tmp;
        }
    }

    public static boolean isConvex(Polygon2D_I32 poly) {
        int N = poly.size();
        int numPositive = 0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            int k = (i + 2) % N;
            Point2D_I32 a = ((Point2D_I32[])poly.vertexes.data)[i];
            Point2D_I32 b = ((Point2D_I32[])poly.vertexes.data)[j];
            Point2D_I32 c = ((Point2D_I32[])poly.vertexes.data)[k];
            int dx0 = a.x - b.x;
            int dy1 = c.y - b.y;
            int dy0 = a.y - b.y;
            int dx1 = c.x - b.x;
            int z = dx0 * dy1 - dy0 * dx1;
            if (z <= 0) continue;
            ++numPositive;
        }
        return numPositive == 0 || numPositive == N;
    }

    public static boolean isPositiveZ(Point2D_I32 a, Point2D_I32 b, Point2D_I32 c) {
        int dx0 = a.x - b.x;
        int dy1 = c.y - b.y;
        int dy0 = a.y - b.y;
        int dx1 = c.x - b.x;
        int z = dx0 * dy1 - dy0 * dx1;
        return z > 0;
    }

    public static boolean isIdentical(Polygon2D_I32 a, Polygon2D_I32 b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquivalent(Polygon2D_I32 a, Polygon2D_I32 b) {
        int i;
        if (a.size() != b.size()) {
            return false;
        }
        Point2D_I32 a0 = a.get(0);
        int match = -1;
        for (i = 0; i < b.size(); ++i) {
            if (!a0.equals(b.get(i))) continue;
            match = i;
            break;
        }
        if (match < 0) {
            return false;
        }
        for (i = 1; i < b.size(); ++i) {
            Point2D_I32 bi;
            Point2D_I32 ai = a.get(i);
            if (ai.equals(bi = b.get((match + i) % b.size()))) continue;
            return false;
        }
        return true;
    }
}

