/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.geometry.UtilPlane3D_F32;
import georegression.struct.GeoTuple3D_F32;
import georegression.struct.plane.PlaneNormal3D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.shapes.Box3D_F32;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.Nullable;

public class UtilPoint3D_F32 {
    public static float distance(float x0, float y0, float z0, float x1, float y1, float z1) {
        return UtilPoint3D_F32.norm(x1 - x0, y1 - y0, z1 - z0);
    }

    public static float distanceSq(float x0, float y0, float z0, float x1, float y1, float z1) {
        float dx = x1 - x0;
        float dy = y1 - y0;
        float dz = z1 - z0;
        return dx * dx + dy * dy + dz * dz;
    }

    public static float norm(float x, float y, float z) {
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public static List<Point3D_F32> copy(List<Point3D_F32> pts) {
        ArrayList<Point3D_F32> ret = new ArrayList<Point3D_F32>();
        for (Point3D_F32 p : pts) {
            ret.add(p.copy());
        }
        return ret;
    }

    public static Point3D_F32 noiseNormal(Point3D_F32 mean, float sigmaX, float sigmaY, float sigmaZ, Random rand, @Nullable Point3D_F32 output) {
        if (output == null) {
            output = new Point3D_F32();
        }
        output.x = mean.x + (float)rand.nextGaussian() * sigmaX;
        output.y = mean.y + (float)rand.nextGaussian() * sigmaY;
        output.z = mean.z + (float)rand.nextGaussian() * sigmaZ;
        return output;
    }

    public static void noiseNormal(List<Point3D_F32> pts, float sigma, Random rand) {
        for (Point3D_F32 p : pts) {
            p.x += (float)rand.nextGaussian() * sigma;
            p.y += (float)rand.nextGaussian() * sigma;
            p.z += (float)rand.nextGaussian() * sigma;
        }
    }

    public static List<Point3D_F32> random(PlaneNormal3D_F32 plane, float max, int num, Random rand) {
        ArrayList<Point3D_F32> ret = new ArrayList<Point3D_F32>();
        Vector3D_F32 axisX = new Vector3D_F32();
        Vector3D_F32 axisY = new Vector3D_F32();
        UtilPlane3D_F32.selectAxis2D(plane.n, axisX, axisY);
        for (int i = 0; i < num; ++i) {
            float x = 2.0f * max * (rand.nextFloat() - 0.5f);
            float y = 2.0f * max * (rand.nextFloat() - 0.5f);
            Point3D_F32 p = new Point3D_F32();
            p.x = plane.p.x + axisX.x * x + axisY.x * y;
            p.y = plane.p.y + axisX.y * x + axisY.y * y;
            p.z = plane.p.z + axisX.z * x + axisY.z * y;
            ret.add(p);
        }
        return ret;
    }

    public static List<Point3D_F32> random(float min, float max, int num, Random rand) {
        ArrayList<Point3D_F32> ret = new ArrayList<Point3D_F32>();
        float d = max - min;
        for (int i = 0; i < num; ++i) {
            Point3D_F32 p = new Point3D_F32();
            p.x = rand.nextFloat() * d + min;
            p.y = rand.nextFloat() * d + min;
            p.z = rand.nextFloat() * d + min;
            ret.add(p);
        }
        return ret;
    }

    public static List<Point3D_F32> random(Point3D_F32 mean, float minX, float maxX, float minY, float maxY, float minZ, float maxZ, int num, Random rand) {
        ArrayList<Point3D_F32> ret = new ArrayList<Point3D_F32>();
        for (int i = 0; i < num; ++i) {
            Point3D_F32 p = new Point3D_F32();
            p.x = mean.x + rand.nextFloat() * (maxX - minX) + minX;
            p.y = mean.y + rand.nextFloat() * (maxY - minY) + minY;
            p.z = mean.z + rand.nextFloat() * (maxZ - minZ) + minZ;
            ret.add(p);
        }
        return ret;
    }

    public static List<Point3D_F32> random(Point3D_F32 mean, float min, float max, int num, Random rand) {
        return UtilPoint3D_F32.random(mean, min, max, min, max, min, max, num, rand);
    }

    public static List<Point3D_F32> randomN(Point3D_F32 mean, float stdX, float stdY, float stdZ, int num, Random rand) {
        ArrayList<Point3D_F32> ret = new ArrayList<Point3D_F32>();
        for (int i = 0; i < num; ++i) {
            Point3D_F32 p = new Point3D_F32();
            p.x = mean.x + (float)rand.nextGaussian() * stdX;
            p.y = mean.y + (float)rand.nextGaussian() * stdY;
            p.z = mean.z + (float)rand.nextGaussian() * stdZ;
            ret.add(p);
        }
        return ret;
    }

    public static List<Point3D_F32> randomN(Point3D_F32 mean, float stdev, int num, Random rand) {
        return UtilPoint3D_F32.randomN(mean, stdev, stdev, stdev, num, rand);
    }

    public static Point3D_F32 mean(List<Point3D_F32> points, @Nullable Point3D_F32 mean) {
        if (mean == null) {
            mean = new Point3D_F32();
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (Point3D_F32 p : points) {
            x += p.x;
            y += p.y;
            z += p.z;
        }
        mean.x = x / (float)points.size();
        mean.y = y / (float)points.size();
        mean.z = z / (float)points.size();
        return mean;
    }

    public static Point3D_F32 mean(List<Point3D_F32> points, int num, @Nullable Point3D_F32 mean) {
        if (mean == null) {
            mean = new Point3D_F32();
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (int i = 0; i < num; ++i) {
            Point3D_F32 p = points.get(i);
            x += p.x;
            y += p.y;
            z += p.z;
        }
        mean.x = x / (float)num;
        mean.y = y / (float)num;
        mean.z = z / (float)num;
        return mean;
    }

    public static void boundingBox(List<Point3D_F32> points, Box3D_F32 bounding) {
        float minX = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float minY = Float.MAX_VALUE;
        float maxY = -3.4028235E38f;
        float minZ = Float.MAX_VALUE;
        float maxZ = -3.4028235E38f;
        for (int i = 0; i < points.size(); ++i) {
            Point3D_F32 p = points.get(i);
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (p.y > maxY) {
                maxY = p.y;
            }
            if (p.z < minZ) {
                minZ = p.z;
            }
            if (!(p.z > maxZ)) continue;
            maxZ = p.z;
        }
        bounding.p0.setTo(minX, minY, minZ);
        bounding.p1.setTo(maxX, maxY, maxZ);
    }

    public static int axisLargestAbs(GeoTuple3D_F32<?> p) {
        float x = Math.abs(p.x);
        float y = Math.abs(p.y);
        float z = Math.abs(p.z);
        if (x > y) {
            if (x > z) {
                return 0;
            }
            return 2;
        }
        if (y > z) {
            return 1;
        }
        return 2;
    }
}

