/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.GeoTuple2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.Rectangle2D_F32;
import georegression.struct.shapes.RectangleLength2D_F32;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.sorting.QuickSort_F32;
import org.ejml.data.FMatrix;
import org.ejml.data.ReshapeMatrix;
import org.jetbrains.annotations.Nullable;

public class UtilPoint2D_F32 {
    public static List<Point2D_F32> copy(List<Point2D_F32> pts) {
        ArrayList<Point2D_F32> ret = new ArrayList<Point2D_F32>();
        for (Point2D_F32 p : pts) {
            ret.add(p.copy());
        }
        return ret;
    }

    public static void noiseNormal(List<Point2D_F32> pts, float sigma, Random rand) {
        for (Point2D_F32 p : pts) {
            p.x += (float)rand.nextGaussian() * sigma;
            p.y += (float)rand.nextGaussian() * sigma;
        }
    }

    public static Point2D_F32 noiseNormal(Point2D_F32 mean, float sigmaX, float sigmaY, Random rand, @Nullable Point2D_F32 output) {
        if (output == null) {
            output = new Point2D_F32();
        }
        output.x = mean.x + (float)rand.nextGaussian() * sigmaX;
        output.y = mean.y + (float)rand.nextGaussian() * sigmaY;
        return output;
    }

    public static float distance(float x0, float y0, float x1, float y1) {
        float dx = x1 - x0;
        float dy = y1 - y0;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static float distanceSq(float x0, float y0, float x1, float y1) {
        float dx = x1 - x0;
        float dy = y1 - y0;
        return dx * dx + dy * dy;
    }

    public static Point2D_F32 mean(List<Point2D_F32> list, @Nullable Point2D_F32 mean) {
        if (mean == null) {
            mean = new Point2D_F32();
        }
        float x = 0.0f;
        float y = 0.0f;
        for (Point2D_F32 p : list) {
            x += p.getX();
            y += p.getY();
        }
        mean.setTo(x /= (float)list.size(), y /= (float)list.size());
        return mean;
    }

    public static Point2D_F32 mean(Point2D_F32[] list, int offset, int length, @Nullable Point2D_F32 mean) {
        if (mean == null) {
            mean = new Point2D_F32();
        }
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 0; i < length; ++i) {
            Point2D_F32 p = list[offset + i];
            x += p.getX();
            y += p.getY();
        }
        mean.setTo(x /= (float)length, y /= (float)length);
        return mean;
    }

    public static Point2D_F32 mean(Point2D_F32 a, Point2D_F32 b, @Nullable Point2D_F32 mean) {
        if (mean == null) {
            mean = new Point2D_F32();
        }
        mean.x = (a.x + b.x) / 2.0f;
        mean.y = (a.y + b.y) / 2.0f;
        return mean;
    }

    public static List<Point2D_F32> random(float min, float max, int num, Random rand) {
        ArrayList<Point2D_F32> ret = new ArrayList<Point2D_F32>();
        float d = max - min;
        for (int i = 0; i < num; ++i) {
            Point2D_F32 p = new Point2D_F32();
            p.x = rand.nextFloat() * d + min;
            p.y = rand.nextFloat() * d + min;
            ret.add(p);
        }
        return ret;
    }

    public static boolean isEquals(GeoTuple2D_F32 a, GeoTuple2D_F32 b, float tol) {
        return Math.abs(a.x - b.x) <= tol && Math.abs(a.y - b.y) <= tol;
    }

    public static RectangleLength2D_F32 bounding(List<Point2D_F32> points, @Nullable RectangleLength2D_F32 bounding) {
        if (bounding == null) {
            bounding = new RectangleLength2D_F32();
        }
        float minX = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float minY = Float.MAX_VALUE;
        float maxY = -3.4028235E38f;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F32 p = points.get(i);
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (!(p.y > maxY)) continue;
            maxY = p.y;
        }
        bounding.x0 = minX;
        bounding.y0 = minY;
        bounding.width = maxX - minX;
        bounding.height = maxY - minY;
        bounding.width += Math.max(0.0f, (maxX - (bounding.x0 + bounding.width)) * 10.0f);
        bounding.height += Math.max(0.0f, (maxY - (bounding.y0 + bounding.height)) * 10.0f);
        return bounding;
    }

    public static Rectangle2D_F32 bounding(List<Point2D_F32> points, @Nullable Rectangle2D_F32 bounding) {
        if (bounding == null) {
            bounding = new Rectangle2D_F32();
        }
        float minX = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float minY = Float.MAX_VALUE;
        float maxY = -3.4028235E38f;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F32 p = points.get(i);
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (!(p.y > maxY)) continue;
            maxY = p.y;
        }
        bounding.setTo(minX, minY, maxX, maxY);
        return bounding;
    }

    public static List<Point2D_F32> orderCCW(List<Point2D_F32> points) {
        Point2D_F32 center = UtilPoint2D_F32.mean(points, null);
        float[] angles = new float[points.size()];
        for (int i = 0; i < angles.length; ++i) {
            Point2D_F32 p = points.get(i);
            float dx = p.x - center.x;
            float dy = p.y - center.y;
            angles[i] = (float)Math.atan2(dy, dx);
        }
        int[] order = new int[points.size()];
        QuickSort_F32 sorter = new QuickSort_F32();
        sorter.sort(angles, 0, points.size(), order);
        ArrayList<Point2D_F32> out = new ArrayList<Point2D_F32>(points.size());
        for (int i = 0; i < points.size(); ++i) {
            out.add(points.get(order[i]));
        }
        return out;
    }

    public static void computeNormal(List<Point2D_F32> points, Point2D_F32 mean, FMatrix covariance) {
        if (covariance.getNumCols() != 2 || covariance.getNumRows() != 2) {
            if (covariance instanceof ReshapeMatrix) {
                ((ReshapeMatrix)((Object)covariance)).reshape(2, 2);
            } else {
                throw new IllegalArgumentException("Must be a 2x2 matrix");
            }
        }
        UtilPoint2D_F32.mean(points, mean);
        float xx = 0.0f;
        float xy = 0.0f;
        float yy = 0.0f;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F32 p = points.get(i);
            float dx = p.x - mean.x;
            float dy = p.y - mean.y;
            xx += dx * dx;
            xy += dx * dy;
            yy += dy * dy;
        }
        covariance.unsafe_set(0, 0, xx /= (float)points.size());
        covariance.unsafe_set(0, 1, xy /= (float)points.size());
        covariance.unsafe_set(1, 0, xy);
        covariance.unsafe_set(1, 1, yy /= (float)points.size());
    }

    public static List<Point2D_F32> randomNorm(Point2D_F32 mean, FMatrix covariance, int count, Random rand, @Nullable List<Point2D_F32> output) {
        if (output == null) {
            output = new ArrayList<Point2D_F32>();
        }
        float cxx = covariance.get(0, 0);
        float cxy = covariance.get(0, 1);
        float cyy = covariance.get(1, 1);
        float sxx = (float)Math.sqrt(cxx);
        float sxy = cxy / cxx;
        float syy = (float)Math.sqrt(cyy - sxy * sxy);
        for (int i = 0; i < count; ++i) {
            Point2D_F32 p = new Point2D_F32();
            float x = (float)rand.nextGaussian();
            float y = (float)rand.nextGaussian();
            p.x = mean.x + sxx * x + sxy * y;
            p.y = mean.y + sxy * x + syy * y;
            output.add(p);
        }
        return output;
    }
}

