/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.line.LineParametric3D_F64;
import georegression.struct.line.LineSegment3D_F64;
import georegression.struct.point.Point3D_F64;
import org.jetbrains.annotations.Nullable;

public class UtilLine3D_F64 {
    public static LineParametric3D_F64 convert(LineSegment3D_F64 line, @Nullable LineParametric3D_F64 output) {
        if (output == null) {
            output = new LineParametric3D_F64();
        }
        output.p.setTo(line.a);
        output.slope.x = line.b.x - line.a.x;
        output.slope.y = line.b.y - line.a.y;
        output.slope.z = line.b.z - line.a.z;
        return output;
    }

    public static double computeT(LineParametric3D_F64 line, Point3D_F64 pointOnLine) {
        double dx = pointOnLine.x - line.p.x;
        double dy = pointOnLine.y - line.p.y;
        double dz = pointOnLine.z - line.p.z;
        double adx = Math.abs(dx);
        double ady = Math.abs(dy);
        double adz = Math.abs(dz);
        double t = adx > ady ? (adx > adz ? dx / line.slope.x : dz / line.slope.z) : (ady > adz ? dy / line.slope.y : dz / line.slope.z);
        return t;
    }
}

