/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.geometry.curves.TangentLinesTwoEllipses_F32;
import georegression.misc.GrlConstants;
import georegression.struct.curve.EllipseQuadratic_F32;
import georegression.struct.curve.EllipseRotated_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Vector2D_F32;
import org.jetbrains.annotations.Nullable;

public class UtilEllipse_F32 {
    public static EllipseRotated_F32 convert(EllipseQuadratic_F32 input, @Nullable EllipseRotated_F32 output) {
        float dy;
        float dx;
        if (output == null) {
            output = new EllipseRotated_F32();
        }
        float a11 = input.A;
        float a12 = input.B;
        float a22 = input.C;
        float b1 = 2.0f * input.D;
        float b2 = 2.0f * input.E;
        float c = input.F;
        output.center.x = (a22 * b1 - a12 * b2) / (2.0f * (a12 * a12 - a11 * a22));
        output.center.y = (a11 * b2 - a12 * b1) / (2.0f * (a12 * a12 - a11 * a22));
        float k1 = output.center.x;
        float k2 = output.center.y;
        float mu = 1.0f / (a11 * k1 * k1 + 2.0f * a12 * k1 * k2 + a22 * k2 * k2 - c);
        float m11 = mu * a11;
        float m12 = mu * a12;
        float m22 = mu * a22;
        float inner = (float)Math.sqrt((m11 - m22) * (m11 - m22) + 4.0f * m12 * m12);
        float l1 = (m11 + m22 + inner) / 2.0f;
        float l2 = (m11 + m22 - inner) / 2.0f;
        output.b = 1.0f / (float)Math.sqrt(l1);
        output.a = 1.0f / (float)Math.sqrt(l2);
        if (m11 >= m22) {
            dx = l1 - m22;
            dy = m12;
        } else {
            dx = m12;
            dy = l1 - m11;
        }
        output.phi = (float)Math.atan2(-dx, dy);
        if (output.phi < -GrlConstants.F_PId2) {
            output.phi += (float)Math.PI;
        } else if (output.phi > GrlConstants.F_PId2) {
            output.phi -= (float)Math.PI;
        }
        return output;
    }

    public static EllipseQuadratic_F32 convert(EllipseRotated_F32 input, @Nullable EllipseQuadratic_F32 output) {
        if (output == null) {
            output = new EllipseQuadratic_F32();
        }
        float x0 = input.center.x;
        float y0 = input.center.y;
        float a = input.a;
        float b = input.b;
        float phi = input.phi;
        float cphi = (float)Math.cos(phi);
        float sphi = (float)Math.sin(phi);
        float cphi2 = cphi * cphi;
        float sphi2 = sphi * sphi;
        float a2 = a * a;
        float b2 = b * b;
        float x02 = x0 * x0;
        float y02 = y0 * y0;
        output.A = cphi2 / a2 + sphi2 / b2;
        output.B = sphi * cphi / a2 - sphi * cphi / b2;
        output.C = sphi2 / a2 + cphi2 / b2;
        output.D = -x0 * cphi2 / a2 - y0 * sphi * cphi / a2 - x0 * sphi2 / b2 + y0 * sphi * cphi / b2;
        output.E = -x0 * sphi * cphi / a2 - y0 * sphi2 / a2 + x0 * sphi * cphi / b2 - y0 * cphi2 / b2;
        output.F = x02 * cphi2 / a2 + 2.0f * x0 * y0 * sphi * cphi / a2 + y02 * sphi2 / a2 + x02 * sphi2 / b2 - 2.0f * x0 * y0 * sphi * cphi / b2 + y02 * cphi2 / b2 - 1.0f;
        return output;
    }

    public static float evaluate(float x, float y, EllipseQuadratic_F32 ellipse) {
        return ellipse.A * x * x + 2.0f * ellipse.B * x * y + ellipse.C * y * y + 2.0f * ellipse.D * x + 2.0f * ellipse.E * y + ellipse.F;
    }

    public static float evaluate(float x, float y, EllipseRotated_F32 ellipse) {
        float cphi = (float)Math.cos(ellipse.phi);
        float sphi = (float)Math.sin(ellipse.phi);
        float left = (x -= ellipse.center.x) * cphi + (y -= ellipse.center.y) * sphi;
        float right = -x * sphi + y * cphi;
        float ll = left / ellipse.a;
        float rr = right / ellipse.b;
        return ll * ll + rr * rr;
    }

    public static Point2D_F32 computePoint(float t, EllipseRotated_F32 ellipse, @Nullable Point2D_F32 output) {
        if (output == null) {
            output = new Point2D_F32();
        }
        float ct = (float)Math.cos(t);
        float st = (float)Math.sin(t);
        float cphi = (float)Math.cos(ellipse.phi);
        float sphi = (float)Math.sin(ellipse.phi);
        float x = ellipse.a * ct;
        float y = ellipse.b * st;
        output.x = ellipse.center.x + x * cphi - y * sphi;
        output.y = ellipse.center.y + x * sphi + y * cphi;
        return output;
    }

    public static float computeAngle(Point2D_F32 p, EllipseRotated_F32 ellipse) {
        float ce = (float)Math.cos(ellipse.phi);
        float se = (float)Math.sin(ellipse.phi);
        float xc = p.x - ellipse.center.x;
        float yc = p.y - ellipse.center.y;
        float x = ce * xc + se * yc;
        float y = -se * xc + ce * yc;
        return (float)Math.atan2(y / ellipse.b, x / ellipse.a);
    }

    public static Vector2D_F32 computeTangent(float t, EllipseRotated_F32 ellipse, @Nullable Vector2D_F32 output) {
        if (output == null) {
            output = new Vector2D_F32();
        }
        float ct = (float)Math.cos(t);
        float st = (float)Math.sin(t);
        float cphi = (float)Math.cos(ellipse.phi);
        float sphi = (float)Math.sin(ellipse.phi);
        float x = ellipse.a * ct * ellipse.b * ellipse.b;
        float y = ellipse.b * st * ellipse.a * ellipse.a;
        float rx = x * cphi - y * sphi;
        float ry = x * sphi + y * cphi;
        float r = (float)Math.sqrt(rx * rx + ry * ry);
        output.x = -ry / r;
        output.y = rx / r;
        return output;
    }

    public static boolean tangentLines(Point2D_F32 pt, EllipseRotated_F32 ellipse, Point2D_F32 tangentA, Point2D_F32 tangentB) {
        float y1;
        float y0;
        float x1;
        float x0;
        float cphi = (float)Math.cos(ellipse.phi);
        float sphi = (float)Math.sin(ellipse.phi);
        float tmpx = pt.x - ellipse.center.x;
        float tmpy = pt.y - ellipse.center.y;
        float xt = tmpx * cphi + tmpy * sphi;
        float yt = -tmpx * sphi + tmpy * cphi;
        float a2 = ellipse.a * ellipse.a;
        float b2 = ellipse.b * ellipse.b;
        float aa0 = yt * yt / b2 + xt * xt / a2;
        float bb0 = -2.0f * xt;
        float cc0 = a2 * (1.0f - yt * yt / b2);
        float descriminant0 = bb0 * bb0 - 4.0f * aa0 * cc0;
        float aa1 = xt * xt / a2 + yt * yt / b2;
        float bb1 = -2.0f * yt;
        float cc1 = b2 * (1.0f - xt * xt / a2);
        float descriminant1 = bb1 * bb1 - 4.0f * aa1 * cc1;
        if (descriminant0 < 0.0f && descriminant1 < 0.0f) {
            return false;
        }
        if (descriminant0 > descriminant1) {
            if (yt == 0.0f) {
                return false;
            }
            float right = (float)Math.sqrt(descriminant0);
            x0 = (-bb0 + right) / (2.0f * aa0);
            x1 = (-bb0 - right) / (2.0f * aa0);
            y0 = b2 / yt - xt * x0 * b2 / (yt * a2);
            y1 = b2 / yt - xt * x1 * b2 / (yt * a2);
        } else {
            if (xt == 0.0f) {
                return false;
            }
            float right = (float)Math.sqrt(descriminant1);
            y0 = (-bb1 + right) / (2.0f * aa1);
            y1 = (-bb1 - right) / (2.0f * aa1);
            x0 = a2 / xt - yt * y0 * a2 / (xt * b2);
            x1 = a2 / xt - yt * y1 * a2 / (xt * b2);
        }
        tangentA.x = x0 * cphi - y0 * sphi + ellipse.center.x;
        tangentA.y = x0 * sphi + y0 * cphi + ellipse.center.y;
        tangentB.x = x1 * cphi - y1 * sphi + ellipse.center.x;
        tangentB.y = x1 * sphi + y1 * cphi + ellipse.center.y;
        return true;
    }

    public static boolean tangentLines(EllipseRotated_F32 ellipseA, EllipseRotated_F32 ellipseB, Point2D_F32 tangentA0, Point2D_F32 tangentA1, Point2D_F32 tangentA2, Point2D_F32 tangentA3, Point2D_F32 tangentB0, Point2D_F32 tangentB1, Point2D_F32 tangentB2, Point2D_F32 tangentB3) {
        TangentLinesTwoEllipses_F32 alg = new TangentLinesTwoEllipses_F32(GrlConstants.TEST_F32, 10);
        return alg.process(ellipseA, ellipseB, tangentA0, tangentA1, tangentA2, tangentA3, tangentB0, tangentB1, tangentB2, tangentB3);
    }
}

