/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.misc.GrlConstants;
import georegression.struct.EulerType;
import georegression.struct.so.Quaternion_F64;
import georegression.struct.so.Rodrigues_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.jetbrains.annotations.Nullable;

public class ConvertRotation3D_F64 {
    public static DMatrixRMaj rodriguesToMatrix(Rodrigues_F64 rodrigues, @Nullable DMatrixRMaj R) {
        return ConvertRotation3D_F64.rodriguesToMatrix(rodrigues.unitAxisRotation.x, rodrigues.unitAxisRotation.y, rodrigues.unitAxisRotation.z, rodrigues.theta, R);
    }

    public static DMatrixRMaj rodriguesToMatrix(double axisX, double axisY, double axisZ, double theta, @Nullable DMatrixRMaj R) {
        R = ConvertRotation3D_F64.checkDeclare3x3(R);
        double x = axisX;
        double y = axisY;
        double z = axisZ;
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        double oc = 1.0 - c;
        R.data[0] = c + x * x * oc;
        R.data[1] = x * y * oc - z * s;
        R.data[2] = x * z * oc + y * s;
        R.data[3] = y * x * oc + z * s;
        R.data[4] = c + y * y * oc;
        R.data[5] = y * z * oc - x * s;
        R.data[6] = z * x * oc - y * s;
        R.data[7] = z * y * oc + x * s;
        R.data[8] = c + z * z * oc;
        return R;
    }

    public static double[] rodriguesToEuler(Rodrigues_F64 rodrigues, EulerType type, @Nullable double[] euler) {
        DMatrixRMaj R = ConvertRotation3D_F64.rodriguesToMatrix(rodrigues, null);
        return ConvertRotation3D_F64.matrixToEuler(R, type, euler);
    }

    public static Quaternion_F64 rodriguesToQuaternion(Rodrigues_F64 rodrigues, @Nullable Quaternion_F64 quat) {
        if (quat == null) {
            quat = new Quaternion_F64();
        }
        quat.w = Math.cos(rodrigues.theta / 2.0);
        double s = Math.sin(rodrigues.theta / 2.0);
        quat.x = rodrigues.unitAxisRotation.x * s;
        quat.y = rodrigues.unitAxisRotation.y * s;
        quat.z = rodrigues.unitAxisRotation.z * s;
        return quat;
    }

    public static Rodrigues_F64 quaternionToRodrigues(Quaternion_F64 quat, @Nullable Rodrigues_F64 rodrigues) {
        if (rodrigues == null) {
            rodrigues = new Rodrigues_F64();
        }
        rodrigues.unitAxisRotation.setTo(quat.x, quat.y, quat.z);
        rodrigues.unitAxisRotation.normalize();
        rodrigues.theta = 2.0 * Math.acos(quat.w);
        return rodrigues;
    }

    public static double[] quaternionToEuler(Quaternion_F64 q, EulerType type, @Nullable double[] euler) {
        DMatrixRMaj R = ConvertRotation3D_F64.quaternionToMatrix(q, null);
        return ConvertRotation3D_F64.matrixToEuler(R, type, euler);
    }

    public static double[] matrixToEuler(DMatrixRMaj R, EulerType type, @Nullable double[] euler) {
        if (euler == null) {
            euler = new double[3];
        }
        switch (type) {
            case ZYX: {
                ConvertRotation3D_F64.TanSinTan(-2, 1, 3, -6, 9, 5, -7, 4, 8, R, euler);
                break;
            }
            case ZYZ: {
                ConvertRotation3D_F64.TanCosTan(8, -7, 9, 6, 3, 5, -7, 4, 8, R, euler);
                break;
            }
            case ZXY: {
                ConvertRotation3D_F64.TanSinTan(4, 5, -6, 3, 9, 1, 8, -2, 7, R, euler);
                break;
            }
            case ZXZ: {
                ConvertRotation3D_F64.TanCosTan(7, 8, 9, 3, -6, 1, 8, -2, 7, R, euler);
                break;
            }
            case YXZ: {
                ConvertRotation3D_F64.TanSinTan(-7, 9, 8, -2, 5, 1, -6, 3, 4, R, euler);
                break;
            }
            case YXY: {
                ConvertRotation3D_F64.TanCosTan(4, -6, 5, 2, 8, 1, -6, 3, 4, R, euler);
                break;
            }
            case YZX: {
                ConvertRotation3D_F64.TanSinTan(3, 1, -2, 8, 5, 9, 4, -7, 6, R, euler);
                break;
            }
            case YZY: {
                ConvertRotation3D_F64.TanCosTan(6, 4, 5, 8, -2, 9, 4, -7, 6, R, euler);
                break;
            }
            case XYZ: {
                ConvertRotation3D_F64.TanSinTan(8, 9, -7, 4, 1, 5, 3, -6, 2, R, euler);
                break;
            }
            case XYX: {
                ConvertRotation3D_F64.TanCosTan(2, 3, 1, 4, -7, 5, 3, -6, 2, R, euler);
                break;
            }
            case XZY: {
                ConvertRotation3D_F64.TanSinTan(-6, 5, 4, -7, 1, 9, -2, 8, 3, R, euler);
                break;
            }
            case XZX: {
                ConvertRotation3D_F64.TanCosTan(3, -2, 1, 7, 4, 9, -2, 8, 3, R, euler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown rotation sequence");
            }
        }
        return euler;
    }

    private static void TanSinTan(int y0, int x0, int sin1, int y2, int x2, int cos0a, int cos0b, int sin0a, int sin0b, DMatrixRMaj R, double[] euler) {
        double val_y0 = ConvertRotation3D_F64.get(R, y0);
        double val_x0 = ConvertRotation3D_F64.get(R, x0);
        double val_sin1 = ConvertRotation3D_F64.get(R, sin1);
        double val_y2 = ConvertRotation3D_F64.get(R, y2);
        double val_x2 = ConvertRotation3D_F64.get(R, x2);
        if (1.0 - Math.abs(val_sin1) <= GrlConstants.EPS) {
            double sign = Math.signum(val_sin1);
            double sin0 = (ConvertRotation3D_F64.get(R, sin0a) + sign * ConvertRotation3D_F64.get(R, sin0b)) / 2.0;
            double cos0 = (ConvertRotation3D_F64.get(R, cos0a) + sign * ConvertRotation3D_F64.get(R, cos0b)) / 2.0;
            euler[0] = Math.atan2(sin0, cos0);
            euler[1] = sign * Math.PI / 2.0;
            euler[2] = 0.0;
        } else {
            euler[0] = Math.atan2(val_y0, val_x0);
            euler[1] = Math.asin(val_sin1);
            euler[2] = Math.atan2(val_y2, val_x2);
        }
    }

    private static void TanCosTan(int y0, int x0, int cos1, int y2, int x2, int cos0a, int cos0b, int sin0a, int sin0b, DMatrixRMaj R, double[] euler) {
        double val_y0 = ConvertRotation3D_F64.get(R, y0);
        double val_x0 = ConvertRotation3D_F64.get(R, x0);
        double val_cos1 = ConvertRotation3D_F64.get(R, cos1);
        double val_y2 = ConvertRotation3D_F64.get(R, y2);
        double val_x2 = ConvertRotation3D_F64.get(R, x2);
        if (1.0 - Math.abs(val_cos1) <= GrlConstants.EPS) {
            double sin0 = (ConvertRotation3D_F64.get(R, sin0a) + ConvertRotation3D_F64.get(R, sin0b)) / 2.0;
            double cos0 = (ConvertRotation3D_F64.get(R, cos0a) + ConvertRotation3D_F64.get(R, cos0b)) / 2.0;
            euler[0] = Math.atan2(sin0, cos0);
            euler[1] = 0.0;
            euler[2] = 0.0;
        } else {
            euler[0] = Math.atan2(val_y0, val_x0);
            euler[1] = Math.acos(val_cos1);
            euler[2] = Math.atan2(val_y2, val_x2);
        }
    }

    private static double get(DMatrixRMaj M, int index) {
        if (index < 0) {
            return -M.data[-index - 1];
        }
        return M.data[index - 1];
    }

    public static Quaternion_F64 matrixToQuaternion(DMatrixRMaj R, @Nullable Quaternion_F64 quat) {
        if (quat == null) {
            quat = new Quaternion_F64();
        }
        double m00 = R.unsafe_get(0, 0);
        double m01 = R.unsafe_get(0, 1);
        double m02 = R.unsafe_get(0, 2);
        double m10 = R.unsafe_get(1, 0);
        double m11 = R.unsafe_get(1, 1);
        double m12 = R.unsafe_get(1, 2);
        double m20 = R.unsafe_get(2, 0);
        double m21 = R.unsafe_get(2, 1);
        double m22 = R.unsafe_get(2, 2);
        double trace = m00 + m11 + m22;
        if (trace > 0.0) {
            double S = Math.sqrt(trace + 1.0) * 2.0;
            quat.w = 0.25 * S;
            quat.x = (m21 - m12) / S;
            quat.y = (m02 - m20) / S;
            quat.z = (m10 - m01) / S;
        } else if (m00 > m11 && m00 > m22) {
            double S = Math.sqrt(1.0 + m00 - m11 - m22) * 2.0;
            quat.w = (m21 - m12) / S;
            quat.x = 0.25 * S;
            quat.y = (m01 + m10) / S;
            quat.z = (m02 + m20) / S;
        } else if (m11 > m22) {
            double S = Math.sqrt(1.0 + m11 - m00 - m22) * 2.0;
            quat.w = (m02 - m20) / S;
            quat.x = (m01 + m10) / S;
            quat.y = 0.25 * S;
            quat.z = (m12 + m21) / S;
        } else {
            double S = Math.sqrt(1.0 + m22 - m00 - m11) * 2.0;
            quat.w = (m10 - m01) / S;
            quat.x = (m02 + m20) / S;
            quat.y = (m12 + m21) / S;
            quat.z = 0.25 * S;
        }
        return quat;
    }

    public static Rodrigues_F64 matrixToRodrigues(DMatrixRMaj R, @Nullable Rodrigues_F64 rodrigues) {
        double diagSum;
        double absDiagSum;
        if (rodrigues == null) {
            rodrigues = new Rodrigues_F64();
        }
        if ((absDiagSum = Math.abs(diagSum = (R.unsafe_get(0, 0) + R.unsafe_get(1, 1) + R.unsafe_get(2, 2) - 1.0) / 2.0)) <= 1.0 && 1.0 - absDiagSum > 10.0 * GrlConstants.EPS) {
            rodrigues.theta = Math.acos(diagSum);
            double bottom = 2.0 * Math.sin(rodrigues.theta);
            rodrigues.unitAxisRotation.x = (R.unsafe_get(2, 1) - R.unsafe_get(1, 2)) / bottom;
            rodrigues.unitAxisRotation.y = (R.unsafe_get(0, 2) - R.unsafe_get(2, 0)) / bottom;
            rodrigues.unitAxisRotation.z = (R.unsafe_get(1, 0) - R.unsafe_get(0, 1)) / bottom;
            rodrigues.unitAxisRotation.normalize();
        } else {
            rodrigues.theta = diagSum >= 1.0 ? 0.0 : (diagSum <= -1.0 ? Math.PI : Math.acos(diagSum));
            rodrigues.unitAxisRotation.x = Math.sqrt((R.get(0, 0) + 1.0) / 2.0);
            rodrigues.unitAxisRotation.y = Math.sqrt((R.get(1, 1) + 1.0) / 2.0);
            rodrigues.unitAxisRotation.z = Math.sqrt((R.get(2, 2) + 1.0) / 2.0);
            double x = rodrigues.unitAxisRotation.x;
            double y = rodrigues.unitAxisRotation.y;
            double z = rodrigues.unitAxisRotation.z;
            if (Math.abs(R.get(1, 0) - 2.0 * x * y) > GrlConstants.EPS) {
                x *= -1.0;
            }
            if (Math.abs(R.get(2, 0) - 2.0 * x * z) > GrlConstants.EPS) {
                z *= -1.0;
            }
            if (Math.abs(R.get(2, 1) - 2.0 * z * y) > GrlConstants.EPS) {
                y *= -1.0;
                x *= -1.0;
            }
            rodrigues.unitAxisRotation.x = x;
            rodrigues.unitAxisRotation.y = y;
            rodrigues.unitAxisRotation.z = z;
        }
        return rodrigues;
    }

    public static DMatrixRMaj rotX(double ang, @Nullable DMatrixRMaj R) {
        if (R == null) {
            R = new DMatrixRMaj(3, 3);
        }
        ConvertRotation3D_F64.setRotX(ang, R);
        return R;
    }

    public static void setRotX(double ang, DMatrixRMaj R) {
        double c = Math.cos(ang);
        double s = Math.sin(ang);
        R.set(0, 0, 1.0);
        R.set(1, 1, c);
        R.set(1, 2, -s);
        R.set(2, 1, s);
        R.set(2, 2, c);
    }

    public static DMatrixRMaj rotY(double ang, @Nullable DMatrixRMaj R) {
        R = ConvertRotation3D_F64.checkDeclare3x3(R);
        ConvertRotation3D_F64.setRotY(ang, R);
        return R;
    }

    public static void setRotY(double ang, DMatrixRMaj r) {
        double c = Math.cos(ang);
        double s = Math.sin(ang);
        r.set(0, 0, c);
        r.set(0, 2, s);
        r.set(1, 1, 1.0);
        r.set(2, 0, -s);
        r.set(2, 2, c);
    }

    public static DMatrixRMaj rotZ(double ang, @Nullable DMatrixRMaj R) {
        R = ConvertRotation3D_F64.checkDeclare3x3(R);
        ConvertRotation3D_F64.setRotZ(ang, R);
        return R;
    }

    public static void setRotZ(double ang, DMatrixRMaj r) {
        double c = Math.cos(ang);
        double s = Math.sin(ang);
        r.set(0, 0, c);
        r.set(0, 1, -s);
        r.set(1, 0, s);
        r.set(1, 1, c);
        r.set(2, 2, 1.0);
    }

    public static DMatrixRMaj eulerToMatrix(EulerType type, double rotA, double rotB, double rotC, @Nullable DMatrixRMaj R) {
        R = ConvertRotation3D_F64.checkDeclare3x3(R);
        DMatrixRMaj R_a = ConvertRotation3D_F64.rotationAboutAxis(type.getAxisA(), rotA, null);
        DMatrixRMaj R_b = ConvertRotation3D_F64.rotationAboutAxis(type.getAxisB(), rotB, null);
        DMatrixRMaj R_c = ConvertRotation3D_F64.rotationAboutAxis(type.getAxisC(), rotC, null);
        DMatrixRMaj A2 = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult(R_b, R_a, A2);
        CommonOps_DDRM.mult(R_c, A2, R);
        return R;
    }

    public static Quaternion_F64 eulerToQuaternion(EulerType type, double rotA, double rotB, double rotC, @Nullable Quaternion_F64 q) {
        if (q == null) {
            q = new Quaternion_F64();
        }
        double ca = Math.cos(rotA * 0.5);
        double sa = Math.sin(rotA * 0.5);
        double cb = Math.cos(rotB * 0.5);
        double sb = Math.sin(rotB * 0.5);
        double cc = Math.cos(rotC * 0.5);
        double sc = Math.sin(rotC * 0.5);
        double w = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        switch (type) {
            case ZYX: {
                w = ca * cb * cc - sa * sb * sc;
                x = cc * sa * sb + ca * cb * sc;
                y = ca * cc * sb - cb * sa * sc;
                z = cb * cc * sa + ca * sb * sc;
                break;
            }
            case ZYZ: {
                w = ca * cb * cc - cb * sa * sc;
                x = cc * sa * sb - ca * sb * sc;
                y = ca * cc * sb + sa * sb * sc;
                z = cb * cc * sa + ca * cb * sc;
                break;
            }
            case ZXY: {
                w = ca * cb * cc + sa * sb * sc;
                x = ca * cc * sb + cb * sa * sc;
                y = -cc * sa * sb + ca * cb * sc;
                z = cb * cc * sa - ca * sb * sc;
                break;
            }
            case ZXZ: {
                w = ca * cb * cc - cb * sa * sc;
                x = ca * cc * sb + sa * sb * sc;
                y = -cc * sa * sb + ca * sb * sc;
                z = cb * cc * sa + ca * cb * sc;
                break;
            }
            case YXZ: {
                w = ca * cb * cc - sa * sb * sc;
                x = ca * cc * sb - cb * sa * sc;
                y = cb * cc * sa + ca * sb * sc;
                z = cc * sa * sb + ca * cb * sc;
                break;
            }
            case YXY: {
                w = ca * cb * cc - cb * sa * sc;
                x = ca * cc * sb + sa * sb * sc;
                y = cb * cc * sa + ca * cb * sc;
                z = cc * sa * sb - ca * sb * sc;
                break;
            }
            case YZX: {
                w = ca * cb * cc + sa * sb * sc;
                x = -cc * sa * sb + ca * cb * sc;
                y = cb * cc * sa - ca * sb * sc;
                z = ca * cc * sb + cb * sa * sc;
                break;
            }
            case YZY: {
                w = ca * cb * cc - cb * sa * sc;
                x = -cc * sa * sb + ca * sb * sc;
                y = cb * cc * sa + ca * cb * sc;
                z = ca * cc * sb + sa * sb * sc;
                break;
            }
            case XYZ: {
                w = ca * cb * cc + sa * sb * sc;
                x = cb * cc * sa - ca * sb * sc;
                y = ca * cc * sb + cb * sa * sc;
                z = -cc * sa * sb + ca * cb * sc;
                break;
            }
            case XYX: {
                w = ca * cb * cc - cb * sa * sc;
                x = cb * cc * sa + ca * cb * sc;
                y = ca * cc * sb + sa * sb * sc;
                z = -cc * sa * sb + ca * sb * sc;
                break;
            }
            case XZY: {
                w = ca * cb * cc - sa * sb * sc;
                x = cb * cc * sa + ca * sb * sc;
                y = cc * sa * sb + ca * cb * sc;
                z = ca * cc * sb - cb * sa * sc;
                break;
            }
            case XZX: {
                w = ca * cb * cc - cb * sa * sc;
                x = cb * cc * sa + ca * cb * sc;
                y = cc * sa * sb - ca * sb * sc;
                z = ca * cc * sb + sa * sb * sc;
            }
        }
        q.setTo(w, x, y, z);
        return q;
    }

    private static DMatrixRMaj rotationAboutAxis(int axis, double angle, @Nullable DMatrixRMaj R) {
        switch (axis) {
            case 0: {
                return ConvertRotation3D_F64.rotX(angle, R);
            }
            case 1: {
                return ConvertRotation3D_F64.rotY(angle, R);
            }
            case 2: {
                return ConvertRotation3D_F64.rotZ(angle, R);
            }
        }
        throw new IllegalArgumentException("Unknown which");
    }

    public static DMatrixRMaj approximateRotationMatrix(DMatrixRMaj orig, @Nullable DMatrixRMaj R) {
        R = ConvertRotation3D_F64.checkDeclare3x3(R);
        SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(orig.numRows, orig.numCols, true, true, false);
        if (!svd.decompose(orig)) {
            throw new RuntimeException("SVD Failed");
        }
        CommonOps_DDRM.mult(svd.getU(null, false), svd.getV(null, true), R);
        double det = CommonOps_DDRM.det(R);
        if (det < 0.0) {
            CommonOps_DDRM.scale(-1.0, R);
        }
        return R;
    }

    public static DMatrixRMaj quaternionToMatrix(Quaternion_F64 quat, @Nullable DMatrixRMaj R) {
        return ConvertRotation3D_F64.quaternionToMatrix(quat.w, quat.x, quat.y, quat.z, R);
    }

    public static DMatrixRMaj quaternionToMatrix(double w, double x, double y, double z, @Nullable DMatrixRMaj R) {
        R = ConvertRotation3D_F64.checkDeclare3x3(R);
        double q0 = w;
        double q1 = x;
        double q2 = y;
        double q3 = z;
        R.data[0] = q0 * q0 + q1 * q1 - q2 * q2 - q3 * q3;
        R.data[1] = 2.0 * (q1 * q2 - q0 * q3);
        R.data[2] = 2.0 * (q1 * q3 + q0 * q2);
        R.data[3] = 2.0 * (q1 * q2 + q0 * q3);
        R.data[4] = q0 * q0 - q1 * q1 + q2 * q2 - q3 * q3;
        R.data[5] = 2.0 * (q2 * q3 - q0 * q1);
        R.data[6] = 2.0 * (q1 * q3 - q0 * q2);
        R.data[7] = 2.0 * (q2 * q3 + q0 * q1);
        R.data[8] = q0 * q0 - q1 * q1 - q2 * q2 + q3 * q3;
        return R;
    }

    private static DMatrixRMaj checkDeclare3x3(@Nullable DMatrixRMaj R) {
        if (R == null) {
            return new DMatrixRMaj(3, 3);
        }
        R.reshape(3, 3);
        return R;
    }
}

