/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.polygon;

import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Rectangle2D_I32;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FitPolygon2D_I32 {
    public static Rectangle2D_I32 rectangleAabb(List<Point2D_I32> points, @Nullable Rectangle2D_I32 rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle2D_I32();
        }
        if (points.isEmpty()) {
            rectangle.setTo(0, 0, 0, 0);
            return rectangle;
        }
        Point2D_I32 p0 = points.get(0);
        int x0 = p0.x;
        int x1 = p0.x;
        int y0 = p0.y;
        int y1 = p0.y;
        for (int i = 1; i < points.size(); ++i) {
            Point2D_I32 p = points.get(i);
            if (p.x < x0) {
                x0 = p.x;
            } else if (p.x > x1) {
                x1 = p.x;
            }
            if (p.y < y0) {
                y0 = p.y;
                continue;
            }
            if (p.y <= y1) continue;
            y1 = p.y;
        }
        rectangle.setTo(x0, y0, x1 + 1, y1 + 1);
        return rectangle;
    }
}

