/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.polygon;

import georegression.fitting.polygon.ConvexHullAndrewMonotone_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Rectangle2D_F64;
import java.util.List;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class FitPolygon2D_F64 {
    public static Rectangle2D_F64 rectangleAabb(List<Point2D_F64> points, @Nullable Rectangle2D_F64 rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle2D_F64();
        }
        if (points.isEmpty()) {
            rectangle.setTo(0.0, 0.0, 0.0, 0.0);
            return rectangle;
        }
        Point2D_F64 p0 = points.get(0);
        double x0 = p0.x;
        double x1 = p0.x;
        double y0 = p0.y;
        double y1 = p0.y;
        for (int i = 1; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            if (p.x < x0) {
                x0 = p.x;
            } else if (p.x > x1) {
                x1 = p.x;
            }
            if (p.y < y0) {
                y0 = p.y;
                continue;
            }
            if (!(p.y > y1)) continue;
            y1 = p.y;
        }
        rectangle.setTo(x0, y0, x1, y1);
        return rectangle;
    }

    public static Polygon2D_F64 convexHull(List<Point2D_F64> points, @Nullable Polygon2D_F64 output) {
        if (output == null) {
            output = new Polygon2D_F64();
        }
        FastArray<Point2D_F64> array = new FastArray<Point2D_F64>(Point2D_F64.class);
        array.addAll(points);
        ConvexHullAndrewMonotone_F64 fitter = new ConvexHullAndrewMonotone_F64();
        fitter.process(array, output);
        return output;
    }
}

