/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.polygon;

import georegression.fitting.polygon.ConvexHullAndrewMonotone_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.Polygon2D_F32;
import georegression.struct.shapes.Rectangle2D_F32;
import java.util.List;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class FitPolygon2D_F32 {
    public static Rectangle2D_F32 rectangleAabb(List<Point2D_F32> points, @Nullable Rectangle2D_F32 rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle2D_F32();
        }
        if (points.isEmpty()) {
            rectangle.setTo(0.0f, 0.0f, 0.0f, 0.0f);
            return rectangle;
        }
        Point2D_F32 p0 = points.get(0);
        float x0 = p0.x;
        float x1 = p0.x;
        float y0 = p0.y;
        float y1 = p0.y;
        for (int i = 1; i < points.size(); ++i) {
            Point2D_F32 p = points.get(i);
            if (p.x < x0) {
                x0 = p.x;
            } else if (p.x > x1) {
                x1 = p.x;
            }
            if (p.y < y0) {
                y0 = p.y;
                continue;
            }
            if (!(p.y > y1)) continue;
            y1 = p.y;
        }
        rectangle.setTo(x0, y0, x1, y1);
        return rectangle;
    }

    public static Polygon2D_F32 convexHull(List<Point2D_F32> points, @Nullable Polygon2D_F32 output) {
        if (output == null) {
            output = new Polygon2D_F32();
        }
        FastArray<Point2D_F32> array = new FastArray<Point2D_F32>(Point2D_F32.class);
        array.addAll(points);
        ConvexHullAndrewMonotone_F32 fitter = new ConvexHullAndrewMonotone_F32();
        fitter.process(array, output);
        return output;
    }
}

