/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.points;

import georegression.fitting.points.MatchCloudToCloud;
import georegression.fitting.points.MatchCloudToCloudIcp;
import georegression.fitting.se.MotionSe2PointSVD_F32;
import georegression.fitting.se.MotionSe2PointSVD_F64;
import georegression.fitting.se.MotionSe3PointSVD_F32;
import georegression.fitting.se.MotionSe3PointSVD_F64;
import georegression.helper.KdTreePoint2D_F32;
import georegression.helper.KdTreePoint2D_F64;
import georegression.helper.KdTreePoint3D_F32;
import georegression.helper.KdTreePoint3D_F64;
import georegression.misc.StoppingCondition;
import georegression.struct.GeoTuple2D_F32;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple_F32;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se2_F32;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F32;
import georegression.struct.se.Se3_F64;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;

public class FactoryIterativeClosestPoint {
    public static MatchCloudToCloud<Se2_F32, Point2D_F32> cloudIcp2D_F32(double maxDistance, StoppingCondition stop) {
        NearestNeighbor<Point2D_F32> nn = FactoryNearestNeighbor.kdtree(new KdTreePoint2D_F32());
        return new SE2_F32(nn, maxDistance * maxDistance, stop);
    }

    public static MatchCloudToCloud<Se2_F64, Point2D_F64> cloudIcp2D_F64(double maxDistance, StoppingCondition stop) {
        NearestNeighbor<Point2D_F64> nn = FactoryNearestNeighbor.kdtree(new KdTreePoint2D_F64());
        return new SE2_F64(nn, maxDistance * maxDistance, stop);
    }

    public static MatchCloudToCloud<Se3_F32, Point3D_F32> cloudIcp3D_F32(double maxDistance, StoppingCondition stop) {
        NearestNeighbor<Point3D_F32> nn = FactoryNearestNeighbor.kdtree(new KdTreePoint3D_F32());
        return new SE3_F32(nn, maxDistance * maxDistance, stop);
    }

    public static MatchCloudToCloud<Se3_F64, Point3D_F64> cloudIcp3D_F64(double maxDistance, StoppingCondition stop) {
        NearestNeighbor<Point3D_F64> nn = FactoryNearestNeighbor.kdtree(new KdTreePoint3D_F64());
        return new SE3_F64(nn, maxDistance * maxDistance, stop);
    }

    public static class SE2_F32
    extends MatchCloudToCloudIcp<Se2_F32, Point2D_F32> {
        public SE2_F32(NearestNeighbor<Point2D_F32> nn, double maxDistanceSq, StoppingCondition stop) {
            super(new MotionSe2PointSVD_F32(), nn, GeoTuple2D_F32::distance2, maxDistanceSq, stop);
        }
    }

    public static class SE2_F64
    extends MatchCloudToCloudIcp<Se2_F64, Point2D_F64> {
        public SE2_F64(NearestNeighbor<Point2D_F64> nn, double maxDistanceSq, StoppingCondition stop) {
            super(new MotionSe2PointSVD_F64(), nn, GeoTuple2D_F64::distance2, maxDistanceSq, stop);
        }
    }

    public static class SE3_F32
    extends MatchCloudToCloudIcp<Se3_F32, Point3D_F32> {
        public SE3_F32(NearestNeighbor<Point3D_F32> nn, double maxDistanceSq, StoppingCondition stop) {
            super(new MotionSe3PointSVD_F32(), nn, GeoTuple_F32::distance2, maxDistanceSq, stop);
        }
    }

    public static class SE3_F64
    extends MatchCloudToCloudIcp<Se3_F64, Point3D_F64> {
        public SE3_F64(NearestNeighbor<Point3D_F64> nn, double maxDistanceSq, StoppingCondition stop) {
            super(new MotionSe3PointSVD_F64(), nn, GeoTuple_F64::distance2, maxDistanceSq, stop);
        }
    }
}

