/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.line;

import georegression.struct.line.LinePolar2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FitLine_F64 {
    public static LinePolar2D_F64 polar(List<Point2D_F64> points, @Nullable LinePolar2D_F64 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F64();
        }
        double meanX = 0.0;
        double meanY = 0.0;
        int N = points.size();
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = points.get(i);
            meanX += p.x;
            meanY += p.y;
        }
        meanX /= (double)N;
        meanY /= (double)N;
        double top = 0.0;
        double bottom = 0.0;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = points.get(i);
            double dx = meanX - p.x;
            double dy = meanY - p.y;
            top += dx * dy;
            bottom += dy * dy - dx * dx;
        }
        ret.angle = Math.atan2(-2.0 * top, bottom) / 2.0;
        ret.distance = meanX * Math.cos(ret.angle) + meanY * Math.sin(ret.angle);
        return ret;
    }

    @Nullable
    public static LinePolar2D_F64 polar(List<Point2D_F64> points, double[] weights, @Nullable LinePolar2D_F64 ret) {
        int N = points.size();
        double totalWeight = 0.0;
        for (int i = 0; i < N; ++i) {
            totalWeight += weights[i];
        }
        if (totalWeight == 0.0) {
            return null;
        }
        if (ret == null) {
            ret = new LinePolar2D_F64();
        }
        double meanX = 0.0;
        double meanY = 0.0;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = points.get(i);
            double w = weights[i];
            meanX += w * p.x;
            meanY += w * p.y;
        }
        meanX /= totalWeight;
        meanY /= totalWeight;
        double top = 0.0;
        double bottom = 0.0;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = points.get(i);
            double w = weights[i];
            double dx = meanX - p.x;
            double dy = meanY - p.y;
            top += w * dx * dy;
            bottom += w * (dy * dy - dx * dx);
        }
        ret.angle = Math.atan2(-2.0 * (top /= totalWeight), bottom /= totalWeight) / 2.0;
        ret.distance = meanX * Math.cos(ret.angle) + meanY * Math.sin(ret.angle);
        return ret;
    }
}

