/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.line;

import georegression.struct.line.LinePolar2D_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FitLine_F32 {
    public static LinePolar2D_F32 polar(List<Point2D_F32> points, @Nullable LinePolar2D_F32 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F32();
        }
        float meanX = 0.0f;
        float meanY = 0.0f;
        int N = points.size();
        for (int i = 0; i < N; ++i) {
            Point2D_F32 p = points.get(i);
            meanX += p.x;
            meanY += p.y;
        }
        meanX /= (float)N;
        meanY /= (float)N;
        float top = 0.0f;
        float bottom = 0.0f;
        for (int i = 0; i < N; ++i) {
            Point2D_F32 p = points.get(i);
            float dx = meanX - p.x;
            float dy = meanY - p.y;
            top += dx * dy;
            bottom += dy * dy - dx * dx;
        }
        ret.angle = (float)Math.atan2(-2.0f * top, bottom) / 2.0f;
        ret.distance = (float)((double)meanX * Math.cos(ret.angle) + (double)meanY * Math.sin(ret.angle));
        return ret;
    }

    @Nullable
    public static LinePolar2D_F32 polar(List<Point2D_F32> points, float[] weights, @Nullable LinePolar2D_F32 ret) {
        int N = points.size();
        float totalWeight = 0.0f;
        for (int i = 0; i < N; ++i) {
            totalWeight += weights[i];
        }
        if (totalWeight == 0.0f) {
            return null;
        }
        if (ret == null) {
            ret = new LinePolar2D_F32();
        }
        float meanX = 0.0f;
        float meanY = 0.0f;
        for (int i = 0; i < N; ++i) {
            Point2D_F32 p = points.get(i);
            float w = weights[i];
            meanX += w * p.x;
            meanY += w * p.y;
        }
        meanX /= totalWeight;
        meanY /= totalWeight;
        float top = 0.0f;
        float bottom = 0.0f;
        for (int i = 0; i < N; ++i) {
            Point2D_F32 p = points.get(i);
            float w = weights[i];
            float dx = meanX - p.x;
            float dy = meanY - p.y;
            top += w * dx * dy;
            bottom += w * (dy * dy - dx * dx);
        }
        ret.angle = (float)Math.atan2(-2.0f * (top /= totalWeight), bottom /= totalWeight) / 2.0f;
        ret.distance = (float)((double)meanX * Math.cos(ret.angle) + (double)meanY * Math.sin(ret.angle));
        return ret;
    }
}

