/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.line;

import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.linsol.qr.SolveNullSpaceQRP_DDRM;
import org.ejml.interfaces.SolveNullSpace;

public class FitLineParametricSvd_F64 {
    double mean_x;
    double mean_y;
    double std_x;
    double std_y;
    public SolveNullSpace<DMatrixRMaj> solver = new SolveNullSpaceQRP_DDRM();
    DMatrixRMaj A = new DMatrixRMaj(1, 1);
    DMatrixRMaj AA = new DMatrixRMaj(1, 1);
    DMatrixRMaj ns = new DMatrixRMaj(2, 1);

    public boolean fit(List<Point2D_F64> points, LineParametric2D_F64 line) {
        this.computeNormalization(points);
        this.A.reshape(points.size(), 2);
        int idx = 0;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            this.A.data[idx++] = (p.x - this.mean_x) / this.std_x;
            this.A.data[idx++] = (p.y - this.mean_y) / this.std_y;
        }
        CommonOps_DDRM.multTransA(this.A, this.A, this.AA);
        if (this.solver.process(this.AA, 1, this.ns)) {
            line.p.setTo(this.mean_x, this.mean_y);
            line.slope.x = -this.ns.data[1] * this.std_x;
            line.slope.y = this.ns.data[0] * this.std_y;
            return true;
        }
        return false;
    }

    private void computeNormalization(List<Point2D_F64> points) {
        Point2D_F64 p;
        int i;
        this.mean_y = 0.0;
        this.mean_x = 0.0;
        this.std_y = 0.0;
        this.std_x = 0.0;
        for (i = 0; i < points.size(); ++i) {
            p = points.get(i);
            this.mean_x += p.x;
            this.mean_y += p.y;
        }
        this.mean_x /= (double)points.size();
        this.mean_y /= (double)points.size();
        for (i = 0; i < points.size(); ++i) {
            p = points.get(i);
            double dx = p.x - this.mean_x;
            double dy = p.y - this.mean_y;
            this.std_x += dx * dx;
            this.std_y += dy * dy;
        }
        this.std_x = this.std_x == 0.0 ? Math.abs(this.mean_x) : Math.sqrt(this.std_x / (double)points.size());
        this.std_y = this.std_y == 0.0 ? Math.abs(this.mean_y) : Math.sqrt(this.std_y / (double)points.size());
    }
}

