/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.Scale;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static Image scaledImageFromComponent(Component c, Rectangle bounds) {
        return ImageUtil.scaledImageFromComponent(c, bounds, Scale.SCALE_X, Scale.SCALE_Y);
    }

    public static Image scaledImageFromComponent(Component c, Rectangle bounds, double scalex, double scaley) {
        boolean scale = scalex != 1.0 || scaley != 1.0;
        BufferedImage image = scale ? new BufferedImage((int)(scalex * (double)bounds.width), (int)(scaley * (double)bounds.height), 1) : new BufferedImage(bounds.width, bounds.height, 1);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        if (scale) {
            g2d.scale(scalex, scaley);
        }
        g2d.translate(-bounds.x, -bounds.y);
        c.printAll(g2d);
        g2d.dispose();
        return image;
    }

    public static Image imageFromComponent(Component c, Rectangle bounds) {
        return ImageUtil.scaledImageFromComponent(c, bounds, 1.0, 1.0);
    }

    public static Icon cropIcon(Icon icon, int maxWidth, int maxHeight) {
        if (icon.getIconHeight() <= maxHeight && icon.getIconWidth() <= maxWidth) {
            return icon;
        }
        Image image = ImageUtil.toImage(icon);
        if (image == null) {
            return icon;
        }
        double scale = 1.0;
        BufferedImage bi = ImageUtil.toBufferedImage(image);
        Graphics2D g = bi.createGraphics();
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        maxWidth = maxWidth == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.round((double)maxWidth * scale);
        maxHeight = maxHeight == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.round((double)maxHeight * scale);
        int w = Math.min(imageWidth, maxWidth);
        int h = Math.min(imageHeight, maxHeight);
        BufferedImage img = new BufferedImage(w, h, 3);
        int offX = imageWidth > maxWidth ? (imageWidth - maxWidth) / 2 : 0;
        int offY = imageHeight > maxHeight ? (imageHeight - maxHeight) / 2 : 0;
        for (int col = 0; col < w; ++col) {
            for (int row = 0; row < h; ++row) {
                img.setRGB(col, row, bi.getRGB(col + offX, row + offY));
            }
        }
        g.dispose();
        return new ImageIcon(img);
    }

    public static Image toImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
        icon.paintIcon(null, image.getGraphics(), 0, 0);
        return image;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            throw new NullPointerException("Can't covert null image");
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return ImageUtil.isHeadless() ? new BufferedImage(width, height, 2) : ImageUtil.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }
}

