/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Map;

public class GraphicsContext {
    private final Graphics2D graphics2D;
    private final Composite composite;
    private final Map<?, ?> hintsMap;
    private final Stroke stroke;
    private final Color color;
    private final Paint paint;
    private final Font font;
    private final Shape clip;

    public GraphicsContext(Graphics g) {
        this.graphics2D = (Graphics2D)g;
        this.hintsMap = (Map)this.graphics2D.getRenderingHints().clone();
        this.composite = this.graphics2D.getComposite();
        this.stroke = this.graphics2D.getStroke();
        this.color = this.graphics2D.getColor();
        this.paint = this.graphics2D.getPaint();
        this.font = this.graphics2D.getFont();
        this.clip = this.graphics2D.getClip();
    }

    public GraphicsContext setAntialiasing(boolean on) {
        this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, on ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        return this;
    }

    public Graphics2D getGraphics() {
        return this.graphics2D;
    }

    public void restore() {
        this.graphics2D.setRenderingHints(this.hintsMap);
        this.graphics2D.setComposite(this.composite);
        this.graphics2D.setStroke(this.stroke);
        this.graphics2D.setColor(this.color);
        this.graphics2D.setPaint(this.paint);
        this.graphics2D.setFont(this.font);
        this.graphics2D.setClip(this.clip);
    }
}

