/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.decorators.CellRenderer;
import com.github.weisj.darklaf.ui.popupmenu.DarkPopupMenuUI;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractAction;
import javax.swing.CellEditor;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import sun.awt.SunToolkit;

public final class DarkUIUtil {
    public static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    public static final AlphaComposite GLOW_ALPHA = AlphaComposite.getInstance(3, 0.5f);
    public static final AlphaComposite DROP_ALPHA = AlphaComposite.getInstance(3, 0.8f);
    public static final AlphaComposite SHADOW_COMPOSITE = AlphaComposite.getInstance(3, 0.1f);
    public static final boolean USE_QUARTZ = "true".equals(System.getProperty("apple.awt.graphics.UseQuartz"));
    private static final Rectangle iconRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();

    private static Color getErrorGlow() {
        return UIManager.getColor("glowError");
    }

    private static Color getErrorFocusGlow() {
        return UIManager.getColor("glowFocusError");
    }

    private static Color getFocusGlow() {
        return UIManager.getColor("glowFocus");
    }

    private static Color getWarningGlow() {
        return UIManager.getColor("glowWarning");
    }

    public static void paintOutlineBorder(Graphics2D g, int width, int height, float arc, float bw, boolean hasFocus, Outline type) {
        type.setGraphicsColor(g, hasFocus);
        DarkUIUtil.doPaint(g, width, height, arc, bw);
    }

    private static void doPaint(Graphics2D g, int width, int height, float arc, float bw) {
        GraphicsContext context = GraphicsUtil.setupStrokePainting(g);
        RoundRectangle2D.Float outerRect = new RoundRectangle2D.Float(0.0f, 0.0f, width, height, arc + bw, arc + bw);
        RoundRectangle2D.Float innerRect = new RoundRectangle2D.Float(bw, bw, (float)width - 2.0f * bw, (float)height - 2.0f * bw, arc - bw, arc - bw);
        Path2D.Float path = new Path2D.Float(0);
        path.append(outerRect, false);
        path.append(innerRect, false);
        g.fill(path);
        context.restore();
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, float arc, float bw) {
        GraphicsContext config = new GraphicsContext(g);
        g.setComposite(GLOW_ALPHA);
        Outline.focus.setGraphicsColor(g, true);
        DarkUIUtil.doPaint(g, width, height, arc, bw);
        config.restore();
    }

    public static void fillFocusRect(Graphics2D g, int x, int y, int width, int height) {
        GraphicsContext config = new GraphicsContext(g);
        g.setComposite(GLOW_ALPHA);
        Outline.focus.setGraphicsColor(g, true);
        g.fillRect(x, y, width, height);
        config.restore();
    }

    public static void paintFocusOval(Graphics2D g, int x, int y, int width, int height) {
        DarkUIUtil.paintFocusOval(g, (float)x, (float)y, (float)width, (float)height);
    }

    public static void paintFocusOval(Graphics2D g, float x, float y, float width, float height) {
        GraphicsContext config = new GraphicsContext(g);
        g.setComposite(GLOW_ALPHA);
        Outline.focus.setGraphicsColor(g, true);
        float blw = 3.0f;
        Path2D.Float shape = new Path2D.Float(0);
        shape.append(new Ellipse2D.Float(x - blw, y - blw, width + blw * 2.0f, height + blw * 2.0f), false);
        shape.append(new Ellipse2D.Float(x, y, width, height), false);
        g.fill(shape);
        config.restore();
    }

    public static void paintLineBorder(Graphics2D g, float x, float y, float width, float height, int arc) {
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        Stroke stroke = g.getStroke();
        float lw = stroke instanceof BasicStroke ? ((BasicStroke)stroke).getLineWidth() : 1.0f;
        g.draw(new RoundRectangle2D.Float(x - lw, y - lw, width + lw, height + lw, arc, arc));
        config.restore();
    }

    public static void fillRoundRect(Graphics2D g, float x, float y, float width, float height, int arc) {
        Stroke stroke = g.getStroke();
        float lw = stroke instanceof BasicStroke ? ((BasicStroke)stroke).getLineWidth() : 1.0f;
        g.fill(new RoundRectangle2D.Float(x - lw, y - lw, width + lw, height + lw, arc, arc));
    }

    public static Color blendColors(Color color1, Color color2, double percent) {
        if (percent == 1.0) {
            return color1;
        }
        if (percent == 0.0) {
            return color2;
        }
        double inverse_percent = 1.0 - percent;
        int redPart = (int)((double)color1.getRed() * percent + (double)color2.getRed() * inverse_percent);
        int greenPart = (int)((double)color1.getGreen() * percent + (double)color2.getGreen() * inverse_percent);
        int bluePart = (int)((double)color1.getBlue() * percent + (double)color2.getBlue() * inverse_percent);
        return new Color(redPart, greenPart, bluePart);
    }

    public static void applyInsets(Rectangle rect, Insets insets) {
        if (insets != null && rect != null) {
            rect.x += insets.left;
            rect.y += insets.top;
            rect.width -= insets.right + rect.x;
            rect.height -= insets.bottom + rect.y;
        }
    }

    public static void removeInsets(Rectangle rectangle, Insets insets) {
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
    }

    public static void repaint(JComponent component) {
        if (component != null) {
            component.repaint();
        }
    }

    public static boolean hasFocus(Component c) {
        return DarkUIUtil.hasFocus(c, null);
    }

    public static boolean hasFocus(Component c, FocusEvent e) {
        if (c == null) {
            return false;
        }
        if (c.hasFocus()) {
            return true;
        }
        if (c instanceof Window) {
            return DarkUIUtil.hasFocus(c);
        }
        Component owner = null;
        if (e != null) {
            owner = e.getOppositeComponent();
        }
        if (owner == null) {
            owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        return owner != null && SwingUtilities.isDescendingFrom(owner, c);
    }

    public static boolean hasFocus(Window w) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return false;
        }
        return SwingUtilities.getWindowAncestor(owner) == w;
    }

    public static Container getUnwrappedParent(Container comp) {
        if (comp == null) {
            return null;
        }
        return SwingUtilities.getUnwrappedParent(comp);
    }

    public static Container getUnwrappedParent(Component comp) {
        if (comp == null) {
            return null;
        }
        return SwingUtilities.getUnwrappedParent(comp);
    }

    public static int getFocusAcceleratorKeyMask() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk instanceof SunToolkit) {
            return ((SunToolkit)tk).getFocusAcceleratorKeyMask();
        }
        return 8;
    }

    public static Object getUIOfType(ComponentUI ui, Class<?> klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public static void doNotCancelPopupSetup(JComponent component) {
        component.putClientProperty("doNotCancelPopup", DarkPopupMenuUI.HIDE_POPUP_VALUE);
        component.putClientProperty("doNotCancelOnScroll", Boolean.TRUE);
    }

    public static boolean isInCell(Component c) {
        boolean inCellRenderer = DarkUIUtil.getParentOfType(CellRendererPane.class, c) != null || DarkUIUtil.getParentOfType(TableCellRenderer.class, c) != null || DarkUIUtil.getParentOfType(TreeCellRenderer.class, c) != null || DarkUIUtil.getParentOfType(CellRenderer.class, c) != null || DarkUIUtil.getParentOfType(CellEditor.class, c) != null;
        return inCellRenderer && DarkUIUtil.getParentOfType(JComboBox.class, c) == null;
    }

    public static <T> T getParentOfType(Class<? extends T> cls, Component c) {
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!cls.isAssignableFrom(eachParent.getClass())) continue;
            return (T)eachParent;
        }
        return null;
    }

    public static Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        return component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
    }

    public static boolean isTooltipShowing(JComponent component) {
        AbstractAction hideTipAction = (AbstractAction)component.getActionMap().get("hideTip");
        return hideTipAction.isEnabled();
    }

    public static MenuElement findEnabledChild(MenuElement[] e, MenuElement elem, boolean forward) {
        for (int i = 0; i < e.length; ++i) {
            if (e[i] != elem) continue;
            return DarkUIUtil.findEnabledChild(e, i, forward);
        }
        return null;
    }

    public static MenuElement findEnabledChild(MenuElement[] e, int fromIndex, boolean forward) {
        MenuElement result;
        if (forward) {
            result = DarkUIUtil.nextEnabledChild(e, fromIndex + 1, e.length - 1);
            if (result == null) {
                result = DarkUIUtil.nextEnabledChild(e, 0, fromIndex - 1);
            }
        } else {
            result = DarkUIUtil.previousEnabledChild(e, fromIndex - 1, 0);
            if (result == null) {
                result = DarkUIUtil.previousEnabledChild(e, e.length - 1, fromIndex + 1);
            }
        }
        return result;
    }

    private static MenuElement nextEnabledChild(MenuElement[] e, int fromIndex, int toIndex) {
        for (int i = fromIndex; i <= toIndex; ++i) {
            Component comp;
            if (e[i] == null || (comp = e[i].getComponent()) == null || !comp.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !comp.isVisible()) continue;
            return e[i];
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] e, int fromIndex, int toIndex) {
        for (int i = fromIndex; i >= toIndex; --i) {
            Component comp;
            if (e[i] == null || (comp = e[i].getComponent()) == null || !comp.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !comp.isVisible()) continue;
            return e[i];
        }
        return null;
    }

    public static void drawRect(Graphics g, int x, int y, int width, int height, int thickness) {
        g.fillRect(x, y, width, thickness);
        g.fillRect(x, y + thickness, thickness, height - 2 * thickness);
        g.fillRect(x + width - thickness, y + thickness, thickness, height - 2 * thickness);
        g.fillRect(x, y + height - thickness, width, thickness);
    }

    public static boolean isOverText(MouseEvent e, int index, JList list) {
        Rectangle bounds = list.getCellBounds(index, index);
        if (!bounds.contains(e.getPoint())) {
            return false;
        }
        Component cellRenderer = list.getCellRenderer().getListCellRendererComponent(list, list.getModel().getElementAt(index), index, false, false);
        if (cellRenderer instanceof JLabel) {
            return DarkUIUtil.isOverText((JLabel)cellRenderer, bounds, e.getPoint());
        }
        return true;
    }

    public static boolean isOverText(JLabel label, Rectangle bounds, Point p) {
        textRect.setBounds(0, 0, 0, 0);
        iconRect.setBounds(0, 0, 0, 0);
        SwingUtilities.layoutCompoundLabel(label, label.getFontMetrics(label.getFont()), label.getText(), label.getIcon(), label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), bounds, iconRect, textRect, label.getIconTextGap());
        return textRect.contains(p);
    }

    public static boolean isOverText(MouseEvent e, int row, int column, JTable table) {
        Rectangle bounds = table.getCellRect(row, column, false);
        if (!bounds.contains(e.getPoint())) {
            return false;
        }
        Component cellRenderer = table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), false, false, row, column);
        if (cellRenderer instanceof JLabel) {
            return DarkUIUtil.isOverText((JLabel)cellRenderer, bounds, e.getPoint());
        }
        return true;
    }

    public static boolean isMenuShortcutKeyDown(InputEvent event) {
        return (event.getModifiersEx() & 0x80) != 0;
    }

    public static void rotateRectangle(Rectangle rect) {
        int tmp = rect.x;
        rect.x = rect.y;
        rect.y = tmp;
        tmp = rect.width;
        rect.width = rect.height;
        rect.height = tmp;
    }

    public static void rotatePoint(Point p) {
        int tmp = p.x;
        p.x = p.y;
        p.y = tmp;
    }

    public static Insets getBorderInsets(JComponent comp) {
        Border border = comp.getBorder();
        if (border == null) {
            return new InsetsUIResource(0, 0, 0, 0);
        }
        return border.getBorderInsets(comp);
    }

    public static Point adjustForOrientation(Point p, int w, Component c) {
        if (!c.getComponentOrientation().isLeftToRight()) {
            p.x = c.getWidth() - p.x - w;
        }
        return p;
    }

    public static enum Outline {
        error{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                if (focused) {
                    g.setColor(DarkUIUtil.getErrorFocusGlow());
                } else {
                    g.setColor(DarkUIUtil.getErrorGlow());
                }
            }
        }
        ,
        warning{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                g.setColor(DarkUIUtil.getWarningGlow());
            }
        }
        ,
        defaultButton{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                if (focused) {
                    g.setColor(DarkUIUtil.getFocusGlow());
                }
            }
        }
        ,
        focus{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                if (focused) {
                    g.setColor(DarkUIUtil.getFocusGlow());
                }
            }
        };


        public abstract void setGraphicsColor(Graphics2D var1, boolean var2);
    }
}

