/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.AlignmentHelper;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.function.BiFunction;

public enum Alignment {
    NORTH(AlignmentHelper.align(AlignmentHelper.HOR_CENTER_INSIDE, AlignmentHelper.VERT_TOP_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_CENTER_OUTSIDE, AlignmentHelper.VERT_TOP_OUTSIDE)),
    SOUTH(AlignmentHelper.align(AlignmentHelper.HOR_CENTER_INSIDE, AlignmentHelper.VERT_BOTTOM_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_CENTER_OUTSIDE, AlignmentHelper.VERT_BOTTOM_OUTSIDE)),
    EAST(AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_INSIDE, AlignmentHelper.VERT_CENTER_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_OUTSIDE, AlignmentHelper.VERT_CENTER_OUTSIDE)),
    WEST(AlignmentHelper.align(AlignmentHelper.HOR_LEFT_INSIDE, AlignmentHelper.VERT_CENTER_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_LEFT_OUTSIDE, AlignmentHelper.VERT_CENTER_OUTSIDE)),
    NORTH_EAST(AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_INSIDE, AlignmentHelper.VERT_TOP_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_OUTSIDE, AlignmentHelper.VERT_TOP_OUTSIDE)),
    NORTH_WEST(AlignmentHelper.align(AlignmentHelper.HOR_LEFT_INSIDE, AlignmentHelper.VERT_TOP_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_LEFT_OUTSIDE, AlignmentHelper.VERT_TOP_OUTSIDE)),
    SOUTH_EAST(AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_INSIDE, AlignmentHelper.VERT_BOTTOM_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_OUTSIDE, AlignmentHelper.VERT_BOTTOM_OUTSIDE)),
    SOUTH_WEST(AlignmentHelper.align(AlignmentHelper.HOR_LEFT_INSIDE, AlignmentHelper.VERT_BOTTOM_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_LEFT_OUTSIDE, AlignmentHelper.VERT_BOTTOM_OUTSIDE)),
    CENTER(AlignmentHelper.align(AlignmentHelper.HOR_CENTER_INSIDE, AlignmentHelper.VERT_CENTER_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_CENTER_OUTSIDE, AlignmentHelper.VERT_CENTER_OUTSIDE));

    private final BiFunction<Dimension, Rectangle, Point> alignInside;
    private final BiFunction<Dimension, Rectangle, Point> alignOutside;

    private Alignment(BiFunction<Dimension, Rectangle, Point> alignInside, BiFunction<Dimension, Rectangle, Point> alignOutside) {
        this.alignInside = alignInside;
        this.alignOutside = alignOutside;
    }

    public static Alignment getAlignment(Point point, Dimension size, Rectangle outerBounds, Alignment hint) {
        if (hint.canBeAligned(point, size, outerBounds)) {
            return hint;
        }
        for (Alignment alignment : Alignment.values()) {
            if (alignment == CENTER || alignment == hint || !alignment.canBeAligned(point, size, outerBounds)) continue;
            return alignment;
        }
        return CENTER;
    }

    public boolean canBeAligned(Point point, Dimension size, Rectangle outerBounds) {
        Point p = this.relativePos(size, point);
        return p.x >= outerBounds.x && p.y >= outerBounds.y && p.x + size.width < outerBounds.x + outerBounds.width && p.y + size.height < outerBounds.x + outerBounds.height;
    }

    public Point relativePos(Dimension toAlign, Point alignAt) {
        return this.alignOutside(toAlign, new Rectangle(alignAt.x, alignAt.y, 0, 0));
    }

    public Point alignOutside(Dimension toAlign, Rectangle innerBounds) {
        return this.alignOutside.apply(toAlign, innerBounds);
    }

    public int getIndex() {
        return this.ordinal();
    }

    public Alignment opposite() {
        switch (this) {
            case NORTH: {
                return SOUTH;
            }
            case NORTH_EAST: {
                return SOUTH_WEST;
            }
            case EAST: {
                return WEST;
            }
            case SOUTH_EAST: {
                return NORTH_WEST;
            }
            case SOUTH: {
                return NORTH;
            }
            case SOUTH_WEST: {
                return NORTH_EAST;
            }
            case WEST: {
                return EAST;
            }
            case NORTH_WEST: {
                return SOUTH_EAST;
            }
            case CENTER: {
                return CENTER;
            }
        }
        throw new IllegalArgumentException();
    }

    public Alignment anticlockwise() {
        switch (this) {
            case NORTH: {
                return NORTH_WEST;
            }
            case NORTH_EAST: {
                return NORTH;
            }
            case EAST: {
                return NORTH_EAST;
            }
            case SOUTH_EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH_EAST;
            }
            case SOUTH_WEST: {
                return SOUTH;
            }
            case WEST: {
                return SOUTH_WEST;
            }
            case NORTH_WEST: {
                return WEST;
            }
            case CENTER: {
                return CENTER;
            }
        }
        throw new IllegalArgumentException();
    }

    public Alignment clockwise() {
        switch (this) {
            case NORTH: {
                return NORTH_EAST;
            }
            case NORTH_EAST: {
                return EAST;
            }
            case EAST: {
                return SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return WEST;
            }
            case WEST: {
                return NORTH_WEST;
            }
            case NORTH_WEST: {
                return NORTH;
            }
            case CENTER: {
                return CENTER;
            }
        }
        throw new IllegalArgumentException();
    }

    public Insets maskInsets(Insets insets) {
        return this.maskInsets(insets, 0);
    }

    public Insets maskInsets(Insets insets, int maskValue) {
        return this.maskInsets(insets.top, insets.left, insets.bottom, insets.right, maskValue);
    }

    public Insets maskInsets(int top, int left, int bottom, int right, int mask) {
        switch (this) {
            case NORTH: {
                return new Insets(top, mask, mask, mask);
            }
            case NORTH_EAST: {
                return new Insets(top, mask, mask, right);
            }
            case EAST: {
                return new Insets(mask, mask, mask, right);
            }
            case SOUTH_EAST: {
                return new Insets(mask, mask, bottom, right);
            }
            case SOUTH: {
                return new Insets(mask, mask, bottom, mask);
            }
            case SOUTH_WEST: {
                return new Insets(mask, left, bottom, mask);
            }
            case WEST: {
                return new Insets(mask, left, mask, mask);
            }
            case NORTH_WEST: {
                return new Insets(top, left, mask, mask);
            }
            case CENTER: {
                return new Insets(mask, mask, mask, mask);
            }
        }
        throw new IllegalArgumentException();
    }

    public Insets maskInsetsInverted(Insets insets) {
        return this.maskInsetsInverted(insets, 0);
    }

    public Insets maskInsetsInverted(Insets insets, int mask) {
        return this.maskInsetsInverted(insets.top, insets.left, insets.bottom, insets.right, mask);
    }

    public Insets maskInsetsInverted(int top, int left, int bottom, int right, int mask) {
        Insets masking = this.maskInsets(0, 0, 0, 0, 1);
        Insets maskVal = this.maskInsets(mask, mask, mask, mask, 0);
        return new Insets(top * masking.top + maskVal.top, left * masking.left + maskVal.left, bottom * masking.bottom + maskVal.bottom, right * masking.right + maskVal.right);
    }

    public Point alignInside(Dimension toAlign, Rectangle outerBounds) {
        return this.alignInside.apply(toAlign, outerBounds);
    }
}

