/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.ui.tree.DarkDefaultTreeEditor;
import com.github.weisj.darklaf.ui.tree.DarkTreeCellRenderer;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DarkTreeUI
extends BasicTreeUI
implements PropertyChangeListener {
    protected static final String KEY_PREFIX = "JTree.";
    public static final String KEY_TREE_TABLE_TREE = "JTree.treeTableTree";
    public static final String KEY_ALTERNATE_ROW_COLOR = "JTree.alternateRowColor";
    public static final String KEY_RENDER_BOOLEAN_AS_CHECKBOX = "JTree.renderBooleanAsCheckBox";
    public static final String KEY_BOOLEAN_RENDER_TYPE = "JTree.booleanRenderType";
    public static final String KEY_LINE_STYLE = "JTree.lineStyle";
    public static final String KEY_MAC_ACTIONS_INSTALLED = "MacTreeUi.actionsInstalled";
    public static final String RENDER_TYPE_CHECKBOX = "checkBox";
    public static final String RENDER_TYPE_RADIOBUTTON = "radioButton";
    public static final String STYLE_LINE = "line";
    public static final String STYLE_DASHED = "dashed";
    public static final String STYLE_NONE = "none";
    private final MouseListener selectionListener = new MouseAdapter(){
        boolean handled = false;

        @Override
        public void mousePressed(MouseEvent e) {
            this.handled = false;
            DarkTreeUI.this.tree.repaint();
            if (!DarkTreeUI.this.isSelected(e)) {
                this.handled = true;
                this.handle(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.handled) {
                this.handle(e);
            }
        }

        private void handle(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            if (SwingUtilities.isLeftMouseButton(e) && !e.isPopupTrigger()) {
                if (DarkTreeUI.this.isEditing(tree) && tree.getInvokesStopCellEditing() && !DarkTreeUI.this.stopEditing(tree)) {
                    return;
                }
                TreePath pressedPath = DarkTreeUI.this.getClosestPathForLocation(tree, e.getX(), e.getY());
                if (pressedPath != null) {
                    Rectangle bounds = DarkTreeUI.this.getPathBounds(tree, pressedPath);
                    if (e.getY() >= bounds.y + bounds.height) {
                        return;
                    }
                    if (bounds.contains(e.getPoint()) || DarkTreeUI.this.isLocationInExpandControl(pressedPath, e.getX(), e.getY())) {
                        return;
                    }
                    if (tree.getDragEnabled() || !DarkTreeUI.this.startEditing(pressedPath, e)) {
                        DarkTreeUI.this.selectPathForEvent(pressedPath, e);
                    }
                }
            }
        }
    };
    protected Color alternativeBackground;
    protected Color lineColor;
    protected Color focusSelectedLineColor;
    protected Color selectedLineColor;
    protected Color selectionBackground;
    protected Color focusSelectionBackground;
    protected Icon expandedFocusSelected;
    protected Icon expandedSelected;
    protected Icon expandedFocus;
    protected Icon expanded;
    protected Icon collapsedFocusSelected;
    protected Icon collapsedSelected;
    protected Icon collapsedFocus;
    protected Icon collapsed;
    private boolean myOldRepaintAllRowValue;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTreeUI();
    }

    protected boolean isSelected(MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        int selected = tree.getClosestRowForLocation(e.getX(), e.getY());
        int[] rows = tree.getSelectionRows();
        if (rows != null) {
            for (int row : rows) {
                if (row != selected) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void completeUIInstall() {
        super.completeUIInstall();
        this.myOldRepaintAllRowValue = UIManager.getBoolean("Tree.repaintWholeRow");
        UIManager.put("Tree.repaintWholeRow", true);
        this.tree.putClientProperty(KEY_ALTERNATE_ROW_COLOR, UIManager.getBoolean("Tree.alternateRowColor"));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.selectionBackground = UIManager.getColor("Tree.unfocusedSelectionBackground");
        this.focusSelectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.focusSelectedLineColor = UIManager.getColor("Tree.lineFocusSelected");
        this.selectedLineColor = UIManager.getColor("Tree.lineSelected");
        this.lineColor = UIManager.getColor("Tree.lineUnselected");
        this.alternativeBackground = UIManager.getColor("Tree.alternateRowBackground");
        this.expandedFocusSelected = UIManager.getIcon("Tree.expanded.selected.focused.icon");
        this.expandedSelected = UIManager.getIcon("Tree.expanded.selected.unfocused.icon");
        this.expandedFocus = UIManager.getIcon("Tree.expanded.unselected.focused.icon");
        this.expanded = UIManager.getIcon("Tree.expanded.unselected.unfocused.icon");
        this.collapsedFocusSelected = UIManager.getIcon("Tree.collapsed.selected.focused.icon");
        this.collapsedSelected = UIManager.getIcon("Tree.collapsed.selected.unfocused.icon");
        this.collapsedFocus = UIManager.getIcon("Tree.collapsed.unselected.focused.icon");
        this.collapsed = UIManager.getIcon("Tree.collapsed.unselected.unfocused.icon");
        this.tree.putClientProperty(KEY_RENDER_BOOLEAN_AS_CHECKBOX, UIManager.getBoolean("Tree.renderBooleanAsCheckBox"));
        this.tree.putClientProperty(KEY_BOOLEAN_RENDER_TYPE, UIManager.getString("Tree.booleanRenderType"));
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty(KEY_LINE_STYLE, UIManager.getString("Tree.defaultLineStyle"));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tree.addPropertyChangeListener(this);
        this.tree.addMouseListener(this.selectionListener);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (Boolean.TRUE.equals(this.tree.getClientProperty(KEY_MAC_ACTIONS_INSTALLED))) {
            return;
        }
        this.tree.putClientProperty(KEY_MAC_ACTIONS_INSTALLED, Boolean.TRUE);
        InputMap inputMap = this.tree.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke("pressed LEFT"), "collapse_or_move_up");
        inputMap.put(KeyStroke.getKeyStroke("pressed RIGHT"), "expand_or_move_down");
        inputMap.put(KeyStroke.getKeyStroke("pressed DOWN"), "move_up");
        inputMap.put(KeyStroke.getKeyStroke("pressed UP"), "move_down");
        inputMap.put(KeyStroke.getKeyStroke("pressed ENTER"), "toggle_edit");
        ActionMap actionMap = this.tree.getActionMap();
        final Action expandAction = actionMap.get("expand");
        if (expandAction != null) {
            actionMap.put("expand_or_move_down", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean leaf;
                    TreePath selectionPath;
                    JTree tree;
                    int selectionRow;
                    Object source = e.getSource();
                    if (source instanceof JTree && (selectionRow = (tree = (JTree)source).getLeadSelectionRow()) != -1 && (selectionPath = tree.getPathForRow(selectionRow)) != null && ((leaf = tree.getModel().isLeaf(selectionPath.getLastPathComponent())) || tree.isExpanded(selectionRow))) {
                        int newRow = Math.min(selectionRow + 1, tree.getRowCount() - 1);
                        tree.setSelectionRow(newRow);
                        tree.scrollRowToVisible(newRow);
                        tree.repaint();
                        return;
                    }
                    expandAction.actionPerformed(e);
                    DarkTreeUI.this.tree.repaint();
                }
            });
        }
        actionMap.put("collapse_or_move_up", new TreeUIAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JTree) {
                    JTree tree = (JTree)source;
                    int selectionRow = tree.getLeadSelectionRow();
                    if (selectionRow == -1) {
                        return;
                    }
                    TreePath selectionPath = tree.getPathForRow(selectionRow);
                    if (selectionPath == null) {
                        return;
                    }
                    if (tree.getModel().isLeaf(selectionPath.getLastPathComponent()) || tree.isCollapsed(selectionRow)) {
                        TreePath parentPath = tree.getPathForRow(selectionRow).getParentPath();
                        if (parentPath != null && (parentPath.getParentPath() != null || tree.isRootVisible())) {
                            int parentRow = tree.getRowForPath(parentPath);
                            tree.scrollRowToVisible(parentRow);
                            tree.setSelectionRow(parentRow);
                        }
                    } else {
                        tree.collapseRow(selectionRow);
                    }
                    tree.repaint();
                }
            }
        });
        actionMap.put("move_up", new TreeUIAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JTree) {
                    JTree tree = (JTree)source;
                    int selectionRow = tree.getLeadSelectionRow();
                    if (selectionRow == -1) {
                        return;
                    }
                    int newRow = Math.min(selectionRow + 1, tree.getRowCount() - 1);
                    tree.setSelectionRow(newRow);
                    tree.scrollRowToVisible(newRow);
                    tree.repaint();
                }
            }
        });
        actionMap.put("move_down", new TreeUIAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JTree) {
                    JTree tree = (JTree)source;
                    int selectionRow = tree.getLeadSelectionRow();
                    if (selectionRow == -1) {
                        return;
                    }
                    int newRow = Math.max(selectionRow - 1, 0);
                    tree.setSelectionRow(newRow);
                    tree.scrollRowToVisible(newRow);
                    tree.repaint();
                }
            }
        });
        actionMap.put("toggle_edit", new TreeUIAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JTree) {
                    JTree tree = (JTree)source;
                    if (tree.isEditing()) {
                        DarkTreeUI.this.stopEditing(tree);
                        return;
                    }
                    int selectionRow = tree.getLeadSelectionRow();
                    if (selectionRow == -1) {
                        return;
                    }
                    DarkTreeUI.this.startEditingAtPath(tree, DarkTreeUI.this.getPathForRow(tree, selectionRow));
                }
            }
        });
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusListener(){
            boolean focused = false;

            @Override
            public void focusGained(FocusEvent e) {
                if (!this.focused) {
                    DarkTreeUI.this.tree.repaint();
                }
                this.focused = true;
            }

            @Override
            public void focusLost(FocusEvent e) {
                DarkTreeUI.this.tree.stopEditing();
                this.focused = DarkTreeUI.this.hasFocus(e != null ? e.getOppositeComponent() : null);
                if (!this.focused) {
                    DarkTreeUI.this.tree.repaint();
                }
            }
        };
    }

    protected boolean hasFocus() {
        return this.hasFocus(null);
    }

    protected boolean hasFocus(Component other) {
        Component owner = other;
        if (!DarkUIUtil.hasFocus(this.tree)) {
            if (owner == null) {
                owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            }
            boolean treeEditor = owner instanceof JComponent && Boolean.TRUE.equals(((JComponent)owner).getClientProperty("JToggleButton.isTreeCellEditor"));
            boolean treeRenderer = owner instanceof JComponent && Boolean.TRUE.equals(((JComponent)owner).getClientProperty("JToggleButton.isTreeCellRenderer"));
            return treeEditor || treeRenderer;
        }
        return true;
    }

    @Override
    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DarkTreeCellRenderer) {
            return new DarkDefaultTreeEditor(this.tree, (DarkTreeCellRenderer)this.currentCellRenderer);
        }
        return new DarkDefaultTreeEditor(this.tree, null);
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DarkTreeCellRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        UIManager.put("Tree.repaintWholeRow", this.myOldRepaintAllRowValue);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tree.removeMouseListener(this.selectionListener);
        this.tree.removePropertyChangeListener(this);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.tree != c) {
            throw new InternalError("incorrect component");
        }
        if (this.treeState == null) {
            return;
        }
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int row = this.treeState.getRowForPath(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        this.drawingCache.clear();
        if (initialPath != null && paintingEnumerator != null) {
            Rectangle bounds;
            boolean isExpanded;
            boolean hasBeenExpanded;
            boolean isLeaf;
            TreePath path;
            TreePath parentPath = initialPath;
            boolean done = false;
            Rectangle boundsBuffer = new Rectangle();
            boolean rootVisible = this.isRootVisible();
            Enumeration<TreePath> backgroundEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
            while (backgroundEnumerator != null && backgroundEnumerator.hasMoreElements()) {
                path = backgroundEnumerator.nextElement();
                if (path == null) continue;
                isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                if (isLeaf) {
                    hasBeenExpanded = false;
                    isExpanded = false;
                } else {
                    isExpanded = this.treeState.getExpandedState(path);
                    hasBeenExpanded = this.tree.hasBeenExpanded(path);
                }
                bounds = this.getPathBounds(path, insets, boundsBuffer);
                if (bounds == null) {
                    return;
                }
                this.paintRowBackground(g, paintBounds, insets, bounds, path, this.tree.getRowForPath(path), isExpanded, hasBeenExpanded, isLeaf);
            }
            while (parentPath != null) {
                this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                this.drawingCache.put(parentPath, Boolean.TRUE);
                parentPath = parentPath.getParentPath();
            }
            while (!done && paintingEnumerator.hasMoreElements()) {
                path = paintingEnumerator.nextElement();
                if (path != null) {
                    isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    bounds = this.getPathBounds(path, insets, boundsBuffer);
                    if (bounds == null) {
                        return;
                    }
                    parentPath = path.getParentPath();
                    if (parentPath != null) {
                        if (this.drawingCache.get(parentPath) == null) {
                            this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                            this.drawingCache.put(parentPath, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    } else if (rootVisible && row == 0) {
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                        this.paintExpandControl(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    this.paintRow(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        }
        this.paintDropLine(g);
        this.rendererPane.removeAll();
        this.drawingCache.clear();
    }

    protected Rectangle getPathBounds(TreePath path, Insets insets, Rectangle bounds) {
        if ((bounds = this.treeState.getBounds(path, bounds)) != null) {
            bounds.x = this.tree.getComponentOrientation().isLeftToRight() ? (bounds.x += insets.left) : this.tree.getWidth() - (bounds.x + bounds.width) - insets.right;
            bounds.y += insets.top;
        }
        return bounds;
    }

    protected void paintRowBackground(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int xOffset;
        int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
        int n = xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
        if (path != null) {
            boolean selected = this.tree.isPathSelected(path);
            Graphics2D rowGraphics = (Graphics2D)g.create();
            rowGraphics.setClip(clipBounds);
            rowGraphics.setColor(this.getRowBackground(row, selected));
            rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
            super.paintRow(rowGraphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            rowGraphics.dispose();
        }
    }

    protected Color getRowBackground(int row, boolean selected) {
        if (selected) {
            boolean isTableTree = Boolean.TRUE.equals(this.tree.getClientProperty(KEY_TREE_TABLE_TREE));
            return this.getTreeSelectionBackground(this.hasFocus() || isTableTree || this.tree.isEditing());
        }
        if (Boolean.TRUE.equals(this.tree.getClientProperty(KEY_ALTERNATE_ROW_COLOR)) && row % 2 == 1) {
            return this.alternativeBackground;
        }
        return this.tree.getBackground();
    }

    protected boolean shouldPaintLines() {
        return !STYLE_NONE.equals(this.getLineStyle());
    }

    protected Color getLineColor(TreePath path) {
        if (this.selectedChildOf(path)) {
            if (this.tree.hasFocus() || this.tree.isEditing()) {
                return this.focusSelectedLineColor;
            }
            return this.selectedLineColor;
        }
        return this.lineColor;
    }

    protected Icon getExpandedIcon(boolean selected, boolean focused) {
        if (selected) {
            return focused ? this.expandedFocusSelected : this.expandedSelected;
        }
        return focused ? this.expandedFocus : this.expanded;
    }

    protected Icon getCollapsedIcon(boolean selected, boolean focused) {
        if (selected) {
            return focused ? this.collapsedFocusSelected : this.collapsedSelected;
        }
        return focused ? this.collapsedFocus : this.collapsed;
    }

    protected Color getTreeSelectionBackground(boolean focused) {
        return focused ? this.focusSelectionBackground : this.selectionBackground;
    }

    protected String getLineStyle() {
        return String.valueOf(this.tree.getClientProperty(KEY_LINE_STYLE));
    }

    protected boolean selectedChildOf(TreePath path) {
        TreePath p = this.tree.getSelectionPath();
        if (p == null) {
            return false;
        }
        if (p == path) {
            return true;
        }
        if (this.tree.isExpanded(p)) {
            return false;
        }
        return p.getParentPath() == path;
    }

    protected boolean isDashedLine() {
        return STYLE_DASHED.equals(this.getLineStyle());
    }

    private void drawDashedLine(Graphics g, int x, int y1, int y2) {
        if (y1 >= y2) {
            return;
        }
        y1 += y1 % 2;
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        BasicStroke dashedStroke = new BasicStroke(2.0f, 0, 1, 0.0f, new float[]{2.0f}, 0.0f);
        g2d.setStroke(dashedStroke);
        g2d.drawLine(x, y1, x, y2);
        g2d.setStroke(oldStroke);
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        int bottom;
        Object root;
        TreeModel model;
        if (!this.shouldPaintLines()) {
            return;
        }
        int depth = path.getPathCount() - 1;
        if (depth == 0 && !this.getShowsRootHandles() && !this.isRootVisible()) {
            return;
        }
        if (this.treeModel.isLeaf(path.getLastPathComponent()) || !this.tree.isExpanded(path)) {
            return;
        }
        int clipLeft = clipBounds.x;
        int clipRight = clipBounds.x + (clipBounds.width - 1);
        int clipTop = clipBounds.y;
        int clipBottom = clipBounds.y + this.tree.getHeight();
        Rectangle parentBounds = this.getPathBounds(this.tree, path);
        int lineX = this.getRowX(-1, depth);
        lineX = this.tree.getComponentOrientation().isLeftToRight() ? lineX - this.getRightChildIndent() + insets.left : this.tree.getWidth() - lineX - insets.right + this.getRightChildIndent() - 1;
        if (lineX > clipRight || lineX < clipLeft) {
            return;
        }
        int top = parentBounds == null ? Math.max(insets.top + this.getVerticalLegBuffer(), clipTop) : Math.max(parentBounds.y + parentBounds.height + this.getVerticalLegBuffer(), clipTop);
        if (depth == 0 && !this.isRootVisible() && (model = this.getModel()) != null && model.getChildCount(root = model.getRoot()) > 0 && (parentBounds = this.getPathBounds(this.tree, path.pathByAddingChild(model.getChild(root, 0)))) != null) {
            top = Math.max(insets.top + this.getVerticalLegBuffer(), parentBounds.y + parentBounds.height / 2);
        }
        int childCount = this.treeModel.getChildCount(path.getLastPathComponent());
        g.setColor(this.getLineColor(path));
        for (int i = 0; i < childCount - 1; ++i) {
            TreePath childPath = path.pathByAddingChild(this.treeModel.getChild(path.getLastPathComponent(), i));
            Rectangle childBounds = this.getPathBounds(this.tree, childPath);
            if (childBounds == null) continue;
            bottom = Math.min(childBounds.y + childBounds.height, clipBottom);
            this.paintVerticalLine(g, this.tree, lineX, top, bottom);
            top = bottom;
            if (clipBottom >= top) continue;
            return;
        }
        TreePath lastChildPath = path.pathByAddingChild(this.treeModel.getChild(path.getLastPathComponent(), childCount - 1));
        while (this.tree.isExpanded(lastChildPath)) {
            int count = this.treeModel.getChildCount(lastChildPath.getLastPathComponent());
            lastChildPath = lastChildPath.pathByAddingChild(this.treeModel.getChild(lastChildPath.getLastPathComponent(), count - 1));
        }
        Rectangle childBounds = this.getPathBounds(this.tree, lastChildPath);
        if (childBounds != null) {
            bottom = Math.min(childBounds.y + childBounds.height, clipBottom);
            this.paintVerticalLine(g, this.tree, lineX, top, bottom);
        }
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (!this.isLeaf(row)) {
            boolean isPathSelected = this.tree.getSelectionModel().isPathSelected(path);
            this.setExpandedIcon(this.getExpandedIcon(isPathSelected, this.tree.hasFocus() || this.tree.isEditing()));
            this.setCollapsedIcon(this.getCollapsedIcon(isPathSelected, this.tree.hasFocus() || this.tree.isEditing()));
        }
        super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (this.isDashedLine()) {
            this.drawDashedLine(g, x, top, bottom);
        } else {
            g.fillRect(x, top, 1, bottom - top);
        }
    }

    @Override
    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, true);
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent e) {
        return SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (KEY_ALTERNATE_ROW_COLOR.equals(key)) {
            this.tree.repaint();
        } else if (KEY_RENDER_BOOLEAN_AS_CHECKBOX.equals(key)) {
            this.tree.repaint();
        } else if (KEY_BOOLEAN_RENDER_TYPE.equals(key)) {
            this.tree.repaint();
        } else if (KEY_LINE_STYLE.equals(key)) {
            this.tree.repaint();
        }
    }

    private static abstract class TreeUIAction
    extends AbstractAction
    implements UIResource {
        private TreeUIAction() {
        }
    }
}

