/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.ui.cell.DarkCellRendererToggleButton;
import com.github.weisj.darklaf.ui.tree.DarkTreeCellEditor;
import com.github.weisj.darklaf.ui.tree.DarkTreeCellRenderer;
import com.github.weisj.darklaf.ui.tree.TreeCellEditorDelegate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class DarkDefaultTreeEditor
extends DefaultTreeCellEditor {
    private static final DarkTreeCellEditor checkBoxEditor = new DarkTreeCellEditor(new JCheckBox());
    private static final DarkTreeCellEditor radioButtonEditor = new DarkTreeCellEditor(new JRadioButton());

    public DarkDefaultTreeEditor(JTree tree, DarkTreeCellRenderer renderer) {
        this(tree, renderer, null);
    }

    public DarkDefaultTreeEditor(final JTree tree, DarkTreeCellRenderer renderer, DarkTreeCellEditor editor) {
        super(tree, renderer, editor);
        this.realEditor = new TreeCellEditorDelegate(this.realEditor){

            @Override
            public Object getCellEditorValue() {
                if (DarkDefaultTreeEditor.this.isBooleanRenderer(tree, DarkDefaultTreeEditor.this.lastRow)) {
                    return DarkDefaultTreeEditor.this.getBooleanEditor(tree).getCellEditorValue();
                }
                return super.getCellEditorValue();
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (DarkDefaultTreeEditor.this.isBooleanRenderer(tree, tree.getLeadSelectionRow())) {
                    return DarkDefaultTreeEditor.this.getBooleanEditor(tree).isCellEditable(anEvent);
                }
                return super.isCellEditable(anEvent);
            }
        };
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        Component comp = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        comp.setComponentOrientation(tree.getComponentOrientation());
        if (this.isBooleanRenderer(tree, row)) {
            ((Container)comp).remove(this.editingComponent);
            this.editingComponent = this.getBooleanEditor(tree).getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            this.editingComponent.setFont(tree.getFont());
            ((Container)comp).add(this.editingComponent);
        }
        return comp;
    }

    protected DarkTreeCellEditor getBooleanEditor(JTree table) {
        if ("radioButton".equals(table.getClientProperty("JTree.booleanRenderType"))) {
            return radioButtonEditor;
        }
        return checkBoxEditor;
    }

    protected boolean isBooleanRenderer(JTree tree, int row) {
        boolean isBoolRenderer;
        boolean bl = isBoolRenderer = this.realEditor instanceof DarkTreeCellEditor && ((DarkTreeCellEditor)this.realEditor).isBooleanEditor(tree);
        if (isBoolRenderer) {
            return true;
        }
        TreePath path = tree.getPathForRow(row);
        return path != null && DarkTreeCellRenderer.unwrapBooleanIfPossible(path.getLastPathComponent()) instanceof Boolean;
    }

    @Override
    public Object getCellEditorValue() {
        return super.getCellEditorValue();
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    protected boolean canEditImmediately(EventObject event) {
        if (event != null && event.getSource() instanceof JTree) {
            JTree tree = (JTree)event.getSource();
            TreeCellRenderer renderer = tree.getCellRenderer();
            if (event instanceof MouseEvent) {
                Rectangle bounds;
                Point p = ((MouseEvent)event).getPoint();
                int row = tree.getRowForLocation(p.x, p.y);
                if (this.isBooleanRenderer(tree, row) && renderer instanceof DarkTreeCellRenderer && (bounds = tree.getRowBounds(row)) != null) {
                    DarkTreeCellRenderer rend = (DarkTreeCellRenderer)renderer;
                    DarkCellRendererToggleButton booleanRend = rend.getBooleanRenderer(tree);
                    JToggleButton button = booleanRend.getButton();
                    p.x -= bounds.x + button.getX();
                    p.y -= bounds.y + button.getY();
                    button.putClientProperty("JToggleButton.clearHitArea", true);
                    return button.contains(p);
                }
            }
        }
        return super.canEditImmediately(event);
    }
}

