/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tooltip;

import com.github.weisj.darklaf.components.border.BubbleBorder;
import com.github.weisj.darklaf.components.border.DropShadowBorder;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DarkTooltipBorder
implements Border {
    private static final int shadowSize = 12;
    private static final int cornerSize = 24;
    private static final float opacity = 0.1f;
    private final DropShadowBorder shadowBorder = new DropShadowBorder(Color.BLACK, 12, 0.1f, 24, false, true, true, true);
    private final BubbleBorder bubbleBorder = new BubbleBorder(UIManager.getColor("ToolTip.borderColor"));

    public DarkTooltipBorder() {
        this.bubbleBorder.setThickness(1);
        this.bubbleBorder.setPointerSize(8);
        this.bubbleBorder.setPointerWidth(12);
        this.bubbleBorder.setPointerSide(Alignment.CENTER);
        this.shadowBorder.setShadowColor(UIManager.getColor("ToolTip.borderShadowColor"));
    }

    public Area getBackgroundArea(Component c, int width, int height) {
        if (this.isPlain(c)) {
            return new Area(new Rectangle(0, 0, width, height));
        }
        Insets ins = this.shadowBorder.getBorderInsets(null);
        this.adjustInsets(ins);
        return this.bubbleBorder.getInnerArea(ins.left, ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom);
    }

    public int getPointerOffset(Component c, Dimension dimension) {
        if (this.isPlain(c)) {
            return 0;
        }
        return this.bubbleBorder.getOffset(dimension.width - 2 * this.shadowBorder.getShadowSize(), dimension.height) + this.shadowBorder.getShadowSize();
    }

    private void adjustInsets(Insets si) {
        Alignment align = this.bubbleBorder.getPointerSide();
        if (align == Alignment.SOUTH || align == Alignment.SOUTH_EAST || align == Alignment.SOUTH_WEST) {
            si.bottom = 0;
        } else if (align == Alignment.EAST) {
            si.right = 0;
        } else if (align == Alignment.WEST) {
            si.left = 0;
        } else if (align == Alignment.NORTH_EAST || align == Alignment.NORTH || align == Alignment.NORTH_WEST) {
            si.top = 0;
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        GraphicsContext context = new GraphicsContext(g);
        if (this.isPlain(c)) {
            g.setColor(this.bubbleBorder.getColor());
            DarkUIUtil.drawRect(g, x, y, width, height, 1);
            return;
        }
        if (c instanceof JToolTip && ((JToolTip)c).getTipText() == null) {
            return;
        }
        Insets ins = this.shadowBorder.getBorderInsets(c);
        this.adjustInsets(ins);
        Area bubbleArea = this.bubbleBorder.getInnerArea(x + ins.left, y + ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom);
        if (UIManager.getBoolean("ToolTip.paintShadow")) {
            this.paintShadow(c, g, x, y, width, height, bubbleArea);
        }
        this.bubbleBorder.paintBorder(g, bubbleArea);
        context.restore();
    }

    public void paintShadow(Component c, Graphics g, int x, int y, int width, int height, Area bubbleArea) {
        Shape oldClip = g.getClip();
        Area clip = new Area(new Rectangle2D.Double(x, y, width, height));
        clip.subtract(bubbleArea);
        g.setClip(clip);
        int bw = this.bubbleBorder.getThickness();
        int off = 0;
        Alignment pointerSide = this.bubbleBorder.getPointerSide();
        if (pointerSide == Alignment.NORTH || pointerSide == Alignment.NORTH_EAST || pointerSide == Alignment.NORTH_WEST) {
            off = this.bubbleBorder.getPointerSize();
        }
        this.shadowBorder.paintBorder(c, g, x + bw, y + bw + off, width - 2 * bw, height - 2 * bw - off);
        g.setClip(oldClip);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets uIns = this.getUserInsets(c);
        if (this.isPlain(c)) {
            return new Insets(1 + uIns.top, 1 + uIns.left, 1 + uIns.bottom, 1 + uIns.right);
        }
        Insets ins = new Insets(0, 0, 0, 0);
        Insets bi = this.bubbleBorder.getBorderInsets(c);
        Insets si = this.shadowBorder.getBorderInsets(c);
        ins.bottom = Math.max(bi.bottom, si.bottom);
        ins.left = Math.max(bi.left, si.left);
        ins.right = Math.max(bi.right, si.right);
        ins.top = Math.max(bi.top, si.top);
        ins.left += 5 + uIns.left;
        ins.top += 5 + uIns.top;
        ins.right += 5 + uIns.right;
        ins.bottom += 5 + uIns.bottom;
        return ins;
    }

    protected Insets getUserInsets(Component c) {
        Object obj;
        if (c instanceof JComponent && (obj = ((JComponent)c).getClientProperty("JToolTip.insets")) instanceof Insets) {
            return (Insets)obj;
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setPointerLocation(Alignment side) {
        this.bubbleBorder.setPointerSide(side);
    }

    public void setPointerWidth(int width) {
        this.bubbleBorder.setPointerWidth(width);
    }

    public void setPointerHeight(int height) {
        this.bubbleBorder.setPointerSize(height);
    }

    protected boolean isPlain(Component c) {
        if (!(c instanceof JComponent)) {
            return false;
        }
        Object prop = ((JComponent)c).getClientProperty("JToolTip.style");
        return prop == ToolTipStyle.PLAIN || "plain".equals(prop);
    }

    public int getShadowSize(Component c) {
        if (this.isPlain(c)) {
            return 0;
        }
        return this.shadowBorder.getShadowSize();
    }
}

