/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class SelectWordAction
extends TextAction {
    protected final Action start = new BeginWordAction("darklaf", false);
    protected final Action end = new EndWordAction("darklaf", true);

    public SelectWordAction() {
        super("select-word");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.start.actionPerformed(e);
        this.end.actionPerformed(e);
    }

    public static class BeginWordAction
    extends TextAction {
        private final boolean select;

        public BeginWordAction(String name, boolean select) {
            super(name);
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JTextComponent textArea = this.getTextComponent(e);
                int offs = textArea.getCaretPosition();
                int begOffs = this.getWordStart(textArea, offs);
                if (this.select) {
                    textArea.moveCaretPosition(begOffs);
                } else {
                    textArea.setCaretPosition(begOffs);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }

        public int getWordStart(JTextComponent textArea, int offs) throws BadLocationException {
            return Utilities.getWordStart(textArea, offs);
        }
    }

    public static class EndWordAction
    extends TextAction {
        private final boolean select;

        public EndWordAction(String name, boolean select) {
            super(name);
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JTextComponent textArea = this.getTextComponent(e);
                int offs = textArea.getCaretPosition();
                int endOffs = this.getWordEnd(textArea, offs);
                if (this.select) {
                    textArea.moveCaretPosition(endOffs);
                } else {
                    textArea.setCaretPosition(endOffs);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }

        protected int getWordEnd(JTextComponent textArea, int offs) throws BadLocationException {
            return Utilities.getWordEnd(textArea, offs);
        }
    }
}

